/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import quickfix.FileUtil;
import quickfix.Log;
import quickfix.LogUtil;
import quickfix.SessionID;
import quickfix.SystemTime;
import quickfix.field.converter.UtcTimestampConverter;

public class FileLog
implements Log {
    private static final byte[] TIME_STAMP_DELIMETER = ": ".getBytes();
    private SessionID sessionID;
    private String messagesFileName;
    private String eventFileName;
    private boolean syncAfterWrite;
    private FileOutputStream messages;
    private FileOutputStream events;
    private boolean includeMillis;
    private boolean includeTimestampForMessages;

    FileLog(String path, SessionID sessionID, boolean includeMillis, boolean includeTimestampForMessages) throws FileNotFoundException {
        String sessionName = sessionID.getBeginString() + "-" + sessionID.getSenderCompID() + "-" + sessionID.getTargetCompID();
        this.sessionID = sessionID;
        if (sessionID.getSessionQualifier() != null && sessionID.getSessionQualifier().length() > 0) {
            sessionName = sessionName + "-" + sessionID.getSessionQualifier();
        }
        String prefix = FileUtil.fileAppendPath(path, sessionName + ".");
        this.messagesFileName = prefix + "messages.log";
        this.eventFileName = prefix + "event.log";
        File directory = new File(this.messagesFileName).getParentFile();
        if (!directory.exists()) {
            directory.mkdirs();
        }
        this.includeMillis = includeMillis;
        this.includeTimestampForMessages = includeTimestampForMessages;
        this.openLogStreams(true);
    }

    private void openLogStreams(boolean append) throws FileNotFoundException {
        this.messages = new FileOutputStream(this.messagesFileName, append);
        this.events = new FileOutputStream(this.eventFileName, append);
    }

    public void onIncoming(String message) {
        this.writeMessage(message);
    }

    public void onOutgoing(String message) {
        this.writeMessage(message);
    }

    private void writeMessage(String message) {
        try {
            if (this.includeTimestampForMessages) {
                this.writeTimeStamp(this.messages);
            }
            this.messages.write(message.getBytes());
            this.messages.write(10);
            this.messages.flush();
            if (this.syncAfterWrite) {
                this.messages.getFD().sync();
            }
        }
        catch (IOException e) {
            LogUtil.logThrowable(this.sessionID, "error writing message to log", (Throwable)e);
        }
    }

    public void onEvent(String message) {
        try {
            this.writeTimeStamp(this.events);
            this.events.write(message.getBytes());
            this.events.write(10);
            this.events.flush();
            if (this.syncAfterWrite) {
                this.events.getFD().sync();
            }
        }
        catch (IOException e) {
            LogUtil.logThrowable(this.sessionID, "error writing event to log", (Throwable)e);
        }
    }

    private void writeTimeStamp(OutputStream out) throws IOException {
        String formattedTime = UtcTimestampConverter.convert(SystemTime.getDate(), this.includeMillis);
        out.write(formattedTime.getBytes());
        out.write(TIME_STAMP_DELIMETER);
    }

    String getEventFileName() {
        return this.eventFileName;
    }

    String getMessagesFileName() {
        return this.messagesFileName;
    }

    public void setSyncAfterWrite(boolean syncAfterWrite) {
        this.syncAfterWrite = syncAfterWrite;
    }

    void close() throws IOException {
        this.messages.close();
        this.events.close();
    }

    public void clear() {
        try {
            this.close();
            this.openLogStreams(false);
        }
        catch (IOException e) {
            System.err.println("Could not clear log: " + this.getClass().getName());
        }
    }
}

