/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import quickfix.BooleanField;
import quickfix.CharField;
import quickfix.DoubleField;
import quickfix.Field;
import quickfix.FieldConvertError;
import quickfix.FieldException;
import quickfix.FieldNotFound;
import quickfix.Group;
import quickfix.IntField;
import quickfix.MessageComponent;
import quickfix.RuntimeError;
import quickfix.StringField;
import quickfix.UtcDateOnlyField;
import quickfix.UtcTimeOnlyField;
import quickfix.UtcTimeStampField;
import quickfix.field.converter.BooleanConverter;
import quickfix.field.converter.CharConverter;
import quickfix.field.converter.DoubleConverter;
import quickfix.field.converter.IntConverter;
import quickfix.field.converter.UtcDateOnlyConverter;
import quickfix.field.converter.UtcTimeOnlyConverter;
import quickfix.field.converter.UtcTimestampConverter;

public abstract class FieldMap
implements Serializable {
    static final long serialVersionUID = -3193357271891865972L;
    private final int[] fieldOrder;
    private final TreeMap fields;
    private final TreeMap groups = new TreeMap();

    protected FieldMap(int[] fieldOrder) {
        this.fieldOrder = fieldOrder;
        this.fields = new TreeMap(fieldOrder != null ? new FieldOrderComparator() : null);
    }

    protected FieldMap() {
        this(null);
    }

    public int[] getFieldOrder() {
        return this.fieldOrder;
    }

    public void clear() {
        this.fields.clear();
        this.groups.clear();
    }

    public boolean isEmpty() {
        return this.fields.size() == 0;
    }

    public void setFields(FieldMap fieldMap) {
        this.fields.clear();
        this.fields.putAll(fieldMap.fields);
    }

    protected void setComponent(MessageComponent component) {
        component.copyTo(this);
    }

    protected void getComponent(MessageComponent component) {
        component.clear();
        component.copyFrom(this);
    }

    public void setGroups(FieldMap fieldMap) {
        this.groups.clear();
        this.groups.putAll(fieldMap.groups);
    }

    protected void setGroups(int key, List groupList) {
        this.groups.put(new Integer(key), groupList);
    }

    public void setString(int field, String value) {
        this.setField(new StringField(field, value));
    }

    public void setBoolean(int field, boolean value) {
        String s = BooleanConverter.convert(value);
        this.setField(new StringField(field, s));
    }

    public void setChar(int field, char value) {
        String s = CharConverter.convert(value);
        this.setField(new StringField(field, s));
    }

    public void setInt(int field, int value) {
        String s = IntConverter.convert(value);
        this.setField(new StringField(field, s));
    }

    public void setDouble(int field, double value) {
        this.setDouble(field, value, 0);
    }

    public void setDouble(int field, double value, int padding) {
        String s = DoubleConverter.convert(value, padding);
        this.setField(new StringField(field, s));
    }

    public void setUtcTimeStamp(int field, Date value) {
        this.setUtcTimeStamp(field, value, false);
    }

    public void setUtcTimeStamp(int field, Date value, boolean includeMilliseconds) {
        String s = UtcTimestampConverter.convert(value, includeMilliseconds);
        this.setField(new StringField(field, s));
    }

    public void setUtcTimeOnly(int field, Date value) {
        this.setUtcTimeOnly(field, value, false);
    }

    public void setUtcTimeOnly(int field, Date value, boolean includeMillseconds) {
        String s = UtcTimeOnlyConverter.convert(value, includeMillseconds);
        this.setField(new StringField(field, s));
    }

    public void setUtcDateOnly(int field, Date value) {
        String s = UtcDateOnlyConverter.convert(value);
        this.setField(new StringField(field, s));
    }

    public String getString(int field) throws FieldNotFound {
        return this.getField(field).getObject().toString();
    }

    StringField getField(int field) throws FieldNotFound {
        StringField f = (StringField)this.fields.get(new Integer(field));
        if (f == null) {
            throw new FieldNotFound(field);
        }
        return f;
    }

    Field getField(int field, Field defaultValue) {
        Field f = (Field)this.fields.get(new Integer(field));
        if (f == null) {
            return defaultValue;
        }
        return f;
    }

    public boolean getBoolean(int field) throws FieldNotFound {
        String value = this.getField(field).getValue();
        try {
            return BooleanConverter.convert(value);
        }
        catch (FieldConvertError e) {
            throw this.newIncorrectDataException(e, field);
        }
    }

    public char getChar(int field) throws FieldNotFound {
        String value = this.getField(field).getValue();
        try {
            return CharConverter.convert(value);
        }
        catch (FieldConvertError e) {
            throw this.newIncorrectDataException(e, field);
        }
    }

    public int getInt(int field) throws FieldNotFound {
        String value = this.getField(field).getValue();
        try {
            return IntConverter.convert(value);
        }
        catch (FieldConvertError e) {
            throw this.newIncorrectDataException(e, field);
        }
    }

    public double getDouble(int field) throws FieldNotFound {
        String value = this.getField(field).getValue();
        try {
            return DoubleConverter.convert(value);
        }
        catch (FieldConvertError e) {
            throw this.newIncorrectDataException(e, field);
        }
    }

    public Date getUtcTimeStamp(int field) throws FieldNotFound {
        String value = this.getField(field).getValue();
        try {
            return UtcTimestampConverter.convert(value);
        }
        catch (FieldConvertError e) {
            throw this.newIncorrectDataException(e, field);
        }
    }

    public Date getUtcTimeOnly(int field) throws FieldNotFound {
        String value = this.getField(field).getValue();
        try {
            return UtcTimeOnlyConverter.convert(value);
        }
        catch (FieldConvertError e) {
            throw this.newIncorrectDataException(e, field);
        }
    }

    public Date getUtcDateOnly(int field) throws FieldNotFound {
        String value = this.getField(field).getValue();
        try {
            return UtcDateOnlyConverter.convert(value);
        }
        catch (FieldConvertError e) {
            throw this.newIncorrectDataException(e, field);
        }
    }

    protected void setField(int key, Object field) {
        this.fields.put(new Integer(key), field);
    }

    public void setField(StringField field) {
        if (field.getValue() == null) {
            throw new NullPointerException("Null field values are not allowed.");
        }
        Integer key = new Integer(field.getField());
        this.fields.put(key, field);
    }

    public void setField(BooleanField field) {
        this.setBoolean(field.getField(), field.getValue());
    }

    public void setField(CharField field) {
        this.setChar(field.getField(), field.getValue());
    }

    public void setField(IntField field) {
        this.setInt(field.getField(), field.getValue());
    }

    public void setField(DoubleField field) {
        this.setDouble(field.getField(), field.getValue());
    }

    public void setField(UtcTimeStampField field) {
        this.setUtcTimeStamp(field.getField(), field.getValue());
    }

    public void setField(UtcTimeOnlyField field) {
        this.setUtcTimeOnly(field.getField(), field.getValue());
    }

    public void setField(UtcDateOnlyField field) {
        this.setUtcDateOnly(field.getField(), field.getValue());
    }

    public StringField getField(StringField field) throws FieldNotFound {
        return (StringField)this.getFieldInternal(field);
    }

    private Field getFieldInternal(Field field) throws FieldNotFound {
        field.setObject(this.getField(field.getField()).getObject());
        return field;
    }

    public BooleanField getField(BooleanField field) throws FieldNotFound {
        try {
            String value = this.getField(field.getField()).getValue();
            field.setObject(new Boolean(BooleanConverter.convert(value)));
        }
        catch (FieldConvertError e) {
            throw this.newIncorrectDataException(e, field.getField());
        }
        catch (FieldNotFound e) {
            throw e;
        }
        return field;
    }

    public CharField getField(CharField field) throws FieldNotFound {
        try {
            String value = this.getField(field.getField()).getValue();
            field.setObject(new Character(CharConverter.convert(value)));
        }
        catch (FieldConvertError e) {
            throw this.newIncorrectDataException(e, field.getField());
        }
        catch (FieldNotFound e) {
            throw e;
        }
        return field;
    }

    public IntField getField(IntField field) throws FieldNotFound {
        try {
            String value = this.getField(field.getField()).getValue();
            field.setObject(new Integer(IntConverter.convert(value)));
        }
        catch (FieldConvertError e) {
            throw this.newIncorrectDataException(e, field.getField());
        }
        catch (FieldNotFound e) {
            throw e;
        }
        return field;
    }

    public DoubleField getField(DoubleField field) throws FieldNotFound {
        try {
            String value = this.getField(field.getField()).getValue();
            field.setObject(new Double(DoubleConverter.convert(value)));
        }
        catch (FieldConvertError e) {
            throw this.newIncorrectDataException(e, field.getField());
        }
        catch (FieldNotFound e) {
            throw e;
        }
        return field;
    }

    public UtcTimeStampField getField(UtcTimeStampField field) throws FieldNotFound {
        try {
            String value = this.getField(field.getField()).getValue();
            field.setObject(UtcTimestampConverter.convert(value));
        }
        catch (FieldConvertError e) {
            throw this.newIncorrectDataException(e, field.getField());
        }
        catch (FieldNotFound e) {
            throw e;
        }
        return field;
    }

    public UtcTimeOnlyField getField(UtcTimeOnlyField field) throws FieldNotFound {
        try {
            String value = this.getField(field.getField()).getValue();
            field.setObject(UtcTimeOnlyConverter.convert(value));
        }
        catch (FieldConvertError e) {
            throw this.newIncorrectDataException(e, field.getField());
        }
        catch (FieldNotFound e) {
            throw e;
        }
        return field;
    }

    public UtcDateOnlyField getField(UtcDateOnlyField field) throws FieldNotFound {
        try {
            String value = this.getField(field.getField()).getValue();
            field.setObject(UtcDateOnlyConverter.convert(value));
        }
        catch (FieldConvertError e) {
            throw this.newIncorrectDataException(e, field.getField());
        }
        catch (FieldNotFound e) {
            throw e;
        }
        return field;
    }

    private FieldException newIncorrectDataException(FieldConvertError e, int tag) {
        return new FieldException(6, e.getMessage(), tag);
    }

    public boolean isSetField(int field) {
        return this.fields.containsKey(new Integer(field));
    }

    public boolean isSetField(Field field) {
        return this.isSetField(field.getField());
    }

    public void removeField(int field) {
        this.fields.remove(new Integer(field));
    }

    public Iterator iterator() {
        return this.fields.values().iterator();
    }

    protected void initializeFrom(FieldMap source) {
        this.fields.clear();
        this.fields.putAll(source.fields);
        Iterator groupItr = source.groups.entrySet().iterator();
        while (groupItr.hasNext()) {
            Map.Entry entry = groupItr.next();
            ArrayList<Group> clonedMembers = new ArrayList<Group>();
            List groupMembers = (List)entry.getValue();
            for (int i = 0; i < groupMembers.size(); ++i) {
                Group originalGroup = (Group)groupMembers.get(i);
                Group clonedGroup = new Group(originalGroup.getFieldTag(), originalGroup.delim(), originalGroup.getFieldOrder());
                clonedGroup.initializeFrom(originalGroup);
                clonedMembers.add(clonedGroup);
            }
            this.groups.put(entry.getKey(), clonedMembers);
        }
    }

    private boolean isGroupField(int field) {
        return this.groups.containsKey(new Integer(field));
    }

    protected void calculateString(StringBuffer buffer, int[] preFields, int[] postFields) {
        List groups;
        Field field;
        if (preFields != null) {
            for (int i = 0; i < preFields.length; ++i) {
                field = this.getField(preFields[i], null);
                field.toString(buffer);
                buffer.append('\u0001');
            }
        }
        Iterator<Object> iter = this.fields.values().iterator();
        while (iter.hasNext()) {
            field = (Field)iter.next();
            int tag = field.getField();
            if (!(this.isOrderedField(tag, preFields) || this.isOrderedField(tag, postFields) || this.isGroupField(tag))) {
                field.toString(buffer);
                buffer.append('\u0001');
                continue;
            }
            if (!this.isGroupField(tag) || !this.isOrderedField(tag, this.fieldOrder) || this.getGroupCount(tag) <= 0) continue;
            groups = this.getGroups(tag);
            field.toString(buffer);
            buffer.append('\u0001');
            for (int i = 0; i < groups.size(); ++i) {
                FieldMap groupFields = (FieldMap)groups.get(i);
                groupFields.calculateString(buffer, preFields, postFields);
            }
        }
        iter = this.groups.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            Integer groupCountTag = (Integer)entry.getKey();
            if (this.isOrderedField(groupCountTag, this.fieldOrder)) continue;
            groups = (List)entry.getValue();
            IntField countField = new IntField((int)groupCountTag, groups.size());
            countField.toString(buffer);
            buffer.append('\u0001');
            for (int i = 0; i < groups.size(); ++i) {
                FieldMap groupFields = (FieldMap)groups.get(i);
                groupFields.calculateString(buffer, preFields, postFields);
            }
        }
        if (postFields != null) {
            for (int i = 0; i < postFields.length; ++i) {
                field = this.getField(postFields[i], null);
                field.toString(buffer);
                buffer.append('\u0001');
            }
        }
    }

    private boolean isOrderedField(int field, int[] afieldOrder) {
        if (afieldOrder != null) {
            for (int i = 0; i < afieldOrder.length; ++i) {
                if (field != afieldOrder[i]) continue;
                return true;
            }
        }
        return false;
    }

    int calculateLength() {
        int result = 0;
        int length = 0;
        Iterator iter = this.fields.values().iterator();
        while (iter.hasNext()) {
            Field field = (Field)iter.next();
            if (field.getField() == 8 || field.getField() == 9 || field.getField() == 10 || this.isGroupField(field.getField())) continue;
            length = field.getLength();
            result += length;
        }
        Iterator iterator = this.groups.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            List groupList = (List)entry.getValue();
            IntField groupField = new IntField((Integer)entry.getKey());
            groupField.setValue(groupList.size());
            length = groupField.getLength();
            result += length;
            for (int i = 0; i < groupList.size(); ++i) {
                Group group = (Group)groupList.get(i);
                length = group.calculateLength();
                result += length;
            }
        }
        return result;
    }

    int calculateTotal() {
        int result = 0;
        Iterator iter = this.fields.values().iterator();
        while (iter.hasNext()) {
            Field field = (Field)iter.next();
            if (field.getField() == 10 || this.isGroupField(field.getField())) continue;
            result += field.getTotal();
        }
        Iterator iterator = this.groups.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            List groupList = (List)entry.getValue();
            IntField groupField = new IntField((Integer)entry.getKey());
            groupField.setValue(groupList.size());
            result += groupField.getTotal();
            for (int i = 0; i < groupList.size(); ++i) {
                Group group = (Group)groupList.get(i);
                result += group.calculateTotal();
            }
        }
        return result;
    }

    int getGroupCount(int tag) {
        return this.getGroups(tag).size();
    }

    public Iterator groupKeyIterator() {
        return this.groups.keySet().iterator();
    }

    Map getGroups() {
        return this.groups;
    }

    public void addGroup(Group group) {
        int countTag = group.getFieldTag();
        List currentGroups = this.getGroups(countTag);
        currentGroups.add(new Group(group));
        this.setGroupCount(countTag, currentGroups.size());
    }

    private void setGroupCount(int countTag, int groupSize) {
        try {
            StringField count;
            if (groupSize == 1) {
                count = new StringField(countTag, "1");
                this.setField(countTag, count);
            } else {
                count = this.getField(countTag);
            }
            count.setValue(Integer.toString(groupSize));
        }
        catch (FieldNotFound e) {
            throw new RuntimeError(e);
        }
    }

    List getGroups(int field) {
        ArrayList groupList = (ArrayList)this.groups.get(new Integer(field));
        if (groupList == null) {
            groupList = new ArrayList();
            this.groups.put(new Integer(field), groupList);
        }
        return groupList;
    }

    public Group getGroup(int num, Group group) throws FieldNotFound {
        List groupList = this.getGroups(group.getFieldTag());
        if (num > groupList.size()) {
            throw new FieldNotFound(group.getFieldTag() + ", index=" + num);
        }
        group.setFields((Group)groupList.get(num - 1));
        group.setGroups((Group)groupList.get(num - 1));
        return group;
    }

    public void replaceGroup(int num, Group group) {
        int offset = num - 1;
        List groupList = this.getGroups(group.getFieldTag());
        if (offset < 0 || offset >= groupList.size()) {
            return;
        }
        groupList.set(offset, new Group(group));
    }

    public void removeGroup(int field) {
        this.getGroups(field).clear();
        this.removeField(field);
    }

    public void removeGroup(int num, int field) {
        List groupList = this.getGroups(field);
        if (num <= groupList.size()) {
            groupList.remove(num - 1);
        }
        this.setGroupCount(field, groupList.size());
    }

    public void removeGroup(int num, Group group) {
        this.removeGroup(num, group.getFieldTag());
    }

    public void removeGroup(Group group) {
        this.removeGroup(group.getFieldTag());
    }

    public boolean hasGroup(int field) {
        return this.groups.containsKey(new Integer(field));
    }

    public boolean hasGroup(int num, int field) {
        return this.hasGroup(field) && num <= this.getGroups(field).size();
    }

    public boolean hasGroup(int num, Group group) {
        return this.hasGroup(num, group.getFieldTag());
    }

    public boolean hasGroup(Group group) {
        return this.hasGroup(group.getFieldTag());
    }

    private class FieldOrderComparator
    implements Comparator,
    Serializable {
        static final long serialVersionUID = 3416006398018829270L;

        private FieldOrderComparator() {
        }

        public int compare(Object o1, Object o2) {
            Integer tag1 = (Integer)o1;
            Integer tag2 = (Integer)o2;
            int index1 = this.indexOf(tag1, FieldMap.this.getFieldOrder());
            int index2 = this.indexOf(tag2, FieldMap.this.getFieldOrder());
            if (index1 != Integer.MAX_VALUE && index2 != Integer.MAX_VALUE) {
                return index1 != index2 ? (index1 < index2 ? -1 : 1) : 0;
            }
            if (index1 == Integer.MAX_VALUE || index2 == Integer.MAX_VALUE) {
                if (index1 != index2) {
                    return index1 == Integer.MAX_VALUE ? 1 : -1;
                }
                return tag1.intValue() != tag2.intValue() ? (tag1 < tag2 ? -1 : 1) : 0;
            }
            return tag1.intValue() != tag2.intValue() ? (tag1 < tag2 ? -1 : 1) : 0;
        }

        private int indexOf(int tag, int[] order) {
            if (order != null) {
                for (int i = 0; i < order.length; ++i) {
                    if (tag != order[i]) continue;
                    return i;
                }
            }
            return Integer.MAX_VALUE;
        }
    }
}

