/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import quickfix.ConfigError;
import quickfix.Field;
import quickfix.FieldConvertError;
import quickfix.FieldException;
import quickfix.FieldMap;
import quickfix.FieldNotFound;
import quickfix.FieldType;
import quickfix.IncorrectTagValue;
import quickfix.Message;
import quickfix.StringField;
import quickfix.UnsupportedVersion;
import quickfix.field.converter.BooleanConverter;
import quickfix.field.converter.CharConverter;
import quickfix.field.converter.DoubleConverter;
import quickfix.field.converter.IntConverter;
import quickfix.field.converter.UtcDateOnlyConverter;
import quickfix.field.converter.UtcTimeOnlyConverter;
import quickfix.field.converter.UtcTimestampConverter;

public class DataDictionary {
    private static final int USER_DEFINED_TAG_MIN = 5000;
    private static final String NO = "N";
    private boolean hasVersion = false;
    private boolean checkFieldsOutOfOrder = true;
    private boolean checkFieldsHaveValues = true;
    private boolean checkUserDefinedFields = true;
    private String beginString;
    private Map messageFields = new HashMap();
    private Map requiredFields = new HashMap();
    private Set messages = new HashSet();
    private LinkedHashSet fields = new LinkedHashSet();
    private Map headerFields = new HashMap();
    private Map trailerFields = new HashMap();
    private Map fieldTypes = new HashMap();
    private Map fieldValues = new HashMap();
    private Map fieldNames = new HashMap();
    private Map names = new HashMap();
    private Map valueNames = new HashMap();
    private Map groups = new HashMap();
    private Map components = new HashMap();
    private int[] orderedFieldsArray;

    private DataDictionary() {
    }

    public DataDictionary(String location) throws ConfigError {
        this();
        this.readFromURL(location);
    }

    public DataDictionary(InputStream in) throws ConfigError {
        this.load(in);
    }

    public DataDictionary(DataDictionary source) {
        this.copyFrom(source);
    }

    private void setVersion(String beginString) {
        this.beginString = beginString;
        this.hasVersion = true;
    }

    public String getVersion() {
        return this.beginString;
    }

    private void addField(int field) {
        this.fields.add(new Integer(field));
    }

    private void addFieldName(int field, String name) throws ConfigError {
        if (this.names.put(name, new Integer(field)) != null) {
            throw new ConfigError("Field named " + name + " defined multiple times");
        }
        this.fieldNames.put(new Integer(field), name);
    }

    public String getFieldName(int field) {
        return (String)this.fieldNames.get(new Integer(field));
    }

    private void addValueName(int field, String value, String name) {
        this.valueNames.put(new IntStringPair(field, value), name);
    }

    public String getValueName(int field, String value) {
        return (String)this.valueNames.get(new IntStringPair(field, value));
    }

    public boolean isField(int field) {
        return this.fields.contains(new Integer(field));
    }

    public FieldType getFieldTypeEnum(int field) {
        return (FieldType)this.fieldTypes.get(new Integer(field));
    }

    private void addMsgType(String msgType) {
        this.messages.add(msgType);
    }

    public boolean isMsgType(String msgType) {
        return this.messages.contains(msgType);
    }

    private void addMsgField(String msgType, int field) {
        HashSet<Integer> fields = (HashSet<Integer>)this.messageFields.get(msgType);
        if (fields == null) {
            fields = new HashSet<Integer>();
            this.messageFields.put(msgType, fields);
        }
        fields.add(new Integer(field));
    }

    public boolean isMsgField(String msgType, int field) {
        Set fields = (Set)this.messageFields.get(msgType);
        return fields != null & fields.contains(new Integer(field));
    }

    private void addHeaderField(int field, boolean required) {
        this.headerFields.put(new Integer(field), required ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean isHeaderField(int field) {
        return this.headerFields.containsKey(new Integer(field));
    }

    private void addTrailerField(int field, boolean required) {
        this.trailerFields.put(new Integer(field), required ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean isTrailerField(int field) {
        return this.trailerFields.containsKey(new Integer(field));
    }

    private void addFieldType(int field, FieldType fieldType) {
        this.fieldTypes.put(new Integer(field), fieldType);
    }

    public int getFieldType(int field) {
        return this.getFieldTypeEnum(field).getOrdinal();
    }

    public int getFieldTag(String name) {
        Integer tag = (Integer)this.names.get(name);
        return tag != null ? tag : -1;
    }

    private void addRequiredField(String msgType, int field) {
        HashSet<Integer> fields = (HashSet<Integer>)this.requiredFields.get(msgType);
        if (fields == null) {
            fields = new HashSet<Integer>();
            this.requiredFields.put(msgType, fields);
        }
        fields.add(new Integer(field));
    }

    public boolean isRequiredField(String msgType, int field) {
        Set fields = (Set)this.requiredFields.get(msgType);
        return fields != null && fields.contains(new Integer(field));
    }

    private void addFieldValue(int field, String value) {
        Integer key = new Integer(field);
        HashSet<String> values = (HashSet<String>)this.fieldValues.get(key);
        if (values == null) {
            values = new HashSet<String>();
            this.fieldValues.put(key, values);
        }
        values.add(value);
    }

    public boolean hasFieldValue(int field) {
        Set values = (Set)this.fieldValues.get(new Integer(field));
        return values != null && values.size() > 0;
    }

    public boolean isFieldValue(int field, String value) {
        Set validValues = (Set)this.fieldValues.get(new Integer(field));
        if (validValues == null || validValues.size() == 0) {
            return false;
        }
        if (!this.isMultipleValueStringField(field)) {
            return validValues.contains(value);
        }
        String[] values = value.split(" ");
        for (int i = 0; i < values.length; ++i) {
            if (validValues.contains(values[i])) continue;
            return false;
        }
        return true;
    }

    private void addGroup(String msg, int field, int delim, DataDictionary dataDictionary) {
        this.groups.put(new IntStringPair(field, msg), new GroupInfo(delim, dataDictionary));
    }

    public boolean isGroup(String msg, int field) {
        return this.groups.containsKey(new IntStringPair(field, msg));
    }

    public GroupInfo getGroup(String msg, int field) {
        return (GroupInfo)this.groups.get(new IntStringPair(field, msg));
    }

    public boolean isDataField(int field) {
        return this.fieldTypes.get(new Integer(field)) == FieldType.Data;
    }

    private boolean isMultipleValueStringField(int field) {
        return this.fieldTypes.get(new Integer(field)) == FieldType.MultipleValueString;
    }

    public void setCheckFieldsOutOfOrder(boolean flag) {
        this.checkFieldsOutOfOrder = flag;
    }

    public void setCheckFieldsHaveValues(boolean flag) {
        this.checkFieldsHaveValues = flag;
    }

    public void setCheckUserDefinedFields(boolean flag) {
        this.checkUserDefinedFields = flag;
    }

    private void copyFrom(DataDictionary rhs) {
        this.hasVersion = rhs.hasVersion;
        this.beginString = rhs.beginString;
        this.checkFieldsOutOfOrder = rhs.checkFieldsOutOfOrder;
        this.checkFieldsHaveValues = rhs.checkFieldsHaveValues;
        this.checkUserDefinedFields = rhs.checkUserDefinedFields;
        this.copyMap(this.messageFields, rhs.messageFields);
        this.copyMap(this.requiredFields, rhs.requiredFields);
        this.copyCollection(this.messages, rhs.messages);
        this.copyCollection(this.fields, rhs.fields);
        this.copyMap(this.headerFields, rhs.headerFields);
        this.copyMap(this.trailerFields, rhs.trailerFields);
        this.copyMap(this.fieldTypes, rhs.fieldTypes);
        this.copyMap(this.fieldValues, rhs.fieldValues);
        this.copyMap(this.fieldNames, rhs.fieldNames);
        this.copyMap(this.names, rhs.names);
        this.copyMap(this.valueNames, rhs.valueNames);
        this.copyMap(this.groups, rhs.groups);
        this.copyMap(this.components, rhs.components);
    }

    private void copyMap(Map lhs, Map rhs) {
        lhs.clear();
        Iterator entries = rhs.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            Object value = entry.getValue();
            if (value instanceof Collection) {
                Collection copy;
                try {
                    copy = (Collection)value.getClass().newInstance();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (java.lang.Exception e) {
                    throw new RuntimeException(e);
                }
                this.copyCollection(copy, (Collection)value);
                value = copy;
            }
            lhs.put(entry.getKey(), value);
        }
    }

    private void copyCollection(Collection lhs, Collection rhs) {
        lhs.clear();
        lhs.addAll(rhs);
    }

    public void validate(Message message) throws IncorrectTagValue, FieldNotFound {
        if (this.hasVersion && !this.getVersion().equals(message.getHeader().getString(8))) {
            throw new UnsupportedVersion();
        }
        if (this.checkFieldsOutOfOrder && !message.hasValidStructure()) {
            throw new FieldException(14, message.getInvalidStructureTag());
        }
        String msgType = message.getHeader().getString(35);
        if (this.hasVersion) {
            this.checkMsgType(msgType);
            this.checkHasRequired(message.getHeader(), message, message.getTrailer(), msgType);
        }
        this.iterate(message.getHeader(), msgType);
        this.iterate(message, msgType);
        this.iterate(message.getTrailer(), msgType);
    }

    private void iterate(FieldMap map, String msgType) throws IncorrectTagValue {
        Field previousField = null;
        Iterator iterator = map.iterator();
        while (iterator.hasNext()) {
            StringField field = (StringField)iterator.next();
            if (previousField != null && field.getTag() == previousField.getTag()) {
                throw new FieldException(13, previousField.getTag());
            }
            this.checkHasValue(field);
            if (this.hasVersion) {
                this.checkValidFormat(field);
                this.checkValue(field);
            }
            if (this.beginString != null && this.shouldCheckTag(field)) {
                this.checkValidTagNumber(field);
                if (!Message.isHeaderField(field, this) && !Message.isTrailerField(field, this)) {
                    this.checkIsInMessage(field, msgType);
                    this.checkGroupCount(field, map, msgType);
                }
            }
            previousField = field;
        }
    }

    private void checkMsgType(String msgType) {
        if (!this.isMsgType(msgType)) {
            throw new FieldException(11);
        }
    }

    private boolean shouldCheckTag(Field field) {
        return this.checkUserDefinedFields || field.getField() < 5000;
    }

    void checkValidTagNumber(Field field) {
        if (!this.fields.contains(new Integer(field.getTag()))) {
            throw new FieldException(0, field.getField());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkValidFormat(StringField field) {
        try {
            FieldType fieldType = this.getFieldTypeEnum(field.getTag());
            if (fieldType == FieldType.String) return;
            if (fieldType == FieldType.Char) {
                if (this.beginString.compareTo("FIX.4.1") <= 0) return;
                CharConverter.convert(field.getValue());
                return;
            }
            if (fieldType == FieldType.Price) {
                DoubleConverter.convert(field.getValue());
                return;
            }
            if (fieldType == FieldType.Int) {
                IntConverter.convert(field.getValue());
                return;
            }
            if (fieldType == FieldType.Amt) {
                DoubleConverter.convert(field.getValue());
                return;
            }
            if (fieldType == FieldType.Qty) {
                DoubleConverter.convert(field.getValue());
                return;
            }
            if (fieldType == FieldType.Qty || fieldType == FieldType.MultipleValueString || fieldType == FieldType.Exchange) return;
            if (fieldType == FieldType.Boolean) {
                BooleanConverter.convert(field.getValue());
                return;
            }
            if (fieldType == FieldType.LocalMktDate || fieldType == FieldType.Data) return;
            if (fieldType == FieldType.Float) {
                DoubleConverter.convert(field.getValue());
                return;
            }
            if (fieldType == FieldType.PriceOffset) {
                DoubleConverter.convert(field.getValue());
                return;
            }
            if (fieldType == FieldType.MonthYear || fieldType == FieldType.DayOfMonth) return;
            if (fieldType == FieldType.UtcDate) {
                UtcDateOnlyConverter.convert(field.getValue());
                return;
            }
            if (fieldType == FieldType.UtcTimeOnly) {
                UtcTimeOnlyConverter.convert(field.getValue());
                return;
            }
            if (fieldType == FieldType.UtcTimeStamp || fieldType == FieldType.Time) {
                UtcTimestampConverter.convert(field.getValue());
                return;
            }
            if (fieldType == FieldType.NumInGroup) {
                IntConverter.convert(field.getValue());
                return;
            }
            if (fieldType == FieldType.Percentage) {
                DoubleConverter.convert(field.getValue());
                return;
            }
            if (fieldType == FieldType.SeqNum) {
                IntConverter.convert(field.getValue());
                return;
            }
            if (fieldType == FieldType.Length) {
                IntConverter.convert(field.getValue());
                return;
            }
            if (fieldType != FieldType.Country) return;
        }
        catch (FieldConvertError e) {
            throw new FieldException(6, e.getMessage(), field.getTag());
        }
    }

    private void checkValue(StringField field) throws IncorrectTagValue {
        if (!this.hasFieldValue(field.getField())) {
            return;
        }
        String value = field.getValue();
        if (!this.isFieldValue(field.getField(), value)) {
            throw new IncorrectTagValue(field.getField());
        }
    }

    private void checkHasValue(StringField field) {
        if (this.checkFieldsHaveValues && field.getValue().length() == 0) {
            throw new FieldException(4, field.getField());
        }
    }

    private void checkIsInMessage(Field field, String msgType) {
        if (!this.isMsgField(msgType, field.getField())) {
            throw new FieldException(2, field.getField());
        }
    }

    private void checkGroupCount(StringField field, FieldMap fieldMap, String msgType) {
        int fieldNum = field.getField();
        if (this.isGroup(msgType, fieldNum) && fieldMap.getGroupCount(fieldNum) != Integer.parseInt(field.getValue())) {
            throw new FieldException(16, fieldNum);
        }
    }

    void checkHasRequired(FieldMap header, FieldMap body, FieldMap trailer, String msgType) {
        Iterator headerItr = this.headerFields.entrySet().iterator();
        while (headerItr.hasNext()) {
            Map.Entry entry = headerItr.next();
            int field = (Integer)entry.getKey();
            if (entry.getValue() != Boolean.TRUE || header.isSetField(field)) continue;
            throw new FieldException(1, field);
        }
        Iterator trailerItr = this.trailerFields.entrySet().iterator();
        while (trailerItr.hasNext()) {
            Map.Entry entry = trailerItr.next();
            int field = (Integer)entry.getKey();
            if (entry.getValue() != Boolean.TRUE || trailer.isSetField(field)) continue;
            throw new FieldException(1, field);
        }
        Set requiredFieldsForMessage = (Set)this.requiredFields.get(msgType);
        if (requiredFieldsForMessage == null || requiredFieldsForMessage.size() == 0) {
            return;
        }
        Iterator fieldItr = requiredFieldsForMessage.iterator();
        while (fieldItr.hasNext()) {
            int field = (Integer)fieldItr.next();
            if (body.isSetField(field)) continue;
            throw new FieldException(1, field);
        }
        Map groups = body.getGroups();
        if (groups.size() > 0) {
            Iterator groupIter = groups.entrySet().iterator();
            while (groupIter.hasNext()) {
                Map.Entry entry = groupIter.next();
                GroupInfo p = this.getGroup(msgType, (Integer)entry.getKey());
                List groupInstances = (List)entry.getValue();
                for (int i = 0; i < groupInstances.size(); ++i) {
                    FieldMap groupFields = (FieldMap)groupInstances.get(i);
                    p.getDataDictionary().checkHasRequired(groupFields, groupFields, groupFields, msgType);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void readFromURL(String url) throws ConfigError {
        InputStream inputStream;
        try {
            inputStream = new URL(url).openStream();
        }
        catch (MalformedURLException e) {
            try {
                inputStream = new FileInputStream(url);
            }
            catch (FileNotFoundException fe) {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                if (classLoader == null) {
                    classLoader = this.getClass().getClassLoader();
                }
                if ((inputStream = classLoader.getResourceAsStream(url)) == null) {
                    throw new Exception("Could not find data dictionary: " + url);
                }
            }
        }
        catch (IOException e) {
            throw new Exception((Throwable)e);
        }
        try {
            void var2_2;
            this.load((InputStream)var2_2);
        }
        catch (java.lang.Exception e) {
            ConfigError ce = new ConfigError(url + ": " + e.getMessage());
            ce.setStackTrace(e.getStackTrace());
            throw ce;
        }
    }

    private void load(InputStream inputStream) throws ConfigError {
        NodeList fieldsNode;
        Document document;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(inputStream);
        }
        catch (Throwable e) {
            throw new ConfigError("Could not parse data dictionary file", e);
        }
        Element documentElement = document.getDocumentElement();
        if (!documentElement.getNodeName().equals("fix")) {
            throw new ConfigError("Could not parse data dictionary file, or no <fix> node found at root");
        }
        if (!documentElement.hasAttribute("major")) {
            throw new ConfigError("major attribute not found on <fix>");
        }
        if (!documentElement.hasAttribute("minor")) {
            throw new ConfigError("minor attribute not found on <fix>");
        }
        this.setVersion("FIX." + documentElement.getAttribute("major") + "." + documentElement.getAttribute("minor"));
        NodeList componentsNode = documentElement.getElementsByTagName("components");
        if (componentsNode.getLength() > 0) {
            NodeList componentNodes = componentsNode.item(0).getChildNodes();
            for (int i = 0; i < componentNodes.getLength(); ++i) {
                Node componentNode = componentNodes.item(i);
                if (!componentNode.getNodeName().equals("component")) continue;
                String name = this.getAttribute(componentNode, "name");
                if (name == null) {
                    throw new ConfigError("<component> does not have a name attribute");
                }
                this.components.put(name, componentNode);
            }
        }
        if ((fieldsNode = documentElement.getElementsByTagName("fields")).getLength() == 0) {
            throw new ConfigError("<fields> section not found in data dictionary");
        }
        NodeList fieldNodes = fieldsNode.item(0).getChildNodes();
        if (fieldNodes.getLength() == 0) {
            throw new ConfigError("No fields defined");
        }
        for (int i = 0; i < fieldNodes.getLength(); ++i) {
            Node fieldNode = fieldNodes.item(i);
            if (!fieldNode.getNodeName().equals("field")) continue;
            String name = this.getAttribute(fieldNode, "name");
            if (name == null) {
                throw new ConfigError("<field> does not have a name attribute");
            }
            String number = this.getAttribute(fieldNode, "number");
            if (number == null) {
                throw new ConfigError("<field> " + name + " does not have a number attribute");
            }
            int num = Integer.parseInt(number);
            String type = this.getAttribute(fieldNode, "type");
            if (type == null) {
                throw new ConfigError("<field> " + name + " does not have a type attribute");
            }
            this.addField(num);
            this.addFieldType(num, FieldType.fromName(this.getVersion(), type));
            this.addFieldName(num, name);
            NodeList valueNodes = fieldNode.getChildNodes();
            for (int j = 0; j < valueNodes.getLength(); ++j) {
                Node valueNode = valueNodes.item(j);
                if (!valueNode.getNodeName().equals("value")) continue;
                String enumeration = this.getAttribute(valueNode, "enum");
                if (enumeration == null) {
                    throw new ConfigError("<value> does not have enum attribute in field " + name);
                }
                this.addFieldValue(num, enumeration);
                String description = this.getAttribute(valueNode, "description");
                if (description == null) continue;
                this.addValueName(num, enumeration, description);
            }
        }
        NodeList headerNode = documentElement.getElementsByTagName("header");
        if (headerNode.getLength() == 0) {
            throw new ConfigError("<header> section not found in data dictionary");
        }
        NodeList headerFieldNodes = headerNode.item(0).getChildNodes();
        if (headerFieldNodes.getLength() == 0) {
            throw new ConfigError("No header fields defined");
        }
        for (int i = 0; i < headerFieldNodes.getLength(); ++i) {
            Node headerFieldNode = headerFieldNodes.item(i);
            String nodeName = headerFieldNode.getNodeName();
            if (!nodeName.equals("field") && !nodeName.equals("group")) continue;
            String name = this.getAttribute(headerFieldNode, "name");
            if (name == null) {
                throw new ConfigError("<" + nodeName + "> does not have a name attribute");
            }
            String required = "false";
            this.addHeaderField(this.lookupXMLFieldNumber(document, name), required.equals("true"));
        }
        NodeList trailerNode = documentElement.getElementsByTagName("trailer");
        if (trailerNode.getLength() == 0) {
            throw new ConfigError("<trailer> section not found in data dictionary");
        }
        NodeList trailerFieldNodes = trailerNode.item(0).getChildNodes();
        for (int i = 0; i < trailerFieldNodes.getLength(); ++i) {
            Node trailerFieldNode = trailerFieldNodes.item(i);
            String nodeName = trailerFieldNode.getNodeName();
            if (!nodeName.equals("field") && !nodeName.equals("group")) continue;
            String name = this.getAttribute(trailerFieldNode, "name");
            if (name == null) {
                throw new ConfigError("<" + nodeName + "> does not have a name attribute");
            }
            String required = "false";
            this.addTrailerField(this.lookupXMLFieldNumber(document, name), required.equals("true"));
        }
        NodeList messagesNode = documentElement.getElementsByTagName("messages");
        if (messagesNode.getLength() == 0) {
            throw new ConfigError("<messages> section not found in data dictionary");
        }
        NodeList messageNodes = messagesNode.item(0).getChildNodes();
        if (messageNodes.getLength() == 0) {
            throw new ConfigError("No messages defined");
        }
        for (int i = 0; i < messageNodes.getLength(); ++i) {
            NodeList messageFieldNodes;
            Node messageNode = messageNodes.item(i);
            if (!messageNode.getNodeName().equals("message")) continue;
            String msgtype = this.getAttribute(messageNode, "msgtype");
            if (msgtype == null) {
                throw new ConfigError("<message> does not have a msgtype attribute");
            }
            this.addMsgType(msgtype);
            String name = this.getAttribute(messageNode, "name");
            if (name != null) {
                this.addValueName(35, msgtype, name);
            }
            if ((messageFieldNodes = messageNode.getChildNodes()).getLength() == 0) {
                throw new ConfigError("<message> contains no fields");
            }
            for (int j = 0; j < messageFieldNodes.getLength(); ++j) {
                Node messageFieldNode = messageFieldNodes.item(j);
                if (messageFieldNode.getNodeName().equals("field") || messageFieldNode.getNodeName().equals("group")) {
                    name = this.getAttribute(messageFieldNode, "name");
                    if (name == null) {
                        throw new ConfigError("<field> does not have a name attribute");
                    }
                    int num = this.lookupXMLFieldNumber(document, name);
                    this.addMsgField(msgtype, num);
                    String required = this.getAttribute(messageFieldNode, "required", NO);
                    if (required == null) {
                        throw new ConfigError("<" + messageFieldNode.getNodeName() + "> does not have a 'required' attribute");
                    }
                    if (required.equalsIgnoreCase("Y")) {
                        this.addRequiredField(msgtype, num);
                    }
                } else if (messageFieldNode.getNodeName().equals("component")) {
                    String required = this.getAttribute(messageFieldNode, "required");
                    if (required == null) {
                        throw new ConfigError("<component> does not have a 'required' attribute");
                    }
                    this.addXMLComponentFields(document, messageFieldNode, msgtype, this, required.equalsIgnoreCase("Y"));
                }
                if (!messageFieldNode.getNodeName().equals("group")) continue;
                String required = this.getAttribute(messageFieldNode, "required");
                if (required == null) {
                    throw new ConfigError("<group> does not have a 'required' attribute");
                }
                this.addXMLGroup(document, messageFieldNode, msgtype, this, required.equalsIgnoreCase("Y"));
            }
        }
    }

    int[] getOrderedFields() {
        if (this.orderedFieldsArray == null) {
            this.orderedFieldsArray = new int[this.fields.size()];
            Iterator fieldItr = this.fields.iterator();
            int i = 0;
            while (fieldItr.hasNext()) {
                this.orderedFieldsArray[i++] = (Integer)fieldItr.next();
            }
        }
        return this.orderedFieldsArray;
    }

    private int lookupXMLFieldNumber(Document document, Node node) throws ConfigError {
        Element element = (Element)node;
        if (!element.hasAttribute("name")) {
            throw new ConfigError("No name given to field");
        }
        return this.lookupXMLFieldNumber(document, element.getAttribute("name"));
    }

    private int lookupXMLFieldNumber(Document document, String name) throws ConfigError {
        Integer fieldNumber = (Integer)this.names.get(name);
        if (fieldNumber == null) {
            throw new ConfigError("Field " + name + " not defined in fields section");
        }
        return fieldNumber;
    }

    private int addXMLComponentFields(Document document, Node node, String msgtype, DataDictionary dd, boolean componentRequired) throws ConfigError {
        int firstField = 0;
        String name = this.getAttribute(node, "name");
        if (name == null) {
            throw new ConfigError("No name given to component");
        }
        Node componentNode = (Node)this.components.get(name);
        if (componentNode == null) {
            throw new ConfigError("Component not found");
        }
        NodeList componentFieldNodes = componentNode.getChildNodes();
        for (int i = 0; i < componentFieldNodes.getLength(); ++i) {
            Node componentFieldNode = componentFieldNodes.item(i);
            if (componentFieldNode.getNodeName().equals("field") || componentFieldNode.getNodeName().equals("group")) {
                String required;
                name = this.getAttribute(componentFieldNode, "name");
                if (name == null) {
                    throw new ConfigError("No name given to field");
                }
                int field = this.lookupXMLFieldNumber(document, name);
                if (firstField == 0) {
                    firstField = field;
                }
                if ((required = this.getAttribute(componentFieldNode, "required")).equalsIgnoreCase("Y") && componentRequired) {
                    this.addRequiredField(msgtype, field);
                }
                dd.addField(field);
                dd.addMsgField(msgtype, field);
            }
            if (!componentFieldNode.getNodeName().equals("group")) continue;
            String required = this.getAttribute(componentFieldNode, "required");
            boolean isRequired = required.equalsIgnoreCase("Y");
            this.addXMLGroup(document, componentFieldNode, msgtype, dd, isRequired);
        }
        return firstField;
    }

    private void addXMLGroup(Document document, Node node, String msgtype, DataDictionary dd, boolean groupRequired) throws ConfigError {
        String name = this.getAttribute(node, "name");
        if (name == null) {
            throw new ConfigError("No name given to group");
        }
        int group = this.lookupXMLFieldNumber(document, name);
        int delim = 0;
        int field = 0;
        DataDictionary groupDD = new DataDictionary();
        NodeList fieldNodeList = node.getChildNodes();
        for (int i = 0; i < fieldNodeList.getLength(); ++i) {
            String required;
            Node fieldNode = fieldNodeList.item(i);
            if (fieldNode.getNodeName().equals("field")) {
                field = this.lookupXMLFieldNumber(document, fieldNode);
                groupDD.addField(field);
                required = this.getAttribute(fieldNode, "required");
                if (required != null && required.equalsIgnoreCase("Y") && groupRequired) {
                    groupDD.addRequiredField(msgtype, field);
                }
            } else if (fieldNode.getNodeName().equals("component")) {
                field = this.addXMLComponentFields(document, fieldNode, msgtype, groupDD, false);
            } else if (fieldNode.getNodeName().equals("group")) {
                field = this.lookupXMLFieldNumber(document, fieldNode);
                groupDD.addField(field);
                required = this.getAttribute(fieldNode, "required");
                if (required != null && required.equalsIgnoreCase("Y") && groupRequired) {
                    groupDD.addRequiredField(msgtype, field);
                }
                boolean isRequired = required == null ? false : required.equalsIgnoreCase("Y");
                this.addXMLGroup(document, fieldNode, msgtype, groupDD, isRequired);
            }
            if (delim != 0) continue;
            delim = field;
        }
        if (delim != 0) {
            dd.addGroup(msgtype, group, delim, groupDD);
        }
    }

    private String getAttribute(Node node, String name) {
        return this.getAttribute(node, name, null);
    }

    private String getAttribute(Node node, String name, String defaultValue) {
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null) {
            Node namedItem = attributes.getNamedItem(name);
            return namedItem != null ? namedItem.getNodeValue() : null;
        }
        return defaultValue;
    }

    public static final class GroupInfo {
        private final int delimeterField;
        private final DataDictionary dataDictionary;

        private GroupInfo(int field, DataDictionary dictionary) {
            this.delimeterField = field;
            this.dataDictionary = dictionary;
        }

        public DataDictionary getDataDictionary() {
            return this.dataDictionary;
        }

        public int getDelimeterField() {
            return this.delimeterField;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GroupInfo)) {
                return false;
            }
            return this.delimeterField == ((GroupInfo)other).delimeterField && this.dataDictionary.equals(((GroupInfo)other).dataDictionary);
        }

        public int hashCode() {
            return this.delimeterField;
        }
    }

    private static final class IntStringPair {
        private final int intValue;
        private final String stringValue;

        public IntStringPair(int value, String value2) {
            this.intValue = value;
            this.stringValue = value2;
        }

        public int getIntValue() {
            return this.intValue;
        }

        public String getStringValue() {
            return this.stringValue;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof IntStringPair)) {
                return false;
            }
            return this.intValue == ((IntStringPair)other).intValue && this.stringValue.equals(((IntStringPair)other).stringValue);
        }

        public int hashCode() {
            return this.stringValue.hashCode() + this.intValue;
        }
    }

    public class Exception
    extends RuntimeException {
        public Exception(Throwable cause) {
            super(cause);
        }

        public Exception(String message) {
            super(message);
        }
    }
}

