/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServerDelegateMBean;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;

public class MBeanServerDelegate
implements MBeanServerDelegateMBean,
NotificationEmitter {
    private String mbeanServerId;
    private NotificationBroadcasterSupport broadcaster = null;
    private static Long oldStamp = new Long(0L);
    private long sequenceNumber = 1L;
    private static final MBeanNotificationInfo[] notifsInfo;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MBeanServerDelegate() {
        String string = "";
        Long l = null;
        Long l2 = oldStamp;
        synchronized (l2) {
            l = new Long(new Date().getTime());
            if (oldStamp >= l) {
                l = new Long(oldStamp + 1L);
            }
            oldStamp = l;
        }
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.mbeanServerId = new String(string + "_" + l.toString());
        this.broadcaster = new NotificationBroadcasterSupport();
    }

    public String getMBeanServerId() {
        return this.mbeanServerId;
    }

    public String getSpecificationName() {
        return "Java Management Extensions";
    }

    public String getSpecificationVersion() {
        return "1.2 Maintenance Release";
    }

    public String getSpecificationVendor() {
        return "Sun Microsystems";
    }

    public String getImplementationName() {
        return "JMX";
    }

    public String getImplementationVersion() {
        return "1.2_r08";
    }

    public String getImplementationVendor() {
        return "Sun Microsystems";
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        int n = notifsInfo.length;
        MBeanNotificationInfo[] mBeanNotificationInfoArray = new MBeanNotificationInfo[n];
        System.arraycopy(notifsInfo, 0, mBeanNotificationInfoArray, 0, n);
        return mBeanNotificationInfoArray;
    }

    public synchronized void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws IllegalArgumentException {
        this.broadcaster.addNotificationListener(notificationListener, notificationFilter, object);
    }

    public synchronized void removeNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws ListenerNotFoundException {
        this.broadcaster.removeNotificationListener(notificationListener, notificationFilter, object);
    }

    public synchronized void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        this.broadcaster.removeNotificationListener(notificationListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendNotification(Notification notification) {
        if (notification.getSequenceNumber() < 1L) {
            MBeanServerDelegate mBeanServerDelegate = this;
            synchronized (mBeanServerDelegate) {
                notification.setSequenceNumber(this.sequenceNumber++);
            }
        }
        this.broadcaster.sendNotification(notification);
    }

    static {
        String[] stringArray = new String[]{"JMX.mbean.unregistered", "JMX.mbean.registered"};
        notifsInfo = new MBeanNotificationInfo[1];
        MBeanServerDelegate.notifsInfo[0] = new MBeanNotificationInfo(stringArray, "MBeanServerNotification", "Notifications sent by the MBeanServerDelegate MBean");
    }
}

