/*
 * Decompiled with CFR 0.152.
 */
package hermes.swing.actions;

import hermes.Hermes;
import hermes.browser.HermesBrowser;
import hermes.browser.IconCache;
import hermes.browser.actions.BrowseContextAction;
import hermes.browser.model.tree.AbstractTreeNode;
import hermes.browser.model.tree.ContextTreeNode;
import hermes.swing.actions.JNDIAction;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import javax.naming.Context;
import javax.swing.JOptionPane;
import javax.swing.tree.TreePath;

public class JNDIUnbindAction
extends JNDIAction {
    public JNDIUnbindAction() {
        this.putValue("Name", "Unbind...");
        this.putValue("ShortDescription", "Unbind object.");
        this.putValue("SmallIcon", IconCache.getIcon("hermes.jndi.unbind"));
        this.setEnabled(false);
    }

    @Override
    protected boolean checkEnabled(TreePath path) {
        return path != null && path.getLastPathComponent() instanceof AbstractTreeNode;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            BrowseContextAction browseContext = (BrowseContextAction)HermesBrowser.getBrowser().getDocumentPane().getActiveDocument();
            HashSet<AbstractTreeNode> treeNodes = new HashSet<AbstractTreeNode>();
            if (browseContext.getContextTree().getSelectionPaths() != null) {
                for (TreePath treePath : browseContext.getContextTree().getSelectionPaths()) {
                    if (!(treePath.getLastPathComponent() instanceof AbstractTreeNode)) continue;
                    treeNodes.add((AbstractTreeNode)treePath.getLastPathComponent());
                }
            }
            if (treeNodes.size() > 0) {
                String confirmMessage = null;
                String doneMessage = null;
                if (treeNodes.size() == 1) {
                    confirmMessage = "Are you sure you wish to unbind this object?";
                    doneMessage = "Object unbound";
                } else {
                    confirmMessage = "Are you sure you wish to unbind these " + treeNodes.size() + " objects?";
                    doneMessage = treeNodes.size() + " objects unbound";
                }
                if (JOptionPane.showConfirmDialog((Component)((Object)HermesBrowser.getBrowser()), confirmMessage, "Please confirm", 0) == 0) {
                    for (AbstractTreeNode node : treeNodes) {
                        ContextTreeNode contextNode = (ContextTreeNode)node.getParent();
                        Context context = contextNode.getContextFactory().createContext();
                        context.unbind(node.getId());
                        context.close();
                    }
                    Hermes.ui.getDefaultMessageSink().add(doneMessage);
                }
            }
        }
        catch (Throwable ex) {
            HermesBrowser.getBrowser().showErrorDialog("Cannot unbind:", ex);
        }
    }
}

