/*
 * Decompiled with CFR 0.152.
 */
package hermes.swing.actions;

import com.jidesoft.swing.JideSwingUtilities;
import hermes.HermesException;
import hermes.browser.HermesBrowser;
import hermes.browser.IconCache;
import hermes.browser.dialog.EditNamingConfigDialog;
import hermes.config.NamingConfig;
import hermes.config.PropertySetConfig;
import hermes.swing.actions.ActionSupport;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class CreateNewContextAction
extends ActionSupport {
    private static final Logger log = Logger.getLogger(CreateNewContextAction.class);

    public CreateNewContextAction() {
        this.putValue("Name", "New Context...");
        this.putValue("ShortDescription", "Create new JNDI InitialContext");
        this.putValue("SmallIcon", IconCache.getIcon("jndi.context.new"));
        this.setEnabled(!HermesBrowser.getBrowser().isRestricted());
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        try {
            NamingConfig newConfig = new NamingConfig();
            newConfig.setClasspathId("System");
            newConfig.setProperties(new PropertySetConfig());
            String newName = JOptionPane.showInputDialog((Component)((Object)HermesBrowser.getBrowser()), "Name:", "Enter InitialContext Name", -1);
            if (newName != null && !newName.equals("")) {
                newConfig.setId(newName);
                EditNamingConfigDialog dialog = new EditNamingConfigDialog((Frame)((Object)HermesBrowser.getBrowser()), newConfig, HermesBrowser.getBrowser().getConfig().getNaming());
                dialog.pack();
                JideSwingUtilities.centerWindow((Window)((Object)dialog));
                dialog.show();
            }
        }
        catch (HermesException e) {
            log.error((Object)e.getMessage(), (Throwable)((Object)e));
            HermesBrowser.getBrowser().showErrorDialog((Throwable)((Object)e));
        }
    }
}

