/*
 * Decompiled with CFR 0.152.
 */
package hermes.impl;

import hermes.Hermes;
import hermes.HermesAdmin;
import hermes.HermesAdminFactory;
import hermes.HermesException;
import hermes.browser.MessageRenderer;
import hermes.config.DestinationConfig;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.QueueBrowser;
import javax.naming.NamingException;
import javax.swing.ProgressMonitor;

public class HermesAdminAdapter
implements HermesAdmin {
    private Hermes hermes;
    private HermesAdmin admin;
    private HermesAdminFactory extension;

    public HermesAdminAdapter(Hermes hermes, HermesAdminFactory extension) {
        this.hermes = hermes;
        this.extension = extension;
    }

    private synchronized HermesAdmin getAdmin() throws JMSException {
        if (this.admin == null) {
            try {
                this.admin = this.extension.createSession(this.hermes, this.hermes.getConnectionFactory());
            }
            catch (NamingException e) {
                throw new HermesException(e);
            }
        }
        return this.admin;
    }

    @Override
    public Enumeration createBrowserProxy(Enumeration iter) throws JMSException {
        return this.getAdmin().createBrowserProxy(iter);
    }

    @Override
    public Collection discoverDestinationConfigs() throws JMSException {
        return this.getAdmin().discoverDestinationConfigs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws JMSException {
        try {
            if (this.admin != null) {
                this.admin.close();
            }
        }
        finally {
            this.admin = null;
        }
    }

    @Override
    public int getDepth(DestinationConfig dest) throws JMSException {
        return this.getAdmin().getDepth(dest);
    }

    @Override
    public long getAge(DestinationConfig dest) throws JMSException {
        return this.getAdmin().getAge(dest);
    }

    @Override
    public int truncate(DestinationConfig dest) throws JMSException {
        return this.getAdmin().truncate(dest);
    }

    @Override
    public Map getStatistics(DestinationConfig destination) throws JMSException {
        return this.getAdmin().getStatistics(destination);
    }

    @Override
    public Collection getStatistics(Collection destinations) throws JMSException {
        return this.getAdmin().getStatistics(destinations);
    }

    @Override
    public MessageRenderer getMessageRenderer() throws JMSException {
        return this.getAdmin().getMessageRenderer();
    }

    @Override
    public void delete(DestinationConfig dConfig, Collection<String> messageIds, ProgressMonitor monitor) throws JMSException, NamingException {
        this.getAdmin().delete(dConfig, messageIds, monitor);
    }

    @Override
    public void delete(DestinationConfig dConfig, Collection<String> messageIds) throws JMSException, NamingException {
        this.delete(dConfig, messageIds, null);
    }

    @Override
    public QueueBrowser createDurableSubscriptionBrowser(DestinationConfig dConfig) throws JMSException {
        return this.getAdmin().createDurableSubscriptionBrowser(dConfig);
    }
}

