/*
 * Decompiled with CFR 0.152.
 */
package hermes.fix;

import hermes.fix.FIXMessage;
import hermes.fix.NoSuchFieldException;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class FIXMessageViewTableModel
extends AbstractTableModel {
    public static final String FIELD = "Field";
    public static final String NAME = "Name";
    public static final String VALUE = "Value";
    public static final String DESCRIPTION = "Description";
    private String[] columns = new String[]{"Field", "Name", "Value", "Description"};
    private FIXMessage message;
    private Vector<RowDef> rows = new Vector();

    public FIXMessageViewTableModel(FIXMessage message) {
        this.message = message;
        for (int i : message.getFieldOrder()) {
            RowDef rowDef = new RowDef();
            rowDef.tag = i;
            rowDef.type = message.getDictionary().isHeaderField(i) ? RowType.HEADER : (message.getDictionary().isTrailerField(i) ? RowType.TRAILER : RowType.APPLICATION);
            this.rows.add(rowDef);
        }
    }

    @Override
    public int getRowCount() {
        if (this.rows != null) {
            return this.rows.size();
        }
        return 0;
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return Integer.class;
        }
        return String.class;
    }

    public RowType getRowType(int row) {
        RowDef rowDef = this.rows.get(row);
        return rowDef.type;
    }

    @Override
    public String getColumnName(int column) {
        return this.columns[column];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        RowDef row = this.rows.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return row.tag;
            }
            case 1: {
                return this.message.getDictionary().getFieldName(row.tag);
            }
            case 2: {
                try {
                    return this.message.getObject(row.tag);
                }
                catch (NoSuchFieldException ex) {
                    return ex.getMessage();
                }
            }
            case 3: {
                return this.message.getDictionary().getValueName(row.tag, this.message.getString(row.tag));
            }
        }
        return "";
    }

    private class RowDef {
        RowType type;
        int tag;

        private RowDef() {
        }
    }

    public static enum RowType {
        HEADER,
        APPLICATION,
        TRAILER;

    }
}

