/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.transferable;

import hermes.HermesRuntimeException;
import hermes.browser.components.BrowserTree;
import hermes.browser.components.ContextTree;
import hermes.browser.transferable.HermesAdministeredObjectTransferable;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.apache.log4j.Logger;

public class HermesAdministeredObjectTransferHandler
extends TransferHandler {
    private static final Logger log = Logger.getLogger(HermesAdministeredObjectTransferHandler.class);

    @Override
    public boolean canImport(JComponent component, DataFlavor[] flavors) {
        return component instanceof ContextTree;
    }

    @Override
    protected Transferable createTransferable(JComponent component) {
        if (component instanceof BrowserTree) {
            BrowserTree tree = (BrowserTree)component;
            return new HermesAdministeredObjectTransferable(tree.getSelectedAdministeredObjectNodes());
        }
        throw new HermesRuntimeException("cannot create transferable, JComponent " + component.getClass().getName() + " is not a BrowserTree");
    }

    @Override
    public int getSourceActions(JComponent component) {
        if (component instanceof BrowserTree) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean importData(JComponent component, Transferable t) {
        if (component instanceof ContextTree && t instanceof HermesAdministeredObjectTransferable) {
            ContextTree contextTree = (ContextTree)component;
            return contextTree.doImport((HermesAdministeredObjectTransferable)t);
        }
        return false;
    }
}

