/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.model.tree;

import hermes.browser.IconCache;
import hermes.browser.model.tree.AbstractTreeNode;
import hermes.browser.model.tree.MessageStoreTreeNode;
import hermes.config.JDBCStore;

public class MessageStoreURLTreeNode
extends AbstractTreeNode {
    private JDBCStore storeConfig;

    public MessageStoreURLTreeNode(JDBCStore storeConfig) throws ClassNotFoundException {
        super(storeConfig.getAlias(), storeConfig.getUrl());
        this.storeConfig = storeConfig;
        this.setIcon(IconCache.getIcon("jdbc"));
        if (storeConfig.getDriver() != null) {
            Class.forName(storeConfig.getDriver());
        }
    }

    public MessageStoreURLTreeNode(String alias, String jdbcURL) {
        super(alias, jdbcURL);
        this.storeConfig = new JDBCStore();
        this.storeConfig.setAlias(alias);
        this.storeConfig.setUrl(jdbcURL);
        this.setIcon(IconCache.getIcon("jdbc"));
    }

    public JDBCStore getConfig() {
        return this.storeConfig;
    }

    public String getAlias() {
        return this.storeConfig.getAlias();
    }

    public String getTooltipText() {
        return this.getURL();
    }

    public String getURL() {
        return (String)this.getBean();
    }

    public boolean isConfigurable() {
        return !this.storeConfig.getAlias().equals("local");
    }

    public void close() {
        while (this.getChildCount() > 0) {
            MessageStoreTreeNode child = (MessageStoreTreeNode)this.getChildAt(0);
            child.close();
        }
    }
}

