/*
 * Decompiled with CFR 0.152.
 */
package hermes.ext.sonicmq;

import hermes.Hermes;
import hermes.HermesAdmin;
import hermes.HermesAdminFactory;
import hermes.JNDIConnectionFactory;
import hermes.ext.sonicmq.SonicMQAdmin;
import javax.jms.JMSException;
import javax.naming.NamingException;
import progress.message.jclient.ConnectionFactory;

public class SonicMQAdminFactory
implements HermesAdminFactory {
    private String connectionURL;
    private String defaultUser;
    private String defaultPassword;
    private String domain;
    private String container;
    private String broker;
    private String brokerName = "Broker1";
    private long timeout = -1L;

    public HermesAdmin createSession(Hermes hermes, javax.jms.ConnectionFactory connectionFactory) throws JMSException, NamingException {
        if (connectionFactory instanceof JNDIConnectionFactory) {
            JNDIConnectionFactory jndiCF = (JNDIConnectionFactory)connectionFactory;
            if (this.connectionURL == null) {
                this.connectionURL = jndiCF.getProviderURL();
            }
            if (this.defaultUser == null) {
                this.defaultUser = jndiCF.getSecurityPrincipal();
            }
            if (this.defaultPassword == null) {
                this.defaultPassword = jndiCF.getSecurityCredentials();
            }
        } else if (connectionFactory instanceof ConnectionFactory) {
            ConnectionFactory sonicCF = (ConnectionFactory)connectionFactory;
            if (this.connectionURL == null) {
                this.connectionURL = sonicCF.getBrokerURL();
            }
            if (this.defaultUser == null) {
                this.defaultUser = sonicCF.getDefaultUser();
            }
            if (this.defaultPassword == null) {
                this.defaultPassword = sonicCF.getDefaultPassword();
            }
        }
        return new SonicMQAdmin(hermes, this);
    }

    public String getBroker() {
        return this.broker;
    }

    public void setBroker(String broker) {
        this.broker = broker;
    }

    public String getBrokerName() {
        return this.brokerName;
    }

    public void setBrokerName(String brokerName) {
        this.brokerName = brokerName;
    }

    public String getConnectionURL() {
        return this.connectionURL;
    }

    public void setConnectionURL(String connectionURL) {
        this.connectionURL = connectionURL;
    }

    public String getContainer() {
        return this.container;
    }

    public void setContainer(String container) {
        this.container = container;
    }

    public String getDefaultPassword() {
        return this.defaultPassword;
    }

    public void setDefaultPassword(String defaultPassword) {
        this.defaultPassword = defaultPassword;
    }

    public String getDefaultUser() {
        return this.defaultUser;
    }

    public void setDefaultUser(String defaultUser) {
        this.defaultUser = defaultUser;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }
}

