/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import jcifs.smb.ServerMessageBlock;
import jcifs.util.Hexdump;

public class SID {
    int revision;
    int sub_authority_count;
    byte[] identifier_authority = new byte[6];
    int[] sub_authority;

    public SID(byte[] src, int si) {
        this.revision = src[si++];
        this.sub_authority_count = src[si++];
        System.arraycopy(src, si, this.identifier_authority, 0, 6);
        si += 6;
        if (this.sub_authority_count > 100) {
            throw new RuntimeException("Invalid SID");
        }
        this.sub_authority = new int[this.sub_authority_count];
        for (int i = 0; i < this.sub_authority_count; ++i) {
            this.sub_authority[i] = ServerMessageBlock.readInt4(src, si);
            si += 4;
        }
    }

    public String toString() {
        String ret = "S-" + this.revision + "-";
        if (this.identifier_authority[0] != 0 || this.identifier_authority[1] != 0) {
            ret = ret + "0x";
            ret = ret + Hexdump.toHexString(this.identifier_authority, 0, 6);
        } else {
            long shift = 0L;
            long id = 0L;
            for (int i = 5; i > 1; --i) {
                id += ((long)this.identifier_authority[i] & 0xFFL) << (int)shift;
                shift += 8L;
            }
            ret = ret + id;
        }
        for (int i = 0; i < this.sub_authority_count; ++i) {
            ret = ret + "-" + ((long)this.sub_authority[i] & 0xFFFFFFFFL);
        }
        return ret;
    }
}

