/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.beanutils.WrapDynaBean;

public class WrapDynaClass
implements DynaClass {
    protected Class beanClass = null;
    protected PropertyDescriptor[] descriptors = null;
    protected HashMap descriptorsMap = new HashMap();
    protected DynaProperty[] properties = null;
    protected HashMap propertiesMap = new HashMap();
    protected static HashMap dynaClasses = new HashMap();

    private WrapDynaClass(Class beanClass) {
        this.beanClass = beanClass;
        this.introspect();
    }

    public String getName() {
        return this.beanClass.getName();
    }

    public DynaProperty getDynaProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException("No property name specified");
        }
        return (DynaProperty)this.propertiesMap.get(name);
    }

    public DynaProperty[] getDynaProperties() {
        return this.properties;
    }

    public DynaBean newInstance() throws IllegalAccessException, InstantiationException {
        return new WrapDynaBean(this.beanClass.newInstance());
    }

    public PropertyDescriptor getPropertyDescriptor(String name) {
        return (PropertyDescriptor)this.descriptorsMap.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        HashMap hashMap = dynaClasses;
        synchronized (hashMap) {
            dynaClasses.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WrapDynaClass createDynaClass(Class beanClass) {
        HashMap hashMap = dynaClasses;
        synchronized (hashMap) {
            WrapDynaClass dynaClass = (WrapDynaClass)dynaClasses.get(beanClass);
            if (dynaClass == null) {
                dynaClass = new WrapDynaClass(beanClass);
                dynaClasses.put(beanClass, dynaClass);
            }
            return dynaClass;
        }
    }

    protected void introspect() {
        HashMap mappeds;
        PropertyDescriptor[] regulars = PropertyUtils.getPropertyDescriptors(this.beanClass);
        if (regulars == null) {
            regulars = new PropertyDescriptor[]{};
        }
        if ((mappeds = PropertyUtils.getMappedPropertyDescriptors(this.beanClass)) == null) {
            mappeds = new HashMap();
        }
        this.properties = new DynaProperty[regulars.length + mappeds.size()];
        for (int i = 0; i < regulars.length; ++i) {
            this.descriptorsMap.put(regulars[i].getName(), regulars[i]);
            this.properties[i] = new DynaProperty(regulars[i].getName(), regulars[i].getPropertyType());
            this.propertiesMap.put(this.properties[i].getName(), this.properties[i]);
        }
        int j = regulars.length;
        for (String name : mappeds.keySet()) {
            PropertyDescriptor descriptor = (PropertyDescriptor)mappeds.get(name);
            this.properties[j] = new DynaProperty(descriptor.getName(), Map.class);
            this.propertiesMap.put(this.properties[j].getName(), this.properties[j]);
            ++j;
        }
    }
}

