/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.io.File;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.BigDecimalConverter;
import org.apache.commons.beanutils.converters.BigIntegerConverter;
import org.apache.commons.beanutils.converters.BooleanArrayConverter;
import org.apache.commons.beanutils.converters.BooleanConverter;
import org.apache.commons.beanutils.converters.ByteArrayConverter;
import org.apache.commons.beanutils.converters.ByteConverter;
import org.apache.commons.beanutils.converters.CharacterArrayConverter;
import org.apache.commons.beanutils.converters.CharacterConverter;
import org.apache.commons.beanutils.converters.ClassConverter;
import org.apache.commons.beanutils.converters.DoubleArrayConverter;
import org.apache.commons.beanutils.converters.DoubleConverter;
import org.apache.commons.beanutils.converters.FileConverter;
import org.apache.commons.beanutils.converters.FloatArrayConverter;
import org.apache.commons.beanutils.converters.FloatConverter;
import org.apache.commons.beanutils.converters.IntegerArrayConverter;
import org.apache.commons.beanutils.converters.IntegerConverter;
import org.apache.commons.beanutils.converters.LongArrayConverter;
import org.apache.commons.beanutils.converters.LongConverter;
import org.apache.commons.beanutils.converters.ShortArrayConverter;
import org.apache.commons.beanutils.converters.ShortConverter;
import org.apache.commons.beanutils.converters.SqlDateConverter;
import org.apache.commons.beanutils.converters.SqlTimeConverter;
import org.apache.commons.beanutils.converters.SqlTimestampConverter;
import org.apache.commons.beanutils.converters.StringArrayConverter;
import org.apache.commons.beanutils.converters.StringConverter;
import org.apache.commons.beanutils.converters.URLConverter;
import org.apache.commons.collections.FastHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConvertUtilsBean {
    private FastHashMap converters = new FastHashMap();
    private Log log = LogFactory.getLog(ConvertUtils.class);
    private Boolean defaultBoolean = Boolean.FALSE;
    private Byte defaultByte = new Byte(0);
    private Character defaultCharacter = new Character(' ');
    private Double defaultDouble = new Double(0.0);
    private Float defaultFloat = new Float(0.0f);
    private Integer defaultInteger = new Integer(0);
    private Long defaultLong = new Long(0L);
    private static Short defaultShort = new Short(0);

    protected static ConvertUtilsBean getInstance() {
        return BeanUtilsBean.getInstance().getConvertUtils();
    }

    public ConvertUtilsBean() {
        this.converters.setFast(false);
        this.deregister();
        this.converters.setFast(true);
    }

    public boolean getDefaultBoolean() {
        return this.defaultBoolean;
    }

    public void setDefaultBoolean(boolean newDefaultBoolean) {
        this.defaultBoolean = new Boolean(newDefaultBoolean);
        this.register(new BooleanConverter(this.defaultBoolean), Boolean.TYPE);
        this.register(new BooleanConverter(this.defaultBoolean), Boolean.class);
    }

    public byte getDefaultByte() {
        return this.defaultByte;
    }

    public void setDefaultByte(byte newDefaultByte) {
        this.defaultByte = new Byte(newDefaultByte);
        this.register(new ByteConverter(this.defaultByte), Byte.TYPE);
        this.register(new ByteConverter(this.defaultByte), Byte.class);
    }

    public char getDefaultCharacter() {
        return this.defaultCharacter.charValue();
    }

    public void setDefaultCharacter(char newDefaultCharacter) {
        this.defaultCharacter = new Character(newDefaultCharacter);
        this.register(new CharacterConverter(this.defaultCharacter), Character.TYPE);
        this.register(new CharacterConverter(this.defaultCharacter), Character.class);
    }

    public double getDefaultDouble() {
        return this.defaultDouble;
    }

    public void setDefaultDouble(double newDefaultDouble) {
        this.defaultDouble = new Double(newDefaultDouble);
        this.register(new DoubleConverter(this.defaultDouble), Double.TYPE);
        this.register(new DoubleConverter(this.defaultDouble), Double.class);
    }

    public float getDefaultFloat() {
        return this.defaultFloat.floatValue();
    }

    public void setDefaultFloat(float newDefaultFloat) {
        this.defaultFloat = new Float(newDefaultFloat);
        this.register(new FloatConverter(this.defaultFloat), Float.TYPE);
        this.register(new FloatConverter(this.defaultFloat), Float.class);
    }

    public int getDefaultInteger() {
        return this.defaultInteger;
    }

    public void setDefaultInteger(int newDefaultInteger) {
        this.defaultInteger = new Integer(newDefaultInteger);
        this.register(new IntegerConverter(this.defaultInteger), Integer.TYPE);
        this.register(new IntegerConverter(this.defaultInteger), Integer.class);
    }

    public long getDefaultLong() {
        return this.defaultLong;
    }

    public void setDefaultLong(long newDefaultLong) {
        this.defaultLong = new Long(newDefaultLong);
        this.register(new LongConverter(this.defaultLong), Long.TYPE);
        this.register(new LongConverter(this.defaultLong), Long.class);
    }

    public short getDefaultShort() {
        return defaultShort;
    }

    public void setDefaultShort(short newDefaultShort) {
        defaultShort = new Short(newDefaultShort);
        this.register(new ShortConverter(defaultShort), Short.TYPE);
        this.register(new ShortConverter(defaultShort), Short.class);
    }

    public String convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray()) {
            if (Array.getLength(value) < 1) {
                return null;
            }
            if ((value = Array.get(value, 0)) == null) {
                return null;
            }
            Converter converter = this.lookup(String.class);
            return (String)converter.convert(String.class, value);
        }
        Converter converter = this.lookup(String.class);
        return (String)converter.convert(String.class, value);
    }

    public Object convert(String value, Class clazz) {
        Converter converter;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Convert string '" + value + "' to class '" + clazz.getName() + "'"));
        }
        if ((converter = this.lookup(clazz)) == null) {
            converter = this.lookup(String.class);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("  Using converter " + converter));
        }
        return converter.convert(clazz, value);
    }

    public Object convert(String[] values, Class clazz) {
        Converter converter;
        Class<?> type = clazz;
        if (clazz.isArray()) {
            type = clazz.getComponentType();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Convert String[" + values.length + "] to class '" + type.getName() + "[]'"));
        }
        if ((converter = this.lookup(type)) == null) {
            converter = this.lookup(String.class);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("  Using converter " + converter));
        }
        Object array = Array.newInstance(type, values.length);
        for (int i = 0; i < values.length; ++i) {
            Array.set(array, i, converter.convert(type, values[i]));
        }
        return array;
    }

    public void deregister() {
        boolean[] booleanArray = new boolean[]{};
        byte[] byteArray = new byte[]{};
        char[] charArray = new char[]{};
        double[] doubleArray = new double[]{};
        float[] floatArray = new float[]{};
        int[] intArray = new int[]{};
        long[] longArray = new long[]{};
        short[] shortArray = new short[]{};
        String[] stringArray = new String[]{};
        this.converters.clear();
        this.register(BigDecimal.class, new BigDecimalConverter());
        this.register(BigInteger.class, new BigIntegerConverter());
        this.register(Boolean.TYPE, new BooleanConverter(this.defaultBoolean));
        this.register(Boolean.class, new BooleanConverter(this.defaultBoolean));
        this.register(booleanArray.getClass(), new BooleanArrayConverter(booleanArray));
        this.register(Byte.TYPE, new ByteConverter(this.defaultByte));
        this.register(Byte.class, new ByteConverter(this.defaultByte));
        this.register(byteArray.getClass(), new ByteArrayConverter(byteArray));
        this.register(Character.TYPE, new CharacterConverter(this.defaultCharacter));
        this.register(Character.class, new CharacterConverter(this.defaultCharacter));
        this.register(charArray.getClass(), new CharacterArrayConverter(charArray));
        this.register(Class.class, new ClassConverter());
        this.register(Double.TYPE, new DoubleConverter(this.defaultDouble));
        this.register(Double.class, new DoubleConverter(this.defaultDouble));
        this.register(doubleArray.getClass(), new DoubleArrayConverter(doubleArray));
        this.register(Float.TYPE, new FloatConverter(this.defaultFloat));
        this.register(Float.class, new FloatConverter(this.defaultFloat));
        this.register(floatArray.getClass(), new FloatArrayConverter(floatArray));
        this.register(Integer.TYPE, new IntegerConverter(this.defaultInteger));
        this.register(Integer.class, new IntegerConverter(this.defaultInteger));
        this.register(intArray.getClass(), new IntegerArrayConverter(intArray));
        this.register(Long.TYPE, new LongConverter(this.defaultLong));
        this.register(Long.class, new LongConverter(this.defaultLong));
        this.register(longArray.getClass(), new LongArrayConverter(longArray));
        this.register(Short.TYPE, new ShortConverter(defaultShort));
        this.register(Short.class, new ShortConverter(defaultShort));
        this.register(shortArray.getClass(), new ShortArrayConverter(shortArray));
        this.register(String.class, new StringConverter());
        this.register(stringArray.getClass(), new StringArrayConverter(stringArray));
        this.register(Date.class, new SqlDateConverter());
        this.register(Time.class, new SqlTimeConverter());
        this.register(Timestamp.class, new SqlTimestampConverter());
        this.register(File.class, new FileConverter());
        this.register(URL.class, new URLConverter());
    }

    private void register(Class clazz, Converter converter) {
        this.register(converter, clazz);
    }

    public void deregister(Class clazz) {
        this.converters.remove(clazz);
    }

    public Converter lookup(Class clazz) {
        return (Converter)this.converters.get(clazz);
    }

    public void register(Converter converter, Class clazz) {
        this.converters.put(clazz, converter);
    }
}

