/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.content;

import com.exe4j.runtime.util.FileUtil;
import com.exe4j.runtime.util.ReadIOException;
import com.install4j.api.Util;
import com.install4j.api.context.FileOptions;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.OverwriteMode;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UninstallMode;
import com.install4j.api.context.UninstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.unix.UnixFileSystem;
import com.install4j.api.windows.RegistryRoot;
import com.install4j.api.windows.WinRegistry;
import com.install4j.runtime.beans.actions.InstallFilesAction;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.ProgressAdapter;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.XmlHelper;
import com.install4j.runtime.installer.helper.content.apache.archivers.tar.TarArchiveEntry;
import com.install4j.runtime.installer.helper.content.apache.archivers.tar.TarArchiveInputStream;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import com.install4j.runtime.installer.helper.versionspecific.VersionSpecificHelper;
import com.install4j.runtime.installer.platform.macos.PlistHelper;
import com.install4j.runtime.installer.platform.win32.FolderInfo;
import com.install4j.runtime.util.VersionCheck;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.zip.GZIPInputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JreInstaller {
    private String preferredJre = null;
    private File preferredJreFile;
    private long jreSize = -1L;
    private int jreCount = -1;
    private static final String JRE_DIR = "jre";
    private static final String JRE_TAR = "jre.tar";
    private static final String JRE_BUNDLE = "jre.bundle";
    private static final String SYSTEM_PREFS = ".systemPrefs";
    private static final boolean MANUAL_JRE = Boolean.getBoolean("exe4j.manualJre");
    private static final String USED_MAC_JRE_BUNDLE = System.getProperty("i4j.jreBundle");
    private static final String BUNDLED_MAC_TAR_FILE = System.getProperty("i4j.tarFile");
    private static final String REGKEY_LOCATED_JVMS = "SOFTWARE\\ej-technologies\\exe4j\\locatedjvms\\";
    private FileInstaller fileInstaller = FileInstaller.getInstance();
    private File destinationDirectory = null;
    private boolean sharedInstallation;
    private static final String JRE_BACKUP_DIR = "__i4j_jre_backup";
    private static JreInstaller instance;

    public static synchronized JreInstaller getInstance() {
        if (instance == null) {
            instance = new JreInstaller();
        }
        return instance;
    }

    private JreInstaller() {
    }

    public void prepareUninstall(UninstallerContext uninstallerContext) {
        if (!(uninstallerContext.isUninstallForUpgrade() || Util.isMacOS() || Util.isWindows())) {
            this.fileInstaller.deleteRecursive(new File(new File(uninstallerContext.getInstallationDirectory(), JRE_DIR), SYSTEM_PREFS));
        }
    }

    public long installJre(InstallerContext installerContext, ProgressInterface progressInterface, InstallFilesAction installFilesAction, long l, long l2) throws IOException, UserCanceledException {
        File file;
        this.updateDestinationDirectory(installerContext.getInstallationDirectory());
        UninstallMode uninstallMode = UninstallMode.IF_CREATED_BUT_NOT_FOR_UPDATE;
        if (this.sharedInstallation) {
            uninstallMode = UninstallMode.NEVER;
        }
        if (InstallerUtil.isWindows()) {
            file = new File(JRE_DIR).getAbsoluteFile();
            if (file.exists()) {
                this.prepareJreDestDir(uninstallMode);
                l2 = this.installDir(installerContext, file, this.destinationDirectory, progressInterface, installFilesAction, l, l2, uninstallMode);
            }
        } else if (Util.isMacosInstaller()) {
            this.prepareJreDestDir(uninstallMode);
            l2 = this.installDir(installerContext, new File(USED_MAC_JRE_BUNDLE).getAbsoluteFile(), this.destinationDirectory, progressInterface, installFilesAction, l, l2, uninstallMode);
        } else {
            file = new File(JRE_TAR).getAbsoluteFile();
            if (file.exists()) {
                this.prepareJreDestDir(uninstallMode);
                l2 = this.installTar(installerContext, file, this.destinationDirectory, new File(JRE_DIR).getAbsoluteFile(), progressInterface, installFilesAction, l, l2, uninstallMode);
            }
        }
        if (!InstallerUtil.isWindows9X() && !Util.isMacosInstaller() && this.destinationDirectory != null && InstallerConfig.getCurrentInstance().getJreVersion() != null && InstallerConfig.getCurrentInstance().getJreVersion().trim().length() > 2 && InstallerConfig.getCurrentInstance().getJreVersion().trim().substring(0, 3).compareTo("1.5") >= 0 && (file = new File(this.destinationDirectory, "bin/java" + (InstallerUtil.isWindows() ? "w.exe" : ""))).exists() && !new File(this.destinationDirectory, "bin/jrockit").exists()) {
            FileInstaller.getInstance().registerUninstallFile(installerContext.getDestinationFile("jre/bin/client/classes.jsa"));
            FileInstaller.getInstance().registerUninstallFile(installerContext.getDestinationFile("jre/bin/server/classes.jsa"));
            FileInstaller.getInstance().registerUninstallFile(installerContext.getDestinationFile("jre/lib/i386/client/classes.jsa"));
            FileInstaller.getInstance().registerUninstallFile(installerContext.getDestinationFile("jre/lib/sparc/client/classes.jsa"));
            FileInstaller.getInstance().registerUninstallFile(installerContext.getDestinationFile("jre/lib/amd64/client/classes.jsa"));
            try {
                if (System.getProperty("java.vm.vendor", "").toLowerCase().indexOf("sun") > -1) {
                    Runtime.getRuntime().exec(new String[]{file.getAbsolutePath(), "-Xshare:dump"});
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return l2;
    }

    private void prepareJreDestDir(UninstallMode uninstallMode) throws IOException {
        if (this.destinationDirectory.exists() && !this.destinationDirectory.renameTo(new File(this.destinationDirectory.getParent(), JRE_BACKUP_DIR))) {
            FileUtil.emptyDirectory(this.destinationDirectory);
        }
        FileInstaller.getInstance().createDirectory(this.destinationDirectory, uninstallMode);
        this.addPreferredJreToRegistry(this.destinationDirectory);
    }

    private void addPreferredJreToRegistry(File file) {
        String string;
        if (this.sharedInstallation && InstallerUtil.isWindows() && !WinRegistry.createKey(RegistryRoot.HKEY_LOCAL_MACHINE, string = REGKEY_LOCATED_JVMS + file.getAbsolutePath().replace('\\', '/') + "/bin/java.exe")) {
            WinRegistry.createKey(RegistryRoot.HKEY_CURRENT_USER, string);
        }
    }

    private void updateDestinationDirectory(File file) {
        this.destinationDirectory = null;
        if (InstallerConfig.getCurrentInstance().isJreShared()) {
            File file2 = null;
            if (Util.hasFullAdminRights() || InstallerUtil.isWindows()) {
                File file3 = InstallerUtil.isWindows() && !InstallerUtil.isWindows9X() ? FolderInfo.getCommonFilesDirectory() : new File(InstallerUtil.getStandardApplicationsDirectory());
                file3 = new File(file3, "i4j_jres");
                file2 = JreInstaller.getSharedJreSubdir(file3);
            }
            if (file2 != null && InstallerUtil.checkWritableInstallationDirectory(file2, false)) {
                this.sharedInstallation = true;
                this.destinationDirectory = file2;
            } else {
                file2 = JreInstaller.getSharedJreSubdir(new File(Util.getUserHome(), ".i4j_jres"));
                if (InstallerUtil.checkWritableInstallationDirectory(file2, false)) {
                    this.sharedInstallation = true;
                    this.destinationDirectory = file2;
                }
            }
        }
        if (this.destinationDirectory == null) {
            this.sharedInstallation = false;
            this.destinationDirectory = Util.isMacosInstaller() ? (InstallerConfig.getCurrentInstance().getMacSpecificConfig().isSingleBundle() ? new File(new File(file, InstallerConfig.getCurrentInstance().getMacSpecificConfig().getSingleBundleName()), "Contents/PlugIns/jre.bundle") : new File(file, ".install4j/jre.bundle")) : new File(file, JRE_DIR);
        }
    }

    private static File getSharedJreSubdir(File file) {
        String string = InstallerConfig.getCurrentInstance().getJreVersion().trim();
        if (!string.equals("")) {
            return new File(file, string);
        }
        int n = 1;
        File file2 = new File(file, JRE_DIR + n);
        while (file2.exists()) {
            file2 = new File(file, JRE_DIR + ++n);
        }
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long installTar(InstallerContext installerContext, File file, File file2, File file3, ProgressInterface progressInterface, InstallFilesAction installFilesAction, long l, long l2, UninstallMode uninstallMode) throws IOException, UserCanceledException {
        TarArchiveInputStream tarArchiveInputStream;
        Object object;
        try {
            object = new BufferedInputStream(new FileInputStream(file));
            if (file.getName().endsWith(".gz")) {
                try {
                    object = new GZIPInputStream((InputStream)object);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            tarArchiveInputStream = new TarArchiveInputStream((InputStream)object);
        }
        catch (Exception exception) {
            throw new ReadIOException(exception);
        }
        try {
            try {
                object = tarArchiveInputStream.getNextTarEntry();
            }
            catch (Exception exception) {
                throw new ReadIOException(exception);
            }
            while (object != null) {
                if (installerContext.isCancelling()) {
                    throw new UserCanceledException();
                }
                boolean bl = false;
                String string = ((TarArchiveEntry)object).getName();
                if (string.endsWith("jar.pack")) {
                    string = string.substring(0, string.length() - 5);
                    bl = true;
                }
                progressInterface.setDetailMessage(InstallerUtil.cleanupName(string));
                File file4 = new File(file2, string);
                if (((TarArchiveEntry)object).isSymbolicLink()) {
                    l2 += 153600L;
                    UnixFileSystem.createLink(((TarArchiveEntry)object).getLinkName(), file4);
                    this.fileInstaller.registerUninstallFile(file4);
                } else if (((TarArchiveEntry)object).isDirectory()) {
                    l2 += 153600L;
                    this.fileInstaller.createDirectory(file4, uninstallMode);
                } else {
                    long l3 = l2 + 153600L + ((TarArchiveEntry)object).getSize();
                    FileOptions fileOptions = new FileOptions();
                    fileOptions.setMode(((TarArchiveEntry)object).getMode());
                    fileOptions.setUninstallMode(uninstallMode);
                    fileOptions.setFileTime(((TarArchiveEntry)object).getModTime().getTime());
                    fileOptions.setDelayIfNecessary(installFilesAction.isDelay());
                    if (bl) {
                        this.fileInstaller.install(new File(file3, string), file4, fileOptions, new ProgressAdapter(progressInterface, (int)(l2 * 100L / l), (int)(l3 * 100L / l)));
                    } else {
                        this.fileInstaller.install(tarArchiveInputStream, file4, fileOptions, new ProgressAdapter(progressInterface, (int)(l2 * 100L / l), (int)(l3 * 100L / l)), ((TarArchiveEntry)object).getSize(), false);
                    }
                    l2 = l3;
                }
                progressInterface.setPercentCompleted((int)(l2 * 100L / l));
                try {
                    object = tarArchiveInputStream.getNextTarEntry();
                }
                catch (Exception exception) {
                    throw new ReadIOException(exception);
                    return l2;
                }
            }
        }
        finally {
            try {
                tarArchiveInputStream.close();
            }
            catch (Exception exception) {
                throw new ReadIOException(exception);
            }
        }
    }

    private long installDir(InstallerContext installerContext, File file, File file2, ProgressInterface progressInterface, InstallFilesAction installFilesAction, long l, long l2, UninstallMode uninstallMode) throws IOException, UserCanceledException {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (installerContext.isCancelling()) {
                    throw new UserCanceledException();
                }
                File file3 = fileArray[i];
                progressInterface.setDetailMessage(InstallerUtil.cleanupName(file3.getName()));
                File file4 = new File(file2, file3.getName());
                if (file3.isDirectory()) {
                    this.fileInstaller.createDirectory(file4, uninstallMode);
                    l2 = this.installDir(installerContext, file3, file4, progressInterface, installFilesAction, l, l2, uninstallMode);
                    l2 += 153600L;
                } else {
                    long l3 = l2 + 153600L + file3.length();
                    FileOptions fileOptions = new FileOptions();
                    fileOptions.setUninstallMode(uninstallMode);
                    fileOptions.setFileTime(file3.lastModified());
                    fileOptions.setDelayIfNecessary(installFilesAction.isDelay());
                    if (!this.handledSymlink(file3, file4)) {
                        this.fileInstaller.install(file3, file4, fileOptions, new ProgressAdapter(progressInterface, (int)(l2 * 100L / l), (int)(l3 * 100L / l)));
                        this.updatePosixMode(file3, file4);
                    }
                    l2 = l3;
                }
                progressInterface.setPercentCompleted((int)(l2 * 100L / l));
            }
        }
        return l2;
    }

    private void updatePosixMode(File file, File file2) throws IOException {
        if (Util.isMacosInstaller() && file.exists() && file2.exists()) {
            String string = VersionSpecificHelper.getPosixFilePermissions(file);
            VersionSpecificHelper.setPosixFilePermissions(file2, string);
        }
    }

    private boolean handledSymlink(File file, File file2) throws IOException {
        if (Util.isMacosInstaller() && VersionSpecificHelper.isSymbolicLink(file)) {
            file2.delete();
            File file3 = VersionSpecificHelper.getSymbolicLinkTargetFile(file);
            VersionSpecificHelper.createSymbolicLink(file2, file3);
            this.fileInstaller.registerUninstallFile(file2);
            return true;
        }
        return false;
    }

    public boolean checkJreInstallation(File file, boolean bl) throws IOException {
        this.updateDestinationDirectory(file);
        if (MANUAL_JRE && this.preferredJre == null) {
            try {
                String string = new File(System.getProperty("java.home")).getCanonicalPath();
                if (!string.startsWith(new File(System.getProperty("user.dir")).getCanonicalPath())) {
                    this.preferredJre = string;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        boolean bl2 = false;
        if (Util.isMacosInstaller()) {
            if (BUNDLED_MAC_TAR_FILE != null) {
                bl2 = true;
            } else if (!(USED_MAC_JRE_BUNDLE == null || USED_MAC_JRE_BUNDLE.startsWith("/System") || USED_MAC_JRE_BUNDLE.startsWith("/Library") || this.destinationDirectory.getCanonicalPath().equals(new File(USED_MAC_JRE_BUNDLE).getCanonicalPath()))) {
                String string = this.getCurrentMacJreVersion();
                if (string == null) {
                    Logger.getInstance().log(this, "JRE will be copied from " + USED_MAC_JRE_BUNDLE, true);
                    bl2 = true;
                } else {
                    Logger.getInstance().log(this, "Current installed JRE version at " + this.destinationDirectory + " is " + string, true);
                    if (!VersionCheck.checkCompatible(InstallerConfig.getCurrentInstance().getMinJavaVersion(), string)) {
                        Logger.getInstance().log(this, "JRE will be replaced", true);
                        bl2 = true;
                    }
                }
            }
        } else {
            boolean bl3 = bl2 = new File(JRE_DIR).getAbsoluteFile().exists() && (InstallerUtil.isWindows() || new File(JRE_TAR).getAbsoluteFile().exists());
        }
        if (bl2) {
            if (this.preferredJre == null) {
                this.preferredJre = this.destinationDirectory.getAbsolutePath();
            }
            if (this.sharedInstallation || !bl) {
                if (!this.destinationDirectory.exists()) {
                    return true;
                }
                return !new File(this.destinationDirectory, "lib/rt.jar").exists() && !new File(this.destinationDirectory, "jre/lib/rt.jar").exists();
            }
            return true;
        }
        return false;
    }

    private String getCurrentMacJreVersion() {
        File file = new File(this.destinationDirectory, "Contents/Info.plist");
        if (file.exists()) {
            try {
                Document document = XmlHelper.parseFile(file);
                Element element = document.getDocumentElement();
                return XmlHelper.getTextValue(PlistHelper.findValue(PlistHelper.getFirstChild(element, "dict"), "CFBundleVersion"));
            }
            catch (IOException iOException) {
                Logger.getInstance().log(iOException);
            }
        }
        return null;
    }

    public long getJreSize() throws IOException {
        if (this.jreSize == -1L) {
            this.initJreSizeAndCount();
        }
        return this.jreSize;
    }

    private void initJreSizeAndCount() throws IOException {
        if (InstallerUtil.isWindows()) {
            File file = new File(JRE_DIR).getAbsoluteFile();
            this.jreSize = JreInstaller.countSize(file);
            this.jreCount = JreInstaller.countFilesAndDirs(file);
        } else if (Util.isMacosInstaller()) {
            this.jreSize = 0L;
            this.jreCount = 0;
            if (BUNDLED_MAC_TAR_FILE != null || USED_MAC_JRE_BUNDLE != null && !USED_MAC_JRE_BUNDLE.startsWith("/System") && !USED_MAC_JRE_BUNDLE.startsWith("/Library")) {
                File file = new File(USED_MAC_JRE_BUNDLE).getAbsoluteFile();
                this.jreSize = JreInstaller.countSize(file);
                this.jreCount = JreInstaller.countFilesAndDirs(file);
            }
        } else {
            this.jreSize = 0L;
            this.jreCount = 0;
            File file = new File(JRE_TAR).getAbsoluteFile();
            if (file.exists()) {
                TarArchiveInputStream tarArchiveInputStream = new TarArchiveInputStream(new BufferedInputStream(new FileInputStream(file)));
                TarArchiveEntry tarArchiveEntry = tarArchiveInputStream.getNextTarEntry();
                while (tarArchiveEntry != null) {
                    ++this.jreCount;
                    this.jreSize += tarArchiveEntry.getSize();
                    tarArchiveEntry = tarArchiveInputStream.getNextTarEntry();
                }
            }
        }
    }

    public int getJreCount() throws IOException {
        if (this.jreCount == -1) {
            this.initJreSizeAndCount();
        }
        return this.jreCount;
    }

    private static int countFilesAndDirs(File file) {
        int n = 0;
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                ++n;
                if (!file2.isDirectory()) continue;
                n += JreInstaller.countFilesAndDirs(file2);
            }
        }
        return n;
    }

    private static long countSize(File file) {
        long l = 0L;
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (file2.isDirectory()) {
                    l += JreInstaller.countSize(file2);
                    continue;
                }
                l += file2.length();
            }
        }
        return l;
    }

    public void writePreferredJre(File file) throws UserCanceledException, IOException {
        this.writeOneLineFile(new File(file, "inst_jre.cfg"), System.getProperty("java.home"));
        this.preferredJreFile = new File(file, "pref_jre.cfg");
        if (this.preferredJre != null) {
            this.writeOneLineFile(this.preferredJreFile, this.preferredJre);
        }
        String string = this.preferredJre == null ? System.getProperty("java.home") : (Util.isMacOS() && this.preferredJre.endsWith(".bundle") ? this.preferredJre + "/Contents/Home/jre" : this.preferredJre);
        InstallerVariables.setVariable("sys.preferredJre", string);
    }

    public void setPreferredJre(String string) {
        this.preferredJre = string;
        if (string != null && this.preferredJreFile != null) {
            try {
                this.writeOneLineFile(this.preferredJreFile, string);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (UserCanceledException userCanceledException) {
                userCanceledException.printStackTrace();
            }
        }
    }

    private void writeOneLineFile(File file, String string) throws IOException, UserCanceledException {
        this.fileInstaller.createDirectory(file.getParentFile());
        File file2 = File.createTempFile("i4j", null);
        PrintWriter printWriter = new PrintWriter(new FileWriter(file2));
        printWriter.println(string);
        printWriter.close();
        FileInstaller.getInstance().install(file2, file, new FileOptions("644", OverwriteMode.ALWAYS, false));
        file2.delete();
    }

    public void cleanup() {
        File file;
        if (this.destinationDirectory != null && (file = new File(this.destinationDirectory.getParent(), JRE_BACKUP_DIR)).exists()) {
            FileUtil.deleteDirectory(file);
        }
    }

    public void rollback() {
        File file;
        if (this.destinationDirectory != null && (file = new File(this.destinationDirectory.getParent(), JRE_BACKUP_DIR)).exists()) {
            FileUtil.deleteDirectory(this.destinationDirectory);
            if (!file.renameTo(this.destinationDirectory)) {
                this.destinationDirectory.mkdirs();
                try {
                    FileUtil.copyDirectory(file, this.destinationDirectory, true);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                FileUtil.deleteDirectory(file);
            }
        }
    }
}

