/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper;

import com.exe4j.runtime.util.FileUtil;
import com.exe4j.runtime.util.ResourceHelper;
import com.install4j.api.Util;
import com.install4j.api.beans.Bean;
import com.install4j.api.beans.ScriptProperty;
import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.launcher.ApplicationLauncher;
import com.install4j.api.windows.RegistryRoot;
import com.install4j.api.windows.WinEnvVars;
import com.install4j.api.windows.WinRegistry;
import com.install4j.runtime.beans.applications.Application;
import com.install4j.runtime.beans.applications.ExecutionMode;
import com.install4j.runtime.beans.applications.InstallerApplication;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.config.AbstractBeanConfig;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.LanguageConfig;
import com.install4j.runtime.installer.config.ScriptClassOrigin;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.VariableResourceBundleWrapper;
import com.install4j.runtime.installer.helper.ClasspathModificator;
import com.install4j.runtime.installer.helper.ConsoleImpl;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.Script;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.CommunicationAction;
import com.install4j.runtime.installer.helper.comm.actions.FetchBooleanAction;
import com.install4j.runtime.installer.helper.comm.actions.RunAction;
import com.install4j.runtime.installer.helper.comm.responses.Response;
import com.install4j.runtime.installer.helper.content.ContentInstaller;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import com.install4j.runtime.installer.helper.versionspecific.VersionSpecificHelper;
import com.install4j.runtime.installer.platform.win32.FolderInfo;
import com.install4j.runtime.installer.platform.win32.Win32CommunicationBackend;
import com.install4j.runtime.util.StringUtil;
import com.install4j.runtime.util.VersionCheck;
import java.awt.Frame;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JOptionPane;

public class InstallerUtil {
    public static final String OS_NAME = System.getProperty("os.name");
    public static final String OS_ARCH = System.getProperty("os.arch");
    public static final String OS_VERSION = System.getProperty("os.version");
    public static final String CLASS_NAME_PREFIX = "I4jScript_Internal_";
    public static final Pattern CLASS_NAME_PATTERN = Pattern.compile("(I4jScript_Internal_\\d+)\\.java");
    public static final boolean DEBUG = Boolean.getBoolean("install4j.debug");
    public static final String REGKEY_EXE4J = "SOFTWARE\\ej-technologies\\exe4j\\";
    public static final String REGVAL_SETTING_LAF = "SettingLaf";
    public static final String INSTALL4J_ARGUMENTS = "INSTALL4J_ARGUMENTS";
    private static final String REGVAL_INSTALL_STARTED = "InstallStarted";
    private static ApplicationLauncher.Callback inProcessCallback;
    private static State state;
    private static final Pattern HTML_CONTENT_TYPE_PATTERN;

    public static boolean isInProcess() {
        return InstallerUtil.state.inProcess;
    }

    public static void setInProcess(boolean bl) {
        InstallerUtil.state.inProcess = bl;
    }

    public static void setShutdownOnInProcessExit(boolean bl) {
        HelperCommunication.helperUnsupported();
        InstallerUtil.state.shutdownOnInProcessExit = bl;
    }

    public static void setInProcessCallback(ApplicationLauncher.Callback callback) {
        HelperCommunication.helperUnsupported();
        inProcessCallback = callback;
    }

    public static String getInstallerType() {
        if (InstallerUtil.state.installerType == null) {
            InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
            if (installerConfig == null) {
                try {
                    installerConfig = InstallerConfig.getGeneralConfigFromFile(InstallerUtil.getInstallerFile("i4jparams.conf"));
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
            InstallerUtil.state.installerType = installerConfig.getType();
        }
        return InstallerUtil.state.installerType;
    }

    public static void initHelperState() {
        state = ((StateResponse)HelperCommunication.getInstance().executeAction(ExecutionContext.UNELEVATED, new CommunicationAction(){

            public Response execute(Context context) throws UserCanceledException {
                InstallerUtil.getInstallerType();
                return new StateResponse(state);
            }
        })).remoteState;
    }

    public static void exit(int n) {
        HelperCommunication.helperUnsupported();
        if (!InstallerUtil.state.inProcess) {
            System.exit(n);
        } else {
            ContextImpl.clearContext();
            InstallerConfig.clearCurrentApplication();
            FileInstaller.clearFileInstaller();
            AbstractBeanConfig.clearBeans();
            if (InstallerUtil.state.shutdownOnInProcessExit && n == 0) {
                if (inProcessCallback != null) {
                    inProcessCallback.prepareShutdown();
                }
                System.exit(0);
            } else if (inProcessCallback != null) {
                inProcessCallback.exited(n);
                inProcessCallback = null;
            }
        }
    }

    public static boolean isUnattended() {
        return InstallerUtil.state.unattended;
    }

    public static void setUnattended(boolean bl) {
        InstallerUtil.state.unattended = bl;
    }

    public static boolean isConsole() {
        return InstallerUtil.state.console;
    }

    public static void setConsole(boolean bl) {
        InstallerUtil.state.console = bl;
    }

    public static boolean isSolaris() {
        return OS_NAME.equals("SunOS");
    }

    public static boolean isLinux() {
        return OS_NAME.toLowerCase().startsWith("linux");
    }

    public static boolean isWindows() {
        return OS_NAME.toLowerCase().startsWith("win");
    }

    public static boolean isWindowsXP() {
        return OS_NAME.toLowerCase().startsWith("windows xp");
    }

    public static boolean isWindows2000() {
        return OS_NAME.toLowerCase().startsWith("windows 2000");
    }

    public static boolean isMacOS() {
        return OS_NAME.toLowerCase().startsWith("mac");
    }

    public static boolean isWindowsMe() {
        return OS_NAME.startsWith("Windows Me");
    }

    public static boolean isWindows9X() {
        return OS_NAME.startsWith("Windows 98") || OS_NAME.startsWith("Windows 95") || OS_NAME.startsWith("Windows Me") || OS_NAME.startsWith("Windows (unknown)");
    }

    public static boolean isWindowsNT() {
        return (OS_NAME.toLowerCase().startsWith("windows nt") || OS_NAME.toLowerCase().startsWith("windowsnt")) && !OS_VERSION.startsWith("6");
    }

    public static boolean isAtLeastWindows2000() {
        try {
            return InstallerUtil.isWindows() && !InstallerUtil.isWindows9X() && Double.parseDouble(OS_VERSION.substring(0, 3)) >= 5.0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isAtLeastWindowsXP() {
        try {
            return InstallerUtil.isWindows() && !InstallerUtil.isWindows9X() && Double.parseDouble(OS_VERSION.substring(0, 3)) >= 5.1;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isAtLeastWindowsVista() {
        try {
            return InstallerUtil.isWindows() && !InstallerUtil.isWindows9X() && Double.parseDouble(OS_VERSION.substring(0, 3)) >= 6.0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isAtLeastWindows7() {
        try {
            return InstallerUtil.isWindows() && !InstallerUtil.isWindows9X() && Double.parseDouble(OS_VERSION.substring(0, 3)) >= 6.1;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isWindowsVista() {
        return OS_NAME.toLowerCase().startsWith("windows vista") || OS_NAME.toLowerCase().startsWith("windows nt") && OS_VERSION.startsWith("6.0");
    }

    public static boolean isWindows7() {
        return OS_NAME.toLowerCase().startsWith("windows 7") || OS_NAME.toLowerCase().startsWith("windows vista") && OS_VERSION.startsWith("6.1");
    }

    public static boolean isWindows8() {
        return OS_NAME.toLowerCase().startsWith("windows") && OS_VERSION.startsWith("6.2");
    }

    public static boolean isWindows2003() {
        return OS_NAME.toLowerCase().startsWith("windows") && OS_NAME.indexOf("2003") > -1;
    }

    public static boolean isWindows2008() {
        return OS_NAME.toLowerCase().startsWith("windows") && OS_NAME.indexOf("2008") > -1;
    }

    public static boolean isWindows2012() {
        return OS_NAME.toLowerCase().startsWith("windows") && OS_NAME.indexOf("2012") > -1;
    }

    public static boolean isHpux() {
        return OS_NAME.equals("HP-UX");
    }

    public static boolean isAix() {
        return OS_NAME.equals("AIX");
    }

    public static boolean isUpToJava15() {
        String string = System.getProperty("java.version");
        return string.startsWith("1.2") || string.startsWith("1.3") || string.startsWith("1.4") || string.startsWith("1.5");
    }

    public static String getStandardApplicationsDirectory() {
        if (InstallerUtil.isWindows()) {
            return FolderInfo.getProgramFilesDirectory().getAbsolutePath();
        }
        if (InstallerUtil.isMacOS()) {
            return "/Applications";
        }
        File file = new File("/opt");
        String[] stringArray = file.list();
        String string = file.exists() && stringArray != null && stringArray.length > 0 ? "/opt" : "/usr/local";
        File file2 = new File(string);
        if (file2.exists() && file2.canWrite()) {
            return string;
        }
        return Util.getUserHome();
    }

    public static File getInstallerFile(String string) {
        File file;
        String string2 = InstallerConfig.getCurrentApplicationId();
        if ((string2 == null || string2.equals("installer")) && (file = new File(string).getAbsoluteFile()).exists()) {
            return file;
        }
        file = new File(ResourceHelper.getRuntimeDir(), string);
        if (file.exists() || !Util.isMacOS()) {
            return file;
        }
        return new File(string).getAbsoluteFile();
    }

    public static synchronized void loadJREDeployLibs() {
        if (InstallerUtil.state.deployLibsLodaded) {
            return;
        }
        if (InstallerUtil.isWindows() && !InstallerUtil.isWindows9X() && !InstallerUtil.isWindowsNT()) {
            HelperCommunication.getInstance().executeAction(ExecutionContext.ALL, new RunAction(){

                protected void run(Context context) {
                    block6: {
                        File file;
                        File file2;
                        File file3;
                        String string = System.getProperty("java.home");
                        File file4 = new File(string, "lib");
                        File file5 = new File(file4, "deploy.jar");
                        if (file5.exists()) {
                            ClasspathModificator.addClassPath(file5);
                        }
                        if ((file3 = new File(file4, "plugin.jar")).exists()) {
                            ClasspathModificator.addClassPath(file3);
                        }
                        if ((file2 = new File(file = new File(string, "bin"), "deploy.dll")).exists()) {
                            try {
                                System.load(file2.getPath());
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                                if (unsatisfiedLinkError.getMessage().indexOf("already loaded in another classloader") >= 0) break block6;
                                throw unsatisfiedLinkError;
                            }
                        }
                    }
                    state.deployLibsLodaded = true;
                }
            });
        }
    }

    public static ExecutionMode getExecutionMode(CommandLineOptions commandLineOptions, boolean bl) {
        Application application = InstallerConfig.getCurrentApplication();
        ExecutionMode executionMode = application.getExecutionMode();
        String string = System.getProperty("install4j.executionMode");
        if ("gui".equals(string)) {
            executionMode = ExecutionMode.GUI;
        } else if ("console".equals(string)) {
            executionMode = ExecutionMode.CONSOLE;
        } else if ("unattended".equals(string)) {
            executionMode = ExecutionMode.UNATTENDED;
        }
        if (commandLineOptions.quiet && (application.isAllowUnattended() || bl)) {
            executionMode = ExecutionMode.UNATTENDED;
        } else if (commandLineOptions.console && InstallerUtil.isAllowConsole(application)) {
            executionMode = ExecutionMode.CONSOLE;
        } else if (commandLineOptions.gui) {
            executionMode = ExecutionMode.GUI;
        }
        if (executionMode == ExecutionMode.GUI && Util.isUnixInstaller() && InstallerUtil.isAllowConsole(application) && application.isUnixFallbackToConsole()) {
            try {
                new Frame();
            }
            catch (Throwable throwable) {
                executionMode = ExecutionMode.CONSOLE;
            }
        }
        return executionMode;
    }

    public static String getSupportedSystemLanguageId() {
        Logger logger = Logger.getInstance();
        Locale locale = Locale.getDefault();
        String string = locale.getLanguage();
        logger.info(null, "System language '" + string + "'");
        if (InstallerConfig.getCurrentInstance().getLanguageById(string) != null) {
            return string;
        }
        string = string + "_" + locale.getCountry();
        logger.info(null, "System locale '" + string + "'");
        if (InstallerConfig.getCurrentInstance().getLanguageById(string) != null) {
            return string;
        }
        logger.info(null, "System locale not found in available languages");
        return null;
    }

    public static String insertBeanNames(String string, Map map) {
        Matcher matcher = CLASS_NAME_PATTERN.matcher("");
        String[] stringArray = string.split("\n");
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            InstallerUtil.addBeanNameToBuffer(string2, map, stringBuffer, matcher);
            stringBuffer.append(string2);
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public static boolean addBeanNameToBuffer(String string, Map map, StringBuffer stringBuffer, Matcher matcher) {
        String string2;
        ScriptClassOrigin scriptClassOrigin;
        matcher.reset(string);
        if (matcher.find() && (scriptClassOrigin = (ScriptClassOrigin)map.get(string2 = matcher.group(1))) != null) {
            stringBuffer.append("In ");
            stringBuffer.append(scriptClassOrigin.getBeanType());
            stringBuffer.append(" \"");
            stringBuffer.append(scriptClassOrigin.getBeanName());
            stringBuffer.append("\"");
            if (scriptClassOrigin.getParentScreen().length() > 0) {
                stringBuffer.append(" (screen \"");
                stringBuffer.append(scriptClassOrigin.getParentScreen());
                stringBuffer.append("\")");
            }
            stringBuffer.append(", property \"");
            stringBuffer.append(scriptClassOrigin.getPropertyName());
            stringBuffer.append("\":\n");
            return true;
        }
        return false;
    }

    public static String prependBeanOrigin(String string, Map map) {
        String string2;
        Matcher matcher = CLASS_NAME_PATTERN.matcher("");
        String[] stringArray = string.split("\n");
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length && !InstallerUtil.addBeanNameToBuffer(string2 = stringArray[i], map, stringBuffer, matcher); ++i) {
        }
        return stringBuffer.toString() + string;
    }

    public static void disablePreferencesLogging() {
        VersionSpecificHelper.disablePreferencesLogging();
    }

    public static boolean is64BitWindows() {
        return InstallerUtil.is64BitWindowsArch(WinEnvVars.getenv("PROCESSOR_ARCHITECTURE")) || InstallerUtil.is64BitWindowsArch(WinEnvVars.getenv("PROCESSOR_ARCHITEW6432"));
    }

    private static boolean is64BitWindowsArch(String string) {
        return string != null && (string.equalsIgnoreCase("AMD64") || string.equalsIgnoreCase("IA64"));
    }

    public static String[] getCommandLineParameters() {
        return InstallerUtil.state.commandLineParameters;
    }

    public static String[] getExtraCommandLineParameters() {
        return InstallerUtil.state.extraCommandLineParameters;
    }

    public static String getSplash(CommandLineOptions commandLineOptions, ExecutionMode executionMode) {
        String string = commandLineOptions.splash;
        if (executionMode == ExecutionMode.UNATTENDED_WITH_PROGRESS && string == null) {
            string = InstallerConfig.getCurrentApplication().getSplashMessage();
        }
        return string;
    }

    public static boolean isAllowConsole(Application application) {
        HelperCommunication.helperUnsupported();
        return application.isAllowConsole() && (!InstallerUtil.isWindows() || !application.isDisableConsoleOnWindows());
    }

    public static CommandLineOptions parseCommandLine(String[] stringArray) {
        Object object;
        ArrayList<Object> arrayList;
        Object object2;
        HelperCommunication.helperUnsupported();
        InstallerUtil.state.commandLineParameters = stringArray;
        if (!HelperCommunication.getInstance().isElevatedHelper()) {
            try {
                object2 = (String)VersionSpecificHelper.getenv().get(INSTALL4J_ARGUMENTS);
                if (object2 != null) {
                    arrayList = new ArrayList();
                    StringUtil.splitupQuotedList(arrayList, (String)object2, " ");
                    stringArray = arrayList.toArray(new String[arrayList.size()]);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        object2 = new CommandLineOptions();
        arrayList = new ArrayList<Object>();
        for (int i = 0; i < stringArray.length; ++i) {
            object = stringArray[i];
            if (((String)object).equals("-q") && !((CommandLineOptions)object2).console && !((CommandLineOptions)object2).gui) {
                ((CommandLineOptions)object2).quiet = true;
                continue;
            }
            if (((String)object).equals("-c") && !((CommandLineOptions)object2).quiet && !((CommandLineOptions)object2).gui) {
                ((CommandLineOptions)object2).console = true;
                continue;
            }
            if (((String)object).equals("-g") && !((CommandLineOptions)object2).console && !((CommandLineOptions)object2).quiet) {
                ((CommandLineOptions)object2).gui = true;
                continue;
            }
            if (((String)object).equals("-overwrite")) {
                ((CommandLineOptions)object2).quietOverwrite = true;
                continue;
            }
            if (((String)object).equals("-h") || ((String)object).equals("-help") || ((String)object).equals("/?")) {
                ((CommandLineOptions)object2).help = true;
                continue;
            }
            if (((String)object).equals("-dir") && i + 1 < stringArray.length) {
                ((CommandLineOptions)object2).installDir = new File(stringArray[++i].trim());
                continue;
            }
            if (((String)object).equals("-wait") && i + 1 < stringArray.length) {
                ((CommandLineOptions)object2).wait = Integer.parseInt(stringArray[++i]);
                continue;
            }
            if (((String)object).equals("-varfile") && i + 1 < stringArray.length) {
                ((CommandLineOptions)object2).varFileName = stringArray[++i];
                continue;
            }
            if (((String)object).equals("-splash") && i + 1 < stringArray.length) {
                ((CommandLineOptions)object2).splash = stringArray[++i];
                continue;
            }
            boolean bl = ((String)object).startsWith("-D");
            boolean bl2 = ((String)object).startsWith("-V");
            if (bl || bl2) {
                int n = ((String)object).indexOf(61);
                if (n <= -1 || ((String)object).length() <= n + 1) continue;
                String string = ((String)object).substring(2, n);
                String string2 = ((String)object).substring(n + 1);
                if (bl) {
                    System.setProperty(string, string2);
                    continue;
                }
                ((CommandLineOptions)object2).commandLineVars.setProperty(string, string2);
                continue;
            }
            arrayList.add(object);
        }
        InstallerUtil.state.extraCommandLineParameters = arrayList.toArray(new String[arrayList.size()]);
        if (((CommandLineOptions)object2).help) {
            InstallerUtil.registerStarted(false);
            ArrayList<String[]> arrayList2 = new ArrayList<String[]>();
            object = InstallerConfig.getCurrentApplication();
            Messages.setLanguageConfig((LanguageConfig)InstallerConfig.getCurrentInstance().getLanguages().get(0));
            VariableResourceBundleWrapper variableResourceBundleWrapper = Messages.getMessages();
            arrayList2.add(new String[]{"-varfile [file]", variableResourceBundleWrapper.getString("HelpResponseFile")});
            if (InstallerUtil.isAllowConsole((Application)object)) {
                arrayList2.add(new String[]{"-c", variableResourceBundleWrapper.getString("HelpConsoleMode")});
            }
            if (((Application)object).isAllowUnattended()) {
                arrayList2.add(new String[]{"-q", variableResourceBundleWrapper.getString("HelpUnattendedMode")});
                if (object instanceof InstallerApplication) {
                    arrayList2.add(new String[]{"-dir [directory]", variableResourceBundleWrapper.getString("HelpUnattendedDir")});
                    arrayList2.add(new String[]{"-overwrite", variableResourceBundleWrapper.getString("HelpUnattendedOverwrite")});
                }
                arrayList2.add(new String[]{"-splash [title]", variableResourceBundleWrapper.getString("HelpUnattendedSplash")});
                if (InstallerUtil.isWindows()) {
                    arrayList2.add(new String[]{"-console", variableResourceBundleWrapper.getString("HelpUnattendedConsole")});
                }
            }
            if (InstallerUtil.isWindows()) {
                arrayList2.add(new String[]{"-manual", variableResourceBundleWrapper.getString("HelpManual")});
            }
            if (((Application)object).getExecutionMode() != ExecutionMode.GUI) {
                arrayList2.add(new String[]{"-g", variableResourceBundleWrapper.getString("HelpGuiMode")});
            }
            arrayList2.add(new String[]{"-Dname=value", variableResourceBundleWrapper.getString("HelpSystemProperties")});
            arrayList2.add(new String[]{"-h", variableResourceBundleWrapper.getString("HelpHelp")});
            try {
                ScriptProperty scriptProperty = ((Application)object).getHelpCustomizer();
                if (scriptProperty != null && !scriptProperty.getValue().equals("")) {
                    ((Script)Class.forName(scriptProperty.getValue()).newInstance()).evaluate(null, (Bean)object, new Object[]{arrayList2});
                }
            }
            catch (Exception exception) {
                Logger.getInstance().log(exception);
            }
            InstallerUtil.showHelp(variableResourceBundleWrapper.getString("HelpHeaderLabel"), arrayList2, ((CommandLineOptions)object2).console);
            InstallerUtil.exit(1);
        }
        return object2;
    }

    private static void showHelp(String string, List list, boolean bl) {
        if (bl) {
            InstallerUtil.showConsoleHelp(string, list);
        } else {
            try {
                InstallerUtil.showGuiHelp(string, list);
            }
            catch (Throwable throwable) {
                InstallerUtil.showConsoleHelp(string, list);
            }
        }
    }

    private static void showGuiHelp(String string, List list) {
        StringBuffer stringBuffer = new StringBuffer("<html>");
        stringBuffer.append(string);
        stringBuffer.append("<br><br><table border=0 cellspacing=0>");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String[] stringArray = (String[])iterator.next();
            stringBuffer.append("<tr><td><b>");
            stringBuffer.append(stringArray[0]);
            stringBuffer.append("</b></td><td>&nbsp;</td><td>");
            stringBuffer.append(stringArray[1]);
            stringBuffer.append("</tr>");
        }
        stringBuffer.append("</table>");
        Util.showMessage(stringBuffer.toString(), 1);
    }

    private static void showConsoleHelp(String string, List list) {
        String[] stringArray;
        ConsoleImpl consoleImpl = ConsoleImpl.getInstance();
        consoleImpl.println(string);
        consoleImpl.println();
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            stringArray = (String[])iterator.next();
            n = Math.max(stringArray[0].length(), n);
        }
        iterator = list.iterator();
        while (iterator.hasNext()) {
            stringArray = (String[])iterator.next();
            consoleImpl.print(stringArray[0]);
            consoleImpl.print(StringUtil.repeat(" ", n + 1 - stringArray[0].length()));
            consoleImpl.println(stringArray[1]);
        }
    }

    private static List getAddOnApplicationConfigsFromRuntimeDir(File file) {
        ArrayList<InstallerConfig> arrayList = new ArrayList<InstallerConfig>();
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (!file2.getName().startsWith("i4jparams.conf.")) continue;
                try {
                    arrayList.add(InstallerConfig.getGeneralConfigFromFile(file2));
                    continue;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return arrayList;
    }

    public static List getAddOnApplicationConfigs(File file) {
        if (file.exists()) {
            File file2 = new File(file, ".install4j/i4jparams.conf");
            if (file2.exists()) {
                try {
                    return InstallerUtil.getAddOnApplicationConfigsFromRuntimeDir(file2.getParentFile());
                }
                catch (Exception exception) {
                }
            } else if (Util.isMacOS() && (file2 = new File(file, "Contents/Resources/app/.install4j/i4jparams.conf")).exists()) {
                try {
                    return InstallerUtil.getAddOnApplicationConfigsFromRuntimeDir(file2.getParentFile());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static InstallerConfig getOldApplicationConfig(File file) {
        if (file.exists()) {
            File file2 = new File(file, ".install4j/i4jparams.conf");
            if (file2.exists()) {
                try {
                    return InstallerConfig.getGeneralConfigFromFile(file2);
                }
                catch (Throwable throwable) {
                }
            } else if (Util.isMacosInstaller()) {
                String string;
                file2 = new File(file, "Contents/Resources/app/.install4j/i4jparams.conf");
                if (file2.exists()) {
                    try {
                        return InstallerConfig.getGeneralConfigFromFile(file2);
                    }
                    catch (Throwable throwable) {
                    }
                } else if (InstallerConfig.getCurrentInstance() != null && (string = InstallerConfig.getCurrentInstance().getMacSpecificConfig().getSingleBundleName()) != null && string.trim().length() > 0 && (file2 = new File(new File(file, string), "Contents/Resources/app/.install4j/i4jparams.conf")).exists()) {
                    try {
                        return InstallerConfig.getGeneralConfigFromFile(file2);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
        return null;
    }

    public static String getOldApplicationId(File file) {
        InstallerConfig installerConfig = InstallerUtil.getOldApplicationConfig(file);
        if (installerConfig != null) {
            if (installerConfig.getApplicationId().indexOf("${") > -1) {
                return null;
            }
            return installerConfig.getApplicationId();
        }
        return null;
    }

    public static boolean checkWritableInstallationDirectory(final File file, boolean bl) {
        Logger.getInstance().log(null, "checking writable with " + ContentInstaller.getExecutionContext(), true);
        boolean bl2 = HelperCommunication.getInstance().fetchBoolean(ContentInstaller.getExecutionContext(), new FetchBooleanAction(){

            protected boolean fetchValue(Context context) throws UserCanceledException {
                return InstallerUtil.checkWriteable(file);
            }
        });
        if (!bl2 && bl) {
            Util.showMessage(MessageFormat.format(Messages.getMessages().getString("NoWritePermissions2"), file), 2);
        }
        return bl2;
    }

    public static boolean checkWriteable(File file) {
        Serializable serializable;
        ArrayList<File> arrayList = new ArrayList<File>();
        for (serializable = file; serializable != null; serializable = ((File)serializable).getParentFile()) {
            arrayList.add((File)serializable);
        }
        serializable = new ArrayList();
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            File file2 = (File)arrayList.get(i);
            if (!file2.mkdir()) continue;
            serializable.add(file2);
        }
        File file3 = new File(file, "i4j_writeperm_test");
        file3.delete();
        boolean bl = file3.mkdir();
        file3.delete();
        for (int i = serializable.size() - 1; i >= 0; --i) {
            File file4 = (File)serializable.get(i);
            file4.delete();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String loadFile(File file, String string) {
        if (file == null) return null;
        if (!file.exists()) {
            return null;
        }
        try {
            if (!file.getName().toLowerCase().endsWith(".zip")) return InstallerUtil.readString(new FileInputStream(file), InstallerUtil.getDefaultEncoding(file.getName()));
            ZipFile zipFile = new ZipFile(file);
            try {
                ZipEntry zipEntry;
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                do {
                    if (!enumeration.hasMoreElements()) return null;
                } while (!(zipEntry = enumeration.nextElement()).getName().startsWith(string + "."));
                String string2 = InstallerUtil.readString(zipFile.getInputStream(zipEntry), InstallerUtil.getDefaultEncoding(zipEntry.getName()));
                return string2;
            }
            finally {
                zipFile.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private static String getDefaultEncoding(String string) {
        return string.toLowerCase().endsWith(".properties") ? "ISO-8859-1" : "UTF-8";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readString(InputStream inputStream, String string) throws IOException {
        try {
            Object object;
            int n;
            byte[] byArray = new byte[8192];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while ((n = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            String string2 = new String(byArray2, string);
            if (string2.indexOf(60) >= 0 && ((Matcher)(object = HTML_CONTENT_TYPE_PATTERN.matcher(string2))).find()) {
                String string3 = ((Matcher)object).group(3);
                try {
                    if (!string3.equalsIgnoreCase("UTF-8") && Charset.isSupported(string3)) {
                        string2 = new String(byArray2, string3);
                    }
                }
                catch (IllegalCharsetNameException illegalCharsetNameException) {
                    System.err.println("Encoding " + string3 + " in HTML text is invalid.");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    System.err.println("Encoding " + string3 + " in HTML text is not supported by the JRE.");
                }
            }
            string2 = string2.replaceAll("\ufeff", "");
            object = string2;
            return object;
        }
        finally {
            inputStream.close();
        }
    }

    public static String sanitizeHTML(String string) {
        boolean bl;
        String string2 = string.toLowerCase();
        boolean bl2 = bl = string2.indexOf("<html") > -1;
        if (bl) {
            int n = string2.indexOf("<head>");
            int n2 = string2.indexOf("</head>");
            if (n > -1 && n2 > n) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(string.substring(0, n));
                stringBuffer.append(string.substring(n + 6, n2));
                stringBuffer.append(string.substring(n2 + 7));
                string = stringBuffer.toString();
            }
        }
        return string;
    }

    public static String cleanupName(String string) {
        if (string.endsWith("//") || string.endsWith("\\\\")) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static void reportException(Throwable throwable) {
        Logger.getInstance().log(throwable);
        if (DEBUG) {
            System.err.println(Util.getAnnotatedStackTrace(throwable));
        } else {
            Object object;
            Object object2;
            Object object3;
            File file = null;
            try {
                file = File.createTempFile("install4jError", ".log");
                object3 = new PrintWriter(new FileOutputStream(file));
                ((PrintWriter)object3).println("Exception:");
                ((PrintWriter)object3).println();
                ((PrintWriter)object3).print(Util.getAnnotatedStackTrace(throwable));
                ((PrintWriter)object3).println();
                ((PrintWriter)object3).println("System properties:");
                ((PrintWriter)object3).println();
                object2 = System.getProperties().entrySet().iterator();
                while (object2.hasNext()) {
                    object = (Map.Entry)object2.next();
                    ((PrintWriter)object3).print(object.getKey());
                    ((PrintWriter)object3).print("=");
                    ((PrintWriter)object3).println(object.getValue());
                }
                ((PrintWriter)object3).flush();
                ((PrintWriter)object3).close();
                file = InstallerUtil.copyTempFile(file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (file != null) {
                try {
                    file = file.getCanonicalFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            object3 = "An error occurred:\n" + throwable + "\nError log: " + (file == null ? "" : file.getPath());
            object2 = new StringWriter();
            throwable.printStackTrace(new PrintWriter((Writer)object2, true));
            object = ((StringWriter)object2).toString();
            if (InstallerUtil.state.unattended || InstallerUtil.state.console) {
                ConsoleImpl.getInstance().println(object3);
                ConsoleImpl.getInstance().printStackTrace(throwable);
            } else if (((String)object).indexOf("X11") > 0 || throwable instanceof NoClassDefFoundError && ((String)object).indexOf("java.awt.Container") > 0) {
                if (Boolean.getBoolean("install4j.printX11Exception")) {
                    throwable.printStackTrace();
                }
                InstallerUtil.displayXMessage();
            } else {
                final File file2 = file;
                GUIHelper.invokeOnEDT(new Runnable((String)object3, throwable){
                    private final /* synthetic */ String val$message;
                    private final /* synthetic */ Throwable val$t;
                    {
                        this.val$message = string;
                        this.val$t = throwable;
                    }

                    public void run() {
                        try {
                            if (file2 == null) {
                                JOptionPane.showMessageDialog(null, this.val$message, "install4j", 0);
                            } else {
                                int n = JOptionPane.showOptionDialog(null, this.val$message, "install4j", -1, 0, null, new String[]{"OK", "Show Log File"}, null);
                                if (n == 1) {
                                    GUIHelper.showURL(file2.toURI().toString());
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            if (Util.isWindowsInstaller() || Boolean.getBoolean("install4j.suppressX11Message")) {
                                System.err.println(this.val$message);
                                this.val$t.printStackTrace();
                            }
                            InstallerUtil.displayXMessage();
                        }
                    }
                });
            }
        }
    }

    private static File copyTempFile(File file) throws IOException {
        try {
            String string = (String)InstallerVariables.getVariable("sys.mediaDir");
            if (string != null) {
                File file2 = new File(string, file.getName());
                FileUtil.copyFile(file, file2);
                file = file2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return file;
    }

    public static boolean isAtLeastJava15() {
        String string = System.getProperty("java.version");
        return !string.startsWith("1.4") && !string.startsWith("1.3") && !string.startsWith("1.2");
    }

    public static boolean isAtLeastJava16() {
        String string = System.getProperty("java.version");
        return !string.startsWith("1.5") && InstallerUtil.isAtLeastJava15();
    }

    public static boolean isAtLeastJava17() {
        String string = System.getProperty("java.version");
        return !string.startsWith("1.6") && InstallerUtil.isAtLeastJava16();
    }

    private static void displayXMessage() {
        if (InstallerUtil.isConsole() || InstallerUtil.isUnattended()) {
            System.err.println("Headless mode does not work on your system with the used Java runtime");
            System.err.println("environment.");
        } else {
            System.err.println("Could not display the GUI. This application needs access to an X Server.");
            if (InstallerUtil.isAllowConsole(InstallerConfig.getCurrentApplication())) {
                System.err.println("*******************************************************************");
                System.err.println("You can also run this application in console mode without");
                System.err.println("access to an X server by passing the argument -c");
                System.err.println("*******************************************************************");
            } else if (InstallerConfig.getCurrentApplication().isAllowUnattended()) {
                System.err.println("*******************************************************************");
                System.err.println("You can also run this application in unattended mode without");
                System.err.println("access to an X server by passing the argument -q");
                System.err.println("*******************************************************************");
            }
        }
    }

    public static void registerStarted(boolean bl) {
        HelperCommunication.helperUnsupported();
        if (InstallerUtil.isWindows()) {
            String string = "InstallStarted_" + Win32CommunicationBackend.getCurrentProcessId();
            if (WinRegistry.getValue(RegistryRoot.HKEY_CURRENT_USER, REGKEY_EXE4J, string) != null) {
                WinRegistry.setValue(RegistryRoot.HKEY_CURRENT_USER, REGKEY_EXE4J, string, new Integer(bl ? 2 : 0));
            }
            WinRegistry.setValue(RegistryRoot.HKEY_CURRENT_USER, REGKEY_EXE4J, REGVAL_INSTALL_STARTED, new Integer(bl ? 2 : 0));
        }
    }

    public static boolean checkJavaVersion() {
        HelperCommunication.helperUnsupported();
        if (InstallerUtil.isMacOS()) {
            InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
            String string = installerConfig.getMinJavaVersion();
            if (string.trim().equals("")) {
                return true;
            }
            if (VersionCheck.checkCompatible(string, System.getProperty("java.version"))) {
                return true;
            }
            String string2 = MessageFormat.format(Messages.getMessages().getString("AppleJavaMinVersionError"), installerConfig.getMinJavaVersion(), installerConfig.getApplicationName());
            Util.showMessage(string2, 0);
            return false;
        }
        return true;
    }

    public static String getVerboseVariableDefinition(String string, Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append("=");
        stringBuffer.append(VersionSpecificHelper.toStringWithArrays(object));
        if (object != null) {
            stringBuffer.append("[");
            stringBuffer.append(object.getClass());
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }

    public static String getAnnotatedStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter((Writer)stringWriter, true));
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        if (installerConfig == null) {
            return stringWriter.toString();
        }
        return InstallerUtil.prependBeanOrigin(stringWriter.toString(), installerConfig.getClassNameToScriptClassOrigin());
    }

    static {
        state = new State();
        HTML_CONTENT_TYPE_PATTERN = Pattern.compile("<html\\s*>.*<meta\\s+http-equiv\\s*=\\s*([\"'])Content-Type\\1\\s+content\\s*=\\s*([\"'])text/html;\\s+charset=(.*?)\\2", 34);
        if (!Boolean.getBoolean("install4j.noLoggingFix")) {
            InstallerUtil.disablePreferencesLogging();
        }
    }

    public static class CommandLineOptions {
        public boolean help = false;
        public boolean quiet = false;
        public boolean console = false;
        public boolean gui = false;
        public File installDir = null;
        public boolean quietOverwrite = false;
        public int wait = 0;
        public String splash = null;
        public Properties commandLineVars = new Properties();
        public String varFileName;
    }

    public static class State
    implements Serializable {
        boolean unattended = false;
        boolean console = false;
        boolean deployLibsLodaded = false;
        String installerType = null;
        String[] commandLineParameters = new String[0];
        String[] extraCommandLineParameters = new String[0];
        boolean inProcess = true;
        boolean shutdownOnInProcessExit;
    }

    private static class StateResponse
    extends Response {
        private State remoteState;

        private StateResponse(State state) {
            this.remoteState = state;
        }
    }
}

