/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend;

import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.LanguageConfig;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.VariableResourceBundleWrapper;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.impl.HelperResourceBundle;
import com.install4j.runtime.util.DefaultPropertyResourceBundle;
import com.install4j.runtime.util.FileResourceBundle;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;

public class Messages {
    private static final String LANGUAGES_MESSAGE_PREFIX = "languages.";
    private static VariableResourceBundleWrapper messages = null;
    private static LanguageConfig languageConfig;

    public static void setLanguageConfig(LanguageConfig languageConfig) {
        if (languageConfig == null) {
            throw new IllegalArgumentException("language config cannot be null");
        }
        Messages.languageConfig = languageConfig;
        messages = null;
        GUIHelper.setLanguage(languageConfig.getId());
    }

    public static VariableResourceBundleWrapper getMessages() {
        if (messages == null) {
            messages = HelperCommunication.getInstance().isElevatedHelper() ? new VariableResourceBundleWrapper(new HelperResourceBundle()) : Messages.createMessages(languageConfig);
        }
        return messages;
    }

    public static void setMessages(ResourceBundle resourceBundle) {
        messages = new VariableResourceBundleWrapper(resourceBundle);
    }

    public static VariableResourceBundleWrapper createMessages(LanguageConfig languageConfig) {
        try {
            return Messages.createMessagesInternal(languageConfig);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            String string = "Internal error: Could not open message file.";
            if (InstallerUtil.isUnattended() || InstallerUtil.isConsole()) {
                System.err.println(string);
            } else {
                JOptionPane.showMessageDialog(null, string, "install4j Setup", 0, null);
            }
            InstallerUtil.exit(1);
            return null;
        }
    }

    private static VariableResourceBundleWrapper createMessagesInternal(LanguageConfig languageConfig) throws IOException {
        ResourceBundle resourceBundle;
        File file = InstallerUtil.getInstallerFile("MessagesDefault");
        ResourceBundle resourceBundle2 = new FileResourceBundle(file, null);
        if (languageConfig == null) {
            resourceBundle = resourceBundle2;
        } else {
            LanguageConfig languageConfig2 = (LanguageConfig)InstallerConfig.getCurrentInstance().getLanguages().get(0);
            resourceBundle2 = Messages.createResourceBundleWithCustomLocalization(languageConfig2, resourceBundle2);
            File file2 = InstallerUtil.getInstallerFile(languageConfig.getMessageFile());
            resourceBundle = file2.exists() ? new FileResourceBundle(file2, resourceBundle2) : resourceBundle2;
            resourceBundle = Messages.createResourceBundleWithCustomLocalization(languageConfig, resourceBundle);
        }
        return new VariableResourceBundleWrapper(resourceBundle);
    }

    private static ResourceBundle createResourceBundleWithCustomLocalization(LanguageConfig languageConfig, ResourceBundle resourceBundle) throws IOException {
        File file;
        String string = languageConfig.getCustomLocalizationFile();
        if (string.trim().length() > 0 && (file = InstallerUtil.getInstallerFile(string)).exists()) {
            resourceBundle = string.toLowerCase().endsWith("properties") ? DefaultPropertyResourceBundle.create(file, resourceBundle) : new FileResourceBundle(file, resourceBundle);
        }
        return resourceBundle;
    }

    public static List sortLanguages(List list, final ResourceBundle resourceBundle) {
        ArrayList arrayList = new ArrayList(list);
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                String string = Messages.getLocalizedLanguageName(object, resourceBundle);
                String string2 = Messages.getLocalizedLanguageName(object2, resourceBundle);
                return string.compareTo(string2);
            }
        });
        return arrayList;
    }

    public static String getLocalizedLanguageName(Object object, ResourceBundle resourceBundle) {
        LanguageConfig languageConfig = (LanguageConfig)object;
        String string = null;
        try {
            string = resourceBundle.getString(LANGUAGES_MESSAGE_PREFIX + languageConfig.getId());
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (string != null) {
            return string;
        }
        return languageConfig.getName();
    }
}

