/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy;

import java.util.Hashtable;
import java.util.Map;
import org.w3c.tidy.AttVal;
import org.w3c.tidy.AttrCheckImpl;
import org.w3c.tidy.AttrId;
import org.w3c.tidy.Attribute;

public class AttributeTable {
    private static AttributeTable defaultAttributeTable;
    private static final Attribute[] ATTRS;
    private Map<String, Attribute> attributeHashtable = new Hashtable<String, Attribute>();

    public Attribute lookup(String name) {
        return this.attributeHashtable.get(name);
    }

    public Attribute install(Attribute attr) {
        return this.attributeHashtable.put(attr.getName(), attr);
    }

    public Attribute findAttribute(AttVal attval) {
        if (attval.attribute != null) {
            Attribute np = this.lookup(attval.attribute);
            return np;
        }
        return null;
    }

    public boolean isUrl(String attrname) {
        Attribute np = this.lookup(attrname);
        return np != null && np.getAttrchk() == AttrCheckImpl.URL;
    }

    public boolean isScript(String attrname) {
        Attribute np = this.lookup(attrname);
        return np != null && np.getAttrchk() == AttrCheckImpl.SCRIPT;
    }

    public static AttributeTable getDefaultAttributeTable() {
        if (defaultAttributeTable == null) {
            defaultAttributeTable = new AttributeTable();
            for (int i = 0; i < ATTRS.length; ++i) {
                defaultAttributeTable.install(ATTRS[i]);
            }
        }
        return defaultAttributeTable;
    }

    static {
        ATTRS = new Attribute[]{new Attribute(AttrId.UNKNOWN, "unknown!", 57344, null), new Attribute(AttrId.ABBR, "abbr", 2044, AttrCheckImpl.PCDATA), new Attribute(AttrId.ACCEPT, "accept", 8191, AttrCheckImpl.XTYPE), new Attribute(AttrId.ACCEPT_CHARSET, "accept-charset", 2044, AttrCheckImpl.CHARSET), new Attribute(AttrId.ACCESSKEY, "accesskey", 2044, AttrCheckImpl.CHARACTER), new Attribute(AttrId.ACTION, "action", 8191, AttrCheckImpl.ACTION), new Attribute(AttrId.ADD_DATE, "add_date", 16384, AttrCheckImpl.PCDATA), new Attribute(AttrId.ALIGN, "align", 8191, AttrCheckImpl.ALIGN), new Attribute(AttrId.ALINK, "alink", 1755, AttrCheckImpl.COLOR), new Attribute(AttrId.ALT, "alt", 8191, AttrCheckImpl.PCDATA), new Attribute(AttrId.ARCHIVE, "archive", 2044, AttrCheckImpl.URLS), new Attribute(AttrId.AXIS, "axis", 2044, AttrCheckImpl.PCDATA), new Attribute(AttrId.BACKGROUND, "background", 1755, AttrCheckImpl.URL), new Attribute(AttrId.BGCOLOR, "bgcolor", 1755, AttrCheckImpl.COLOR), new Attribute(AttrId.BGPROPERTIES, "bgproperties", 57344, AttrCheckImpl.PCDATA), new Attribute(AttrId.BORDER, "border", 8191, AttrCheckImpl.BORDER), new Attribute(AttrId.BORDERCOLOR, "bordercolor", 32768, AttrCheckImpl.COLOR), new Attribute(AttrId.BOTTOMMARGIN, "bottommargin", 32768, AttrCheckImpl.NUMBER), new Attribute(AttrId.CELLPADDING, "cellpadding", 2046, AttrCheckImpl.LENGTH), new Attribute(AttrId.CELLSPACING, "cellspacing", 2046, AttrCheckImpl.LENGTH), new Attribute(AttrId.CHAR, "char", 2044, AttrCheckImpl.CHARACTER), new Attribute(AttrId.CHAROFF, "charoff", 2044, AttrCheckImpl.LENGTH), new Attribute(AttrId.CHARSET, "charset", 2044, AttrCheckImpl.CHARSET), new Attribute(AttrId.CHECKED, "checked", 8191, AttrCheckImpl.BOOL), new Attribute(AttrId.CITE, "cite", 2044, AttrCheckImpl.URL), new Attribute(AttrId.CLASS, "class", 2044, AttrCheckImpl.PCDATA), new Attribute(AttrId.CLASSID, "classid", 2044, AttrCheckImpl.URL), new Attribute(AttrId.CLEAR, "clear", 1755, AttrCheckImpl.CLEAR), new Attribute(AttrId.CODE, "code", 1755, AttrCheckImpl.PCDATA), new Attribute(AttrId.CODEBASE, "codebase", 2044, AttrCheckImpl.URL), new Attribute(AttrId.CODETYPE, "codetype", 2044, AttrCheckImpl.XTYPE), new Attribute(AttrId.COLOR, "color", 1755, AttrCheckImpl.COLOR), new Attribute(AttrId.COLS, "cols", 1752, AttrCheckImpl.COLS), new Attribute(AttrId.COLSPAN, "colspan", 2046, AttrCheckImpl.NUMBER), new Attribute(AttrId.COMPACT, "compact", 8191, AttrCheckImpl.BOOL), new Attribute(AttrId.CONTENT, "content", 8191, AttrCheckImpl.PCDATA), new Attribute(AttrId.COORDS, "coords", 2046, AttrCheckImpl.COORDS), new Attribute(AttrId.DATA, "data", 2044, AttrCheckImpl.URL), new Attribute(AttrId.DATAFLD, "datafld", 32768, AttrCheckImpl.PCDATA), new Attribute(AttrId.DATAFORMATAS, "dataformatas", 32768, AttrCheckImpl.PCDATA), new Attribute(AttrId.DATAPAGESIZE, "datapagesize", 32768, AttrCheckImpl.NUMBER), new Attribute(AttrId.DATASRC, "datasrc", 32768, AttrCheckImpl.URL), new Attribute(AttrId.DATETIME, "datetime", 2044, AttrCheckImpl.DATE), new Attribute(AttrId.DECLARE, "declare", 2044, AttrCheckImpl.BOOL), new Attribute(AttrId.DEFER, "defer", 2044, AttrCheckImpl.BOOL), new Attribute(AttrId.DIR, "dir", 2044, AttrCheckImpl.TEXTDIR), new Attribute(AttrId.DISABLED, "disabled", 2044, AttrCheckImpl.BOOL), new Attribute(AttrId.ENCODING, "encoding", 65536, AttrCheckImpl.PCDATA), new Attribute(AttrId.ENCTYPE, "enctype", 8191, AttrCheckImpl.XTYPE), new Attribute(AttrId.FACE, "face", 1755, AttrCheckImpl.PCDATA), new Attribute(AttrId.FOR, "for", 2044, AttrCheckImpl.IDREF), new Attribute(AttrId.FRAME, "frame", 2044, AttrCheckImpl.TFRAME), new Attribute(AttrId.FRAMEBORDER, "frameborder", 1168, AttrCheckImpl.FBORDER), new Attribute(AttrId.FRAMESPACING, "framespacing", 57344, AttrCheckImpl.NUMBER), new Attribute(AttrId.GRIDX, "gridx", 57344, AttrCheckImpl.NUMBER), new Attribute(AttrId.GRIDY, "gridy", 57344, AttrCheckImpl.NUMBER), new Attribute(AttrId.HEADERS, "headers", 2044, AttrCheckImpl.IDREFS), new Attribute(AttrId.HEIGHT, "height", 8191, AttrCheckImpl.LENGTH), new Attribute(AttrId.HREF, "href", 8191, AttrCheckImpl.URL), new Attribute(AttrId.HREFLANG, "hreflang", 2044, AttrCheckImpl.LANG), new Attribute(AttrId.HSPACE, "hspace", 8191, AttrCheckImpl.NUMBER), new Attribute(AttrId.HTTP_EQUIV, "http-equiv", 8191, AttrCheckImpl.PCDATA), new Attribute(AttrId.ID, "id", 2044, AttrCheckImpl.IDDEF), new Attribute(AttrId.ISMAP, "ismap", 8191, AttrCheckImpl.BOOL), new Attribute(AttrId.LABEL, "label", 2044, AttrCheckImpl.PCDATA), new Attribute(AttrId.LANG, "lang", 2044, AttrCheckImpl.LANG), new Attribute(AttrId.LANGUAGE, "language", 1755, AttrCheckImpl.PCDATA), new Attribute(AttrId.LAST_MODIFIED, "last_modified", 16384, AttrCheckImpl.PCDATA), new Attribute(AttrId.LAST_VISIT, "last_visit", 16384, AttrCheckImpl.PCDATA), new Attribute(AttrId.LEFTMARGIN, "leftmargin", 32768, AttrCheckImpl.NUMBER), new Attribute(AttrId.LINK, "link", 1755, AttrCheckImpl.COLOR), new Attribute(AttrId.LONGDESC, "longdesc", 2044, AttrCheckImpl.URL), new Attribute(AttrId.LOWSRC, "lowsrc", 57344, AttrCheckImpl.URL), new Attribute(AttrId.MARGINHEIGHT, "marginheight", 1752, AttrCheckImpl.NUMBER), new Attribute(AttrId.MARGINWIDTH, "marginwidth", 1752, AttrCheckImpl.NUMBER), new Attribute(AttrId.MAXLENGTH, "maxlength", 8191, AttrCheckImpl.NUMBER), new Attribute(AttrId.MEDIA, "media", 2044, AttrCheckImpl.MEDIA), new Attribute(AttrId.METHOD, "method", 8191, AttrCheckImpl.FSUBMIT), new Attribute(AttrId.MULTIPLE, "multiple", 8191, AttrCheckImpl.BOOL), new Attribute(AttrId.NAME, "name", 8191, AttrCheckImpl.NAME), new Attribute(AttrId.NOHREF, "nohref", 2046, AttrCheckImpl.BOOL), new Attribute(AttrId.NORESIZE, "noresize", 1168, AttrCheckImpl.BOOL), new Attribute(AttrId.NOSHADE, "noshade", 1755, AttrCheckImpl.BOOL), new Attribute(AttrId.NOWRAP, "nowrap", 1755, AttrCheckImpl.BOOL), new Attribute(AttrId.OBJECT, "object", 584, AttrCheckImpl.PCDATA), new Attribute(AttrId.OnAFTERUPDATE, "onafterupdate", 32768, AttrCheckImpl.SCRIPT), new Attribute(AttrId.OnBEFOREUNLOAD, "onbeforeunload", 32768, AttrCheckImpl.SCRIPT), new Attribute(AttrId.OnBEFOREUPDATE, "onbeforeupdate", 32768, AttrCheckImpl.SCRIPT), new Attribute(AttrId.OnBLUR, "onblur", 4092, AttrCheckImpl.SCRIPT), new Attribute(AttrId.OnCHANGE, "onchange", 4092, AttrCheckImpl.SCRIPT), new Attribute(AttrId.OnCLICK, "onclick", 4092, AttrCheckImpl.SCRIPT), new Attribute(AttrId.OnDATAAVAILABLE, "ondataavailable", 32768, AttrCheckImpl.SCRIPT), new Attribute(AttrId.OnDATASETCHANGED, "ondatasetchanged", 32768, AttrCheckImpl.SCRIPT), new Attribute(AttrId.OnDATASETCOMPLETE, "ondatasetcomplete", 32768, AttrCheckImpl.SCRIPT), new Attribute(AttrId.OnDBLCLICK, "ondblclick", 4092, AttrCheckImpl.SCRIPT), new Attribute(AttrId.OnERRORUPDATE, "onerrorupdate", 32768, AttrCheckImpl.SCRIPT), new Attribute(AttrId.OnFOCUS, "onfocus", 4092, AttrCheckImpl.SCRIPT), new Attribute(AttrId.OnKEYDOWN, "onkeydown", 4092, AttrCheckImpl.SCRIPT), new Attribute(AttrId.OnKEYPRESS, "onkeypress", 4092, AttrCheckImpl.SCRIPT), new Attribute(AttrId.OnKEYUP, "onkeyup", 4092, AttrCheckImpl.SCRIPT), new Attribute(AttrId.OnLOAD, "onload", 4092, AttrCheckImpl.SCRIPT), new Attribute(AttrId.OnMOUSEDOWN, "onmousedown", 4092, AttrCheckImpl.SCRIPT), new Attribute(AttrId.OnMOUSEMOVE, "onmousemove", 4092, AttrCheckImpl.SCRIPT), new Attribute(AttrId.OnMOUSEOUT, "onmouseout", 4092, AttrCheckImpl.SCRIPT), new Attribute(AttrId.OnMOUSEOVER, "onmouseover", 4092, AttrCheckImpl.SCRIPT), new Attribute(AttrId.OnMOUSEUP, "onmouseup", 4092, AttrCheckImpl.SCRIPT), new Attribute(AttrId.OnRESET, "onreset", 4092, AttrCheckImpl.SCRIPT), new Attribute(AttrId.OnROWENTER, "onrowenter", 32768, AttrCheckImpl.SCRIPT), new Attribute(AttrId.OnROWEXIT, "onrowexit", 32768, AttrCheckImpl.SCRIPT), new Attribute(AttrId.OnSELECT, "onselect", 4092, AttrCheckImpl.SCRIPT), new Attribute(AttrId.OnSUBMIT, "onsubmit", 4092, AttrCheckImpl.SCRIPT), new Attribute(AttrId.OnUNLOAD, "onunload", 4092, AttrCheckImpl.SCRIPT), new Attribute(AttrId.PROFILE, "profile", 2044, AttrCheckImpl.URL), new Attribute(AttrId.PROMPT, "prompt", 1755, AttrCheckImpl.PCDATA), new Attribute(AttrId.RBSPAN, "rbspan", 2048, AttrCheckImpl.NUMBER), new Attribute(AttrId.READONLY, "readonly", 2044, AttrCheckImpl.BOOL), new Attribute(AttrId.REL, "rel", 8191, AttrCheckImpl.LINKTYPES), new Attribute(AttrId.REV, "rev", 8191, AttrCheckImpl.LINKTYPES), new Attribute(AttrId.RIGHTMARGIN, "rightmargin", 32768, AttrCheckImpl.NUMBER), new Attribute(AttrId.ROWS, "rows", 8191, AttrCheckImpl.NUMBER), new Attribute(AttrId.ROWSPAN, "rowspan", 8191, AttrCheckImpl.NUMBER), new Attribute(AttrId.RULES, "rules", 2044, AttrCheckImpl.TRULES), new Attribute(AttrId.SCHEME, "scheme", 2044, AttrCheckImpl.PCDATA), new Attribute(AttrId.SCOPE, "scope", 2044, AttrCheckImpl.SCOPE), new Attribute(AttrId.SCROLLING, "scrolling", 1752, AttrCheckImpl.SCROLL), new Attribute(AttrId.SELECTED, "selected", 8191, AttrCheckImpl.BOOL), new Attribute(AttrId.SHAPE, "shape", 2046, AttrCheckImpl.SHAPE), new Attribute(AttrId.SHOWGRID, "showgrid", 57344, AttrCheckImpl.BOOL), new Attribute(AttrId.SHOWGRIDX, "showgridx", 57344, AttrCheckImpl.BOOL), new Attribute(AttrId.SHOWGRIDY, "showgridy", 57344, AttrCheckImpl.BOOL), new Attribute(AttrId.SIZE, "size", 1755, AttrCheckImpl.NUMBER), new Attribute(AttrId.SPAN, "span", 2044, AttrCheckImpl.NUMBER), new Attribute(AttrId.SRC, "src", 8191, AttrCheckImpl.URL), new Attribute(AttrId.STANDBY, "standby", 2044, AttrCheckImpl.PCDATA), new Attribute(AttrId.START, "start", 8191, AttrCheckImpl.NUMBER), new Attribute(AttrId.STYLE, "style", 2044, AttrCheckImpl.PCDATA), new Attribute(AttrId.SUMMARY, "summary", 2044, AttrCheckImpl.PCDATA), new Attribute(AttrId.TABINDEX, "tabindex", 2044, AttrCheckImpl.NUMBER), new Attribute(AttrId.TARGET, "target", 2044, AttrCheckImpl.TARGET), new Attribute(AttrId.TEXT, "text", 1755, AttrCheckImpl.COLOR), new Attribute(AttrId.TITLE, "title", 2044, AttrCheckImpl.PCDATA), new Attribute(AttrId.TOPMARGIN, "topmargin", 32768, AttrCheckImpl.NUMBER), new Attribute(AttrId.TYPE, "type", 2046, AttrCheckImpl.TYPE), new Attribute(AttrId.USEMAP, "usemap", 8191, AttrCheckImpl.URL), new Attribute(AttrId.VALIGN, "valign", 2046, AttrCheckImpl.VALIGN), new Attribute(AttrId.VALUE, "value", 8191, AttrCheckImpl.PCDATA), new Attribute(AttrId.VALUETYPE, "valuetype", 2044, AttrCheckImpl.VTYPE), new Attribute(AttrId.VERSION, "version", 73727, AttrCheckImpl.PCDATA), new Attribute(AttrId.VLINK, "vlink", 1755, AttrCheckImpl.COLOR), new Attribute(AttrId.VSPACE, "vspace", 1755, AttrCheckImpl.NUMBER), new Attribute(AttrId.WIDTH, "width", 8191, AttrCheckImpl.LENGTH), new Attribute(AttrId.WRAP, "wrap", 16384, AttrCheckImpl.PCDATA), new Attribute(AttrId.XML_LANG, "xml:lang", 65536, AttrCheckImpl.LANG), new Attribute(AttrId.XML_SPACE, "xml:space", 65536, AttrCheckImpl.PCDATA), new Attribute(AttrId.XMLNS, "xmlns", 8191, AttrCheckImpl.PCDATA), new Attribute(AttrId.EVENT, "event", 2044, AttrCheckImpl.PCDATA), new Attribute(AttrId.METHODS, "methods", 1, AttrCheckImpl.PCDATA), new Attribute(AttrId.N, "n", 1, AttrCheckImpl.PCDATA), new Attribute(AttrId.SDAFORM, "sdaform", 1, AttrCheckImpl.PCDATA), new Attribute(AttrId.SDAPREF, "sdapref", 1, AttrCheckImpl.PCDATA), new Attribute(AttrId.SDASUFF, "sdasuff", 1, AttrCheckImpl.PCDATA), new Attribute(AttrId.URN, "urn", 1, AttrCheckImpl.PCDATA)};
    }
}

