/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.factory;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.apache.naming.EjbRef;

public class EjbFactory
implements ObjectFactory {
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        if (obj instanceof EjbRef) {
            Reference ref = (Reference)obj;
            RefAddr linkRefAddr = ref.get("link");
            if (linkRefAddr != null) {
                String ejbLink = linkRefAddr.getContent().toString();
                Object beanObj = new InitialContext().lookup(ejbLink);
                return beanObj;
            }
            ObjectFactory factory = null;
            RefAddr factoryRefAddr = ref.get("factory");
            if (factoryRefAddr != null) {
                String factoryClassName = factoryRefAddr.getContent().toString();
                ClassLoader tcl = Thread.currentThread().getContextClassLoader();
                Class<?> factoryClass = null;
                if (tcl != null) {
                    try {
                        factoryClass = tcl.loadClass(factoryClassName);
                    }
                    catch (ClassNotFoundException e) {}
                } else {
                    try {
                        factoryClass = Class.forName(factoryClassName);
                    }
                    catch (ClassNotFoundException e) {
                        // empty catch block
                    }
                }
                if (factoryClass != null) {
                    try {
                        factory = (ObjectFactory)factoryClass.newInstance();
                    }
                    catch (Throwable t) {}
                }
            } else {
                String javaxEjbFactoryClassName = System.getProperty("javax.ejb.Factory", "org.apache.naming.factory.OpenEjbFactory");
                try {
                    factory = (ObjectFactory)Class.forName(javaxEjbFactoryClassName).newInstance();
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            if (factory != null) {
                return factory.getObjectInstance(obj, name, nameCtx, environment);
            }
            throw new NamingException("Cannot create resource instance");
        }
        return null;
    }
}

