/*
 * Decompiled with CFR 0.152.
 */
package hermes.swing.actions;

import hermes.browser.HermesBrowser;
import hermes.browser.IconCache;
import hermes.browser.model.BrowserTreeModel;
import hermes.browser.model.tree.HermesTreeNode;
import hermes.swing.actions.ActionSupport;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.tree.TreeNode;

public class DiscoverDestinationsAction
extends ActionSupport {
    public DiscoverDestinationsAction() {
        this.putValue("Name", "Discover...");
        this.putValue("ShortDescription", "Discover queues and topics from the provider");
        this.putValue("SmallIcon", IconCache.getIcon("hermes.discover"));
        this.setEnabled(false);
        if (!HermesBrowser.getBrowser().isRestricted()) {
            this.enableOnBrowserTreeSelection(new Class[]{HermesTreeNode.class}, (Action)this, true);
        }
    }

    public void actionPerformed(ActionEvent e) {
        try {
            TreeNode node;
            if (HermesBrowser.getBrowser().getBrowserTree().getSelectionPath() != null && (node = (TreeNode)HermesBrowser.getBrowser().getBrowserTree().getSelectionPath().getLastPathComponent()) instanceof HermesTreeNode) {
                HermesTreeNode hermesNode = (HermesTreeNode)node;
                HermesBrowser.getBrowser().getActionFactory().createDiscoverDestinationAction((BrowserTreeModel)HermesBrowser.getBrowser().getBrowserTree().getModel(), hermesNode);
            }
        }
        catch (Exception ex) {
            HermesBrowser.getBrowser().showErrorDialog("Discovering: " + ex.getMessage(), ex);
        }
    }
}

