/*
 * Decompiled with CFR 0.152.
 */
package hermes.swing.actions;

import hermes.Hermes;
import hermes.browser.HermesBrowser;
import hermes.browser.IconCache;
import hermes.browser.actions.BrowserAction;
import hermes.browser.actions.MessageStoreBrowserAction;
import hermes.impl.DefaultXMLHelper;
import hermes.impl.XMLHelper;
import hermes.swing.actions.BrowseActionListenerAdapter;
import hermes.util.TextUtils;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class CutMessagesToClipboardAction
extends BrowseActionListenerAdapter {
    private static final Logger log = Logger.getLogger(CutMessagesToClipboardAction.class);
    private XMLHelper xml = new DefaultXMLHelper();

    public CutMessagesToClipboardAction() {
        this.putValue("Name", "Cut");
        this.putValue("ShortDescription", "Cut selected messages to clipboard, delete them from the queue.");
        this.putValue("SmallIcon", IconCache.getIcon("cut"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(65489, 0, false));
        this.setEnabled(false);
    }

    public void actionPerformed(ActionEvent arg0) {
        if (HermesBrowser.getBrowser().getDocumentPane().getActiveDocument() instanceof BrowserAction) {
            try {
                String message;
                BrowserAction browserAction = (BrowserAction)HermesBrowser.getBrowser().getDocumentPane().getActiveDocument();
                String string = message = browserAction.getSelectedMessages().size() == 1 ? "You are about to copy this message to the clipboard and delete it from " : "You are about to copy " + browserAction.getSelectedMessages().size() + " messages to the clipboard and delete them from ";
                if (JOptionPane.showConfirmDialog((Component)((Object)HermesBrowser.getBrowser()), message + browserAction.getDestination() + " - are you sure ?", "Warning", 0) == 0) {
                    Collection<Message> messages = browserAction.getSelectedMessages();
                    Clipboard systemcClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    StringSelection t = new StringSelection(this.xml.toXML(messages));
                    systemcClipboard.setContents(t, null);
                    Hermes.ui.getDefaultMessageSink().add(messages.size() + TextUtils.plural(messages.size()) + " messages copied to clipboard, now deleting.");
                    if (browserAction instanceof MessageStoreBrowserAction) {
                        MessageStoreBrowserAction storeAction = (MessageStoreBrowserAction)browserAction;
                        HermesBrowser.getBrowser().getActionFactory().createDeleteFromMessageStoreAction(storeAction.getMessageStore(), browserAction.getSelectedMessages(), false);
                    } else {
                        HermesBrowser.getBrowser().getActionFactory().createTruncateAction(browserAction.getHermes(), browserAction.getConfig(), browserAction.getSelectedMessageIDs(), false);
                    }
                } else {
                    Hermes.ui.getDefaultMessageSink().add("Cut from " + browserAction.getDestination() + " cancelled");
                }
            }
            catch (HeadlessException e) {
                log.error((Object)("doCopy(): " + e.getMessage()), (Throwable)e);
            }
            catch (JMSException e) {
                HermesBrowser.getBrowser().showErrorDialog("During copy: ", e);
            }
        }
    }
}

