/*
 * Decompiled with CFR 0.152.
 */
package hermes.swing;

import java.awt.Font;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;

public class SwingAppender
extends AppenderSkeleton {
    private static Timer timer = new Timer();
    private FastDateFormat format = FastDateFormat.getInstance((String)"yyyy.MM.dd HH:mm:ss");
    private List cachedRows = new ArrayList();
    private long updateInterval = 500L;
    private TimerTask timerTask;
    private boolean active = false;
    private String filter;
    private JTextArea textArea = new JTextArea();

    public SwingAppender(String filter) {
        this.filter = filter;
        this.textArea.setFont(new Font("Courier", 0, 12));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void append(LoggingEvent event) {
        if (!this.active || !this.checkEntryConditions()) {
            return;
        }
        if (event.categoryName.startsWith(this.filter)) {
            List list = this.cachedRows;
            synchronized (list) {
                this.cachedRows.add(this.format.format(new Date(event.timeStamp)) + " " + event.getLevel() + " [" + event.getThreadName() + "] " + event.categoryName + " " + event.getMessage());
            }
            if (this.timerTask == null) {
                this.timerTask = new TimerTask(){

                    public void run() {
                        SwingAppender.this.updateModel();
                    }
                };
                timer.schedule(this.timerTask, this.updateInterval, this.updateInterval);
            }
        }
    }

    public void updateModel() {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                List list = SwingAppender.this.cachedRows;
                synchronized (list) {
                    while (SwingAppender.this.cachedRows.size() > 0) {
                        SwingAppender.this.textArea.append(SwingAppender.this.cachedRows.remove(0) + "\n");
                    }
                }
            }
        });
    }

    public void close() {
        this.clear();
    }

    public void clear() {
        this.textArea.replaceRange("", 0, this.textArea.getCaretPosition());
    }

    public boolean requiresLayout() {
        return false;
    }

    protected boolean checkEntryConditions() {
        return !this.closed && this.active;
    }

    public long getUpdateInterval() {
        return this.updateInterval;
    }

    public void setUpdateInterval(long updateInterval) {
        this.updateInterval = updateInterval;
    }

    public JComponent getComponent() {
        return this.textArea;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
        if (!this.isActive() && this.timerTask != null) {
            this.timerTask.cancel();
            this.timerTask = null;
        }
    }
}

