/*
 * Decompiled with CFR 0.152.
 */
package hermes.store.schema;

import hermes.store.schema.Statements;

public class DefaultStatements
implements Statements {
    public String[] getCreateDatabaseStatements(int maxMessageSize) {
        return new String[]{"create table storeInfo (storeid varchar (64) not null constraint storeInfo_cid unique )", "create table stores (storeid varchar(64) not null, destination varchar(256) not null, domain integer not null, messageid varchar(256) not null)", "create index stores_didx on stores(destination)", "create index stores_sidx on stores(storeid)", "create index stores_midx on stores(messageid)", "create index stores_smidx on stores(storeid, messageid)", "create table messages (messageid varchar(256) not null, message clob(" + maxMessageSize + ") not null)", "create index messages_midx on messages(messageid)"};
    }

    public String[] getDeleteDatabaseStatements() {
        return new String[]{"drop table stores", "drop table messages", "drop table storeInfo"};
    }

    public String getDepthStatement() {
        return "select count(messageid) from stores where storeId=? and destination=?";
    }

    public String getStoresStatement() {
        return "select distinct(storeid) from storeInfo";
    }

    public String[] getRemoveStoreStatements() {
        return new String[]{"delete from stores where storeId=?", "delete from messages where messageid in (select messageid from stores where storeid=?)", "delete from storeInfo where storeid=?"};
    }
}

