/*
 * Decompiled with CFR 0.152.
 */
package hermes.providers.file;

import hermes.HermesException;
import hermes.providers.file.Commitable;
import hermes.providers.file.FileQueue;
import hermes.providers.file.FileSession;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueSender;
import org.apache.log4j.Logger;

public class FileMessageProducer
implements QueueSender,
Commitable {
    private static final Logger log = Logger.getLogger(FileMessageProducer.class);
    private FileSession session;
    private FileQueue queue;
    private Collection messages = new ArrayList();

    public FileMessageProducer(FileSession session, FileQueue queue) throws JMSException {
        this.session = session;
        this.queue = queue;
    }

    public void close() throws JMSException {
    }

    public int getDeliveryMode() throws JMSException {
        return 1;
    }

    public boolean getDisableMessageID() throws JMSException {
        return false;
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        return false;
    }

    public int getPriority() throws JMSException {
        return 1;
    }

    public long getTimeToLive() throws JMSException {
        return 0L;
    }

    public void setDeliveryMode(int arg0) throws JMSException {
    }

    public void setDisableMessageID(boolean arg0) throws JMSException {
    }

    public void setDisableMessageTimestamp(boolean arg0) throws JMSException {
    }

    public void setPriority(int arg0) throws JMSException {
    }

    public void setTimeToLive(long arg0) throws JMSException {
    }

    public void commit() throws JMSException {
        if (this.messages.size() > 0) {
            try {
                if (this.queue == null) {
                    for (Message m : this.messages) {
                        if (m.getJMSDestination() != null) {
                            if (m.getJMSDestination() instanceof FileQueue) {
                                FileQueue queue = (FileQueue)m.getJMSDestination();
                                ArrayList<Message> messages = new ArrayList<Message>();
                                messages.add(m);
                                queue.addMessages(this.session, messages);
                                continue;
                            }
                            throw new HermesException("destination is not a FileQueue");
                        }
                        throw new HermesException("message has no destination");
                    }
                } else {
                    this.queue.addMessages(this.session, this.messages);
                }
            }
            catch (IOException e) {
                throw new HermesException(e);
            }
        }
    }

    public void rollback() throws JMSException {
        this.messages.clear();
    }

    public Queue getQueue() throws JMSException {
        return this.queue;
    }

    public void send(Message arg0, int arg1, int arg2, long arg3) throws JMSException {
        this.messages.add(arg0);
        if (!this.session.getTransacted()) {
            this.commit();
        }
    }

    public void send(Message arg0) throws JMSException {
        this.messages.add(arg0);
        if (!this.session.getTransacted()) {
            this.commit();
        }
    }

    public void send(Queue arg0, Message arg1, int arg2, int arg3, long arg4) throws JMSException {
        arg1.setJMSDestination((Destination)arg0);
        this.messages.add(arg1);
        if (!this.session.getTransacted()) {
            this.commit();
        }
    }

    public void send(Queue arg0, Message arg1) throws JMSException {
        arg1.setJMSDestination((Destination)arg0);
        this.messages.add(arg1);
        if (!this.session.getTransacted()) {
            this.commit();
        }
    }

    public Destination getDestination() throws JMSException {
        return this.queue;
    }

    public void send(Destination arg0, Message arg1, int arg2, int arg3, long arg4) throws JMSException {
        arg1.setJMSDestination(arg0);
        this.messages.add(arg1);
        if (!this.session.getTransacted()) {
            this.commit();
        }
    }

    public void send(Destination arg0, Message arg1) throws JMSException {
        arg1.setJMSDestination(arg0);
        this.messages.add(arg1);
        if (!this.session.getTransacted()) {
            this.commit();
        }
    }
}

