/*
 * Decompiled with CFR 0.152.
 */
package hermes.providers.file;

import hermes.Domain;
import hermes.HermesException;
import hermes.MessageFactory;
import hermes.providers.file.DummyQueue;
import hermes.providers.file.DummyTopic;
import hermes.providers.messages.MapMessageImpl;
import hermes.providers.messages.MessageImpl;
import hermes.providers.messages.ObjectMessageImpl;
import hermes.providers.messages.TextMessageImpl;
import java.io.Serializable;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.naming.NamingException;

public class FileMessageFactory
implements MessageFactory {
    public BytesMessage createBytesMessage() throws JMSException {
        throw new HermesException("BytesMessage not supported");
    }

    public MapMessage createMapMessage() throws JMSException {
        return new MapMessageImpl();
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        return new ObjectMessageImpl();
    }

    public StreamMessage createStreamMessage() throws JMSException {
        throw new HermesException("StreamMessage not supported");
    }

    public TextMessage createTextMessage() throws JMSException {
        return new TextMessageImpl();
    }

    public TextMessage createTextMessage(String text) throws JMSException {
        return new TextMessageImpl(text);
    }

    public Message createMessage() throws JMSException {
        return new MessageImpl();
    }

    public Queue createQueue(String name) throws JMSException {
        return new DummyQueue(name);
    }

    public Topic createTopic(String topic) throws JMSException {
        return new DummyTopic(topic);
    }

    public Destination getDestination(String name, Domain domain) throws JMSException, NamingException {
        if (domain == Domain.QUEUE) {
            return this.createQueue(name);
        }
        return this.createTopic(name);
    }

    public String getDestinationName(Destination to) throws JMSException {
        if (to instanceof Queue) {
            return ((Queue)to).getQueueName();
        }
        return ((Topic)to).getTopicName();
    }

    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        return new ObjectMessageImpl(object);
    }
}

