/*
 * Decompiled with CFR 0.152.
 */
package hermes.providers.file;

import hermes.providers.file.Commitable;
import hermes.providers.file.FileQueue;
import hermes.providers.file.FileSession;
import java.io.IOException;
import java.util.Iterator;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueReceiver;
import org.apache.log4j.Logger;

public class FileMessageConsumer
implements QueueReceiver,
Commitable {
    private static final Logger log = Logger.getLogger(FileMessageConsumer.class);
    private FileSession session;
    private MessageListener listener;
    private FileQueue queue;
    private String selector;
    private Iterator messages;

    public FileMessageConsumer(FileSession session, FileQueue queue, String selector) throws JMSException, IOException {
        this.session = session;
        this.queue = queue;
        this.selector = selector;
        this.messages = queue.getMessages(session, selector).iterator();
    }

    public void close() throws JMSException {
        log.debug((Object)"close()");
    }

    public MessageListener getMessageListener() throws JMSException {
        return this.listener;
    }

    public String getMessageSelector() throws JMSException {
        return this.selector;
    }

    public Message receive() throws JMSException {
        return (Message)this.messages.next();
    }

    public Message receive(long arg0) throws JMSException {
        if (this.messages.hasNext()) {
            return (Message)this.messages.next();
        }
        try {
            Thread.sleep(arg0);
        }
        catch (InterruptedException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public Message receiveNoWait() throws JMSException {
        if (this.messages.hasNext()) {
            return (Message)this.messages.next();
        }
        return null;
    }

    public void setMessageListener(final MessageListener listener) throws JMSException {
        this.listener = listener;
        Runnable r = new Runnable(){

            public void run() {
                Message m = null;
                try {
                    while ((m = FileMessageConsumer.this.receiveNoWait()) != null) {
                        listener.onMessage(m);
                    }
                }
                catch (JMSException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        };
        this.session.getConnection().doOnStart(r);
    }

    public Queue getQueue() throws JMSException {
        return this.queue;
    }

    public void commit() throws JMSException {
    }

    public void rollback() throws JMSException {
    }
}

