/*
 * Decompiled with CFR 0.152.
 */
package hermes.impl.jms;

import hermes.Domain;
import hermes.HermesException;
import hermes.config.DestinationConfig;
import hermes.config.SessionConfig;
import hermes.impl.ConnectionManager;
import hermes.impl.DestinationManager;
import hermes.impl.jms.AbstractSessionManager;
import hermes.util.JMSUtils;
import java.io.EOFException;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicSession;
import javax.jms.TransactionRolledBackException;
import org.apache.log4j.Logger;

public class ThreadLocalSessionManager
extends AbstractSessionManager {
    private static final Logger log = Logger.getLogger(ThreadLocalSessionManager.class);
    private int sessions = 0;
    private long asyncSessionCloseTimeout = 30000L;
    private ThreadLocal sessionTL = new ThreadLocal();
    private ThreadLocal producerTL = new ThreadLocal();
    private ThreadLocal consumersTL = new ThreadLocal();
    private ThreadLocal consumersWithSelectorTL = new ThreadLocal();
    private Thread dispatchThread;
    private boolean doReconnectConsumers = false;

    public ThreadLocalSessionManager(SessionConfig config, DestinationManager destinationManager) {
        super(destinationManager, config);
    }

    public boolean isOpen() {
        return this.sessionTL.get() != null;
    }

    public synchronized void close() throws JMSException {
        if (this.sessionTL.get() != null) {
            this.closeConsumers((Map)this.consumersTL.get());
            this.closeConsumers((Map)this.consumersWithSelectorTL.get());
            try {
                this.getSession().close();
            }
            catch (JMSException ex) {
                log.info((Object)("closing session:" + ex.getMessage()), (Throwable)ex);
            }
            this.sessionTL.set(null);
            this.consumersTL.set(null);
            this.consumersWithSelectorTL.set(null);
            this.producerTL.set(null);
            --this.sessions;
            if (this.getConnectionManager().getType() == ConnectionManager.Policy.SHARED_CONNECTION) {
                if (this.sessions == 0) {
                    log.debug((Object)"all sessions closed, closing Connection");
                    this.getConnectionManager().close();
                    this.getConnectionFactoryManager().close();
                }
            } else {
                log.debug((Object)"session closed, closing its Connection");
                this.getConnectionManager().close();
                this.getConnectionFactoryManager().close();
            }
        }
    }

    public void reconnect(String username, String password) throws JMSException {
        try {
            this.close();
        }
        catch (JMSException ex) {
            log.warn((Object)("when closing session: " + ex.getMessage()), (Throwable)ex);
        }
        this.getConnectionManager().reconnect(username, password);
    }

    private void reconnect(Map consumers) throws JMSException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void connect() throws JMSException {
        boolean connected = false;
        boolean firstConnect = this.sessionTL.get() == null;
        int attempts = 0;
        TransactionRolledBackException throwThis = null;
        while (!connected) {
            try {
                Connection conn = (Connection)this.parent.getObject();
                Session session = this.createSession();
                this.sessionTL.set(session);
                connected = true;
                if (!this.doReconnectConsumers) continue;
                Map consumers = (Map)this.consumersTL.get();
                Map consumersWithSelector = (Map)this.consumersWithSelectorTL.get();
                this.consumersTL.set(new HashMap());
                if (consumers != null) {
                    this.reconnect(consumers);
                }
                if (consumersWithSelector != null) {
                    this.reconnect(consumersWithSelector);
                }
                if (firstConnect || !session.getTransacted()) continue;
                throwThis = new TransactionRolledBackException("reconnect has forced transaction rollback");
            }
            catch (JMSException ex) {
                ThreadLocalSessionManager threadLocalSessionManager = this;
                synchronized (threadLocalSessionManager) {
                    if (this.getReconnects() == -1 || attempts < this.getReconnects()) {
                        log.error((Object)("connect failed (" + ++attempts + "): " + ex.getMessage()));
                        try {
                            Thread.sleep(this.getReconnectTimeout());
                        }
                        catch (InterruptedException ex2) {
                            log.error((Object)("unexpected: " + ex2.getMessage()), (Throwable)ex);
                        }
                    } else if (ex.getLinkedException() != null && ex.getLinkedException() instanceof EOFException) {
                        try {
                            this.getParent().close();
                        }
                        catch (JMSException ex2) {}
                    } else {
                        throw ex;
                    }
                }
            }
        }
        if (throwThis != null) {
            throw throwThis;
        }
    }

    public void closeConsumers(Map consumers) {
        if (consumers != null) {
            for (Map.Entry entry : consumers.entrySet()) {
                Destination d = (Destination)entry.getKey();
                MessageConsumer consumer = (MessageConsumer)entry.getValue();
                try {
                    log.debug((Object)("closing consumer for " + JMSUtils.getDestinationName(d)));
                    consumer.close();
                }
                catch (JMSException e) {
                    log.error((Object)("closing consumer: " + e.getMessage()), (Throwable)e);
                }
            }
        }
    }

    public void closeConsumer(Destination d, String selector) throws JMSException {
        Map map;
        Map map2 = map = selector == null ? (Map)this.consumersTL.get() : (Map)this.consumersWithSelectorTL.get();
        if (map != null) {
            MessageConsumer consumer = (MessageConsumer)map.remove(d);
            if (consumer != null) {
                log.debug((Object)("closing consumer for " + JMSUtils.getDestinationName(d)));
                consumer.close();
            }
        } else {
            log.debug((Object)("no consumer found to close for " + JMSUtils.getDestinationName(d)));
        }
    }

    public MessageConsumer getConsumer(Destination d) throws JMSException {
        return this.getConsumer(d, null);
    }

    public MessageConsumer getConsumer(Destination d, String selector) throws JMSException {
        MessageConsumer consumer = null;
        Map<Object, Object> map = selector != null ? (HashMap<Destination, MessageConsumer>)this.consumersWithSelectorTL.get() : (Map)this.consumersTL.get();
        if (map == null) {
            map = new HashMap<Destination, MessageConsumer>();
            if (selector != null) {
                this.consumersWithSelectorTL.set(map);
            } else {
                this.consumersTL.set(map);
            }
        }
        if (map.containsKey(d)) {
            consumer = (MessageConsumer)map.get(d);
        } else {
            DestinationConfig dConfig = this.getDestinationConfig(d);
            Domain domain = dConfig != null ? Domain.getDomain(dConfig.getDomain()) : Domain.getDomain(d);
            if (domain == Domain.QUEUE) {
                try {
                    consumer = selector == null ? this.getSession().createConsumer(d) : this.getSession().createConsumer(d, selector, true);
                }
                catch (NoSuchMethodError ex) {
                    log.debug((Object)"JMS 1.1 interface failed, trying 1.0.2b");
                }
                catch (AbstractMethodError ex) {
                    log.debug((Object)"JMS 1.1 interface failed, trying 1.0.2b");
                }
                catch (JMSException t) {
                    if (d.getClass().getName().equals("com.ibm.mq.jms.MQQueue")) {
                        log.debug((Object)"createConsumer() failed with WMQ via JMS 1.1 call, falling back to 1.0.2b call");
                    }
                    throw t;
                }
                if (consumer == null) {
                    consumer = selector == null ? ((QueueSession)this.getSession()).createReceiver((Queue)d) : ((QueueSession)this.getSession()).createReceiver((Queue)d, selector);
                }
            } else if (dConfig != null && dConfig.isDurable()) {
                try {
                    consumer = selector == null ? this.getSession().createDurableSubscriber((Topic)d, dConfig.getClientID()) : this.getSession().createDurableSubscriber((Topic)d, dConfig.getClientID(), selector, true);
                }
                catch (NoSuchMethodError ex) {
                    log.debug((Object)"JMS 1.1 interface failed, trying 1.0.2b");
                }
                catch (AbstractMethodError ex) {
                    log.debug((Object)"JMS 1.1 interface failed, trying 1.0.2b");
                }
                if (consumer == null) {
                    consumer = selector == null ? ((TopicSession)this.getSession()).createDurableSubscriber((Topic)d, dConfig.getClientID()) : ((TopicSession)this.getSession()).createDurableSubscriber((Topic)d, dConfig.getClientID(), selector, true);
                }
            } else {
                try {
                    consumer = selector == null ? this.getSession().createConsumer(d) : this.getSession().createConsumer(d, selector, true);
                }
                catch (NoSuchMethodError ex) {
                    log.debug((Object)"JMS 1.1 interface failed, trying 1.0.2b");
                }
                catch (AbstractMethodError ex) {
                    log.debug((Object)"JMS 1.1 interface failed, trying 1.0.2b");
                }
                if (consumer == null) {
                    consumer = selector == null ? ((TopicSession)this.getSession()).createSubscriber((Topic)d) : ((TopicSession)this.getSession()).createSubscriber((Topic)d, selector, true);
                }
            }
            map.put(d, consumer);
        }
        return consumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageProducer getProducer() throws JMSException {
        MessageProducer producer = (MessageProducer)this.producerTL.get();
        if (producer == null) {
            try {
                if (this.getSession().getClass().getName().equals("com.wm.broker.jms.QueueSession")) {
                    log.debug((Object)"WebMethods session creation hack is active");
                } else {
                    producer = this.getSession().createProducer(null);
                    log.debug((Object)"producer created using JMS 1.1 interface");
                }
            }
            catch (NoSuchMethodError ex) {
            }
            catch (AbstractMethodError ex) {
            }
            finally {
                try {
                    if (producer == null) {
                        producer = this.createQueueProducer();
                    }
                }
                catch (Throwable t) {
                    log.debug((Object)("cannot create a QueueSender: " + t.getMessage()), t);
                    log.debug((Object)"trying a TopicPublisher");
                    producer = this.createTopicProducer();
                }
                this.producerTL.set(producer);
            }
        }
        return producer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Session getSession() throws JMSException {
        Session rval = (Session)this.sessionTL.get();
        if (rval == null) {
            this.connect();
            ThreadLocalSessionManager threadLocalSessionManager = this;
            synchronized (threadLocalSessionManager) {
                ++this.sessions;
            }
            rval = (Session)this.sessionTL.get();
        }
        return rval;
    }

    public void unsubscribe(String name) throws JMSException {
        try {
            try {
                this.getSession().unsubscribe(name);
            }
            catch (NoSuchMethodError ex) {
                ((TopicSession)this.getSession()).unsubscribe(name);
            }
            catch (AbstractMethodError ex) {
                ((TopicSession)this.getSession()).unsubscribe(name);
            }
        }
        catch (Throwable ex) {
            log.error((Object)ex.getMessage(), ex);
            throw new HermesException("Session " + this.getId() + " cannot unsubscribe: " + ex.getMessage());
        }
    }
}

