/*
 * Decompiled with CFR 0.152.
 */
package hermes.impl.jms;

import hermes.Domain;
import hermes.Hermes;
import hermes.HermesException;
import hermes.JNDIQueueConnectionFactory;
import hermes.browser.HermesBrowser;
import hermes.config.DestinationConfig;
import hermes.config.FactoryConfig;
import hermes.config.SessionConfig;
import hermes.impl.ConnectionFactoryManagerImpl;
import hermes.impl.ConnectionManager;
import hermes.impl.DestinationManager;
import hermes.impl.JMSManagerImpl;
import hermes.impl.LoaderSupport;
import hermes.impl.SessionManager;
import hermes.impl.TopicBrowser;
import hermes.util.JMSUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public abstract class AbstractSessionManager
extends JMSManagerImpl
implements SessionManager {
    private static final Logger log = Logger.getLogger(AbstractSessionManager.class);
    private FactoryConfig factoryConfig;
    private boolean transacted = true;
    private String id;
    private int reconnects = -1;
    private long reconnectTimeout = 30000L;
    private boolean audit = false;
    private String auditDirectory = ".";
    private ConnectionFactoryManagerImpl myCFManager;
    private int acknowledgeMode = 2;
    private DestinationManager destinationManager;
    private Map destinationToConfigMap = new HashMap();
    private SessionConfig config;

    public AbstractSessionManager(DestinationManager destinationManager, SessionConfig config) {
        this.destinationManager = destinationManager;
        this.config = config;
    }

    public SessionConfig getConfig() {
        return this.config;
    }

    public abstract Session getSession() throws JMSException;

    public abstract MessageConsumer getConsumer(Destination var1) throws JMSException;

    public abstract MessageConsumer getConsumer(Destination var1, String var2) throws JMSException;

    protected Session createSession() throws JMSException {
        try {
            return this.doCreateSession();
        }
        catch (IllegalStateException ex) {
            try {
                this.close();
            }
            catch (JMSException e) {
                log.error((Object)("closing session: " + e.getMessage()), (Throwable)e);
            }
            try {
                this.getConnectionManager().close();
            }
            catch (JMSException e) {
                log.error((Object)("closing connection: " + e.getMessage()), (Throwable)e);
            }
            return this.doCreateSession();
        }
    }

    private Session doCreateSession() throws JMSException {
        Object session = null;
        Connection conn = (Connection)this.parent.getObject();
        try {
            JNDIQueueConnectionFactory jndiCF;
            ConnectionFactory connectionFactory = this.getConnectionFactoryManager().getConnectionFactory();
            boolean isWebMethodsHack = false;
            if (connectionFactory instanceof JNDIQueueConnectionFactory && (jndiCF = (JNDIQueueConnectionFactory)connectionFactory).getInitialContextFactory() != null && jndiCF.getInitialContextFactory().equals("hermes.ext.wme.WMEInitialContextFactory")) {
                isWebMethodsHack = true;
            }
            if (!isWebMethodsHack) {
                session = conn.createSession(this.isTransacted(), this.getAcknowledgeMode());
                log.debug((Object)"session created using JMS 1.1 interface");
            }
        }
        catch (NoSuchMethodError ex) {
        }
        catch (AbstractMethodError abstractMethodError) {
            // empty catch block
        }
        if (session == null) {
            session = JMSUtils.isQueue(conn) ? ((QueueConnection)conn).createQueueSession(this.isTransacted(), this.getAcknowledgeMode()) : ((TopicConnection)conn).createTopicSession(this.isTransacted(), this.getAcknowledgeMode());
            log.debug((Object)"session created using JMS 1.0.2b interface");
        }
        return session;
    }

    public int getAcknowledgeMode() {
        log.debug((Object)("acknowledgeMode = " + (this.isTransacted() ? "Session.CLIENT_ACKNOWLEDGE" : "Session.AUTO_ACKNOWLEDGE")));
        return this.isTransacted() ? 2 : 1;
    }

    public String getId() {
        return this.id;
    }

    public Object getObject() throws JMSException {
        return this.getSession();
    }

    public void setTransacted(boolean transacted) {
        this.transacted = transacted;
    }

    public boolean isTransacted() {
        return this.transacted;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setParent(JMSManagerImpl parent) {
        super.setParent(parent);
    }

    public void setReconnects(int reconnects) {
        this.reconnects = reconnects;
    }

    public void setReconnectTimeout(Long reconnectTimeout) {
        this.reconnectTimeout = reconnectTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionFactoryManagerImpl getConnectionFactoryManager() {
        if (this.myCFManager == null) {
            AbstractSessionManager abstractSessionManager = this;
            synchronized (abstractSessionManager) {
                if (this.myCFManager == null && this.parent != null) {
                    this.myCFManager = (ConnectionFactoryManagerImpl)this.parent.getParent();
                }
            }
        }
        return this.myCFManager;
    }

    public boolean isAudit() {
        return this.audit;
    }

    public String getAuditDirectory() {
        return this.auditDirectory;
    }

    public void setAudit(boolean b) {
        this.audit = b;
    }

    public void setAuditDirectory(String string) {
        this.auditDirectory = string;
    }

    public long getReconnectTimeout() {
        return this.reconnectTimeout;
    }

    public void setReconnectTimeout(long reconnectTimeout) {
        this.reconnectTimeout = reconnectTimeout;
    }

    public int getReconnects() {
        return this.reconnects;
    }

    public void setFactoryConfig(FactoryConfig factoryConfig) {
        this.factoryConfig = factoryConfig;
    }

    public FactoryConfig getFactoryConfig() {
        return this.factoryConfig;
    }

    public ConnectionFactory getConnectionFactory() throws JMSException {
        return this.getConnectionFactoryManager().getConnectionFactory();
    }

    public Connection getConnection() throws JMSException {
        return (Connection)this.parent.getObject();
    }

    public QueueBrowser createBrowser(Hermes hermes, DestinationConfig config) throws JMSException {
        if (config.getDomain().intValue() == Domain.QUEUE.getId()) {
            Queue queue = (Queue)this.destinationManager.getDestination(this.getSession(), config.getName(), Domain.QUEUE);
            try {
                if (config.getSelector() != null) {
                    return this.getSession().createBrowser(queue, config.getSelector());
                }
                return this.getSession().createBrowser(queue);
            }
            catch (NoSuchMethodError ex) {
            }
            catch (AbstractMethodError ex) {
                // empty catch block
            }
            if (!(this.getSession() instanceof QueueSession)) {
                throw new HermesException("Session is 1.0.2 and not in the queue domain");
            }
            if (config.getSelector() != null) {
                return ((QueueSession)this.getSession()).createBrowser(queue, config.getSelector());
            }
            return ((QueueSession)this.getSession()).createBrowser(queue);
        }
        if (config.getDomain().intValue() == Domain.TOPIC.getId()) {
            return new TopicBrowser(hermes.getSession(), this.destinationManager, config);
        }
        throw new HermesException("The domain for " + config.getName() + " is not defined, configure it as a queue or a topic");
    }

    public QueueBrowser createBrowser(Hermes hermes, Destination destination, String selector) throws JMSException {
        DestinationConfig dConfig = HermesBrowser.getConfigDAO().duplicate(this.getDestinationConfig(destination));
        if (dConfig.getSelector() == null) {
            dConfig.setSelector(selector);
        }
        return this.createBrowser(hermes, dConfig);
    }

    public Collection getDestinations() {
        return this.getConnectionFactoryManager().getDestinationConfigs();
    }

    public DestinationConfig getDestinationConfig(String d, Domain domain) throws JMSException {
        return this.getConnectionFactoryManager().getDestinationConfig(d, domain);
    }

    public Destination getDestination(String named, Domain domain) throws JMSException, NamingException {
        Destination rval = this.destinationManager.getDestination(this.getSession(), named, domain);
        DestinationConfig config = this.getDestinationConfig(named, domain);
        if (config != null) {
            this.destinationToConfigMap.put(rval, this.getDestinationConfig(named, domain));
            if (config.getProperties() != null) {
                try {
                    LoaderSupport.populateBean(rval, config.getProperties());
                }
                catch (Exception ex) {
                    throw new HermesException(ex);
                }
            }
        }
        return rval;
    }

    public DestinationConfig getDestinationConfig(Destination d) {
        return (DestinationConfig)this.destinationToConfigMap.get(d);
    }

    public ConnectionManager getConnectionManager() throws JMSException {
        return (ConnectionManager)this.parent;
    }

    protected MessageProducer createQueueProducer() throws JMSException {
        return ((QueueSession)this.getSession()).createSender(null);
    }

    protected MessageProducer createTopicProducer() throws JMSException {
        return ((TopicSession)this.getSession()).createPublisher(null);
    }

    public DestinationManager getDestinationManager() {
        return this.destinationManager;
    }

    public String toString() {
        return this.getConnectionFactoryManager() == null ? super.toString() : this.getConnectionFactoryManager().toString();
    }
}

