/*
 * Decompiled with CFR 0.152.
 */
package hermes.impl;

import hermes.util.MessageUtils;
import java.util.Enumeration;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.TextMessage;
import org.apache.log4j.Logger;

public class StringSearchQueueBrowser
implements QueueBrowser {
    private static final Logger log = Logger.getLogger(StringSearchQueueBrowser.class);
    private boolean searchJMSHeader;
    private boolean searchUserHeader;
    private QueueBrowser browser;
    private String string;

    public StringSearchQueueBrowser(QueueBrowser browser, String string, boolean searchJMSHeader, boolean searchUserHeader) {
        this.browser = browser;
        this.searchJMSHeader = searchJMSHeader;
        this.searchUserHeader = searchUserHeader;
        this.string = string;
    }

    public Queue getQueue() throws JMSException {
        return this.browser.getQueue();
    }

    public String getMessageSelector() throws JMSException {
        return this.browser.getMessageSelector();
    }

    public Enumeration getEnumeration() throws JMSException {
        return new StringSearchEnumeration(this.browser.getEnumeration());
    }

    public void close() throws JMSException {
        this.browser.close();
    }

    public boolean matches(Message message) {
        try {
            block23: {
                String toString;
                if (this.searchJMSHeader) {
                    // empty if block
                }
                if (this.searchUserHeader) {
                    Enumeration headerNames = message.getPropertyNames();
                    while (headerNames.hasMoreElements()) {
                        try {
                            String key = (String)headerNames.nextElement();
                            Object value = message.getObjectProperty(key);
                            if (key != null && key.indexOf(this.string) != -1) {
                                return true;
                            }
                            if (value == null || value.toString().indexOf(this.string) == -1) continue;
                            return true;
                        }
                        catch (JMSException ex) {
                            log.error((Object)ex.getMessage(), (Throwable)ex);
                        }
                    }
                }
                if (message instanceof TextMessage) {
                    try {
                        return ((TextMessage)message).getText().indexOf(this.string) != -1;
                    }
                    catch (JMSException ex) {
                        log.error((Object)ex.getMessage(), (Throwable)ex);
                        break block23;
                    }
                }
                if (message instanceof MapMessage) {
                    try {
                        MapMessage map = (MapMessage)message;
                        Enumeration mapNames = map.getMapNames();
                        while (mapNames.hasMoreElements()) {
                            String key = (String)mapNames.nextElement();
                            Object value = map.getObject(key);
                            if (key.indexOf(this.string) != -1) {
                                return true;
                            }
                            if (value == null || value.toString().indexOf(this.string) == -1) continue;
                            return true;
                        }
                    }
                    catch (JMSException ex) {
                        log.error((Object)ex.getMessage(), (Throwable)ex);
                    }
                } else if (message instanceof ObjectMessage) {
                    try {
                        ObjectMessage om = (ObjectMessage)message;
                        toString = om.getObject().toString();
                        if (toString.indexOf(this.string) != -1) {
                            return true;
                        }
                    }
                    catch (Throwable t) {
                        log.error((Object)t.getMessage(), t);
                    }
                } else if (message instanceof BytesMessage) {
                    BytesMessage bm = (BytesMessage)message;
                    toString = new String(MessageUtils.asBytes(bm));
                    return toString.indexOf(this.string) != -1;
                }
            }
            return false;
        }
        catch (JMSException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    class StringSearchEnumeration
    implements Enumeration {
        private Enumeration iter;

        StringSearchEnumeration(Enumeration iter) {
            this.iter = iter;
        }

        public boolean hasMoreElements() {
            return this.iter.hasMoreElements();
        }

        public Object nextElement() {
            while (this.iter.hasMoreElements()) {
                Message m = (Message)this.iter.nextElement();
                if (m != null) {
                    if (!StringSearchQueueBrowser.this.matches(m)) continue;
                    return m;
                }
                return null;
            }
            return null;
        }
    }
}

