/*
 * Decompiled with CFR 0.152.
 */
package hermes.impl;

import hermes.Domain;
import hermes.HermesException;
import hermes.MessageFactory;
import hermes.browser.HermesBrowser;
import hermes.impl.XMLHelper;
import hermes.util.JMSUtils;
import hermes.xml.Entry;
import hermes.xml.MessageSet;
import hermes.xml.ObjectFactory;
import hermes.xml.Property;
import hermes.xml.XMLBytesMessage;
import hermes.xml.XMLMapMessage;
import hermes.xml.XMLMessage;
import hermes.xml.XMLObjectMessage;
import hermes.xml.XMLTextMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageEOFException;
import javax.jms.ObjectMessage;
import javax.jms.TextMessage;
import javax.naming.NamingException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Category;
import org.apache.log4j.Logger;
import org.apache.tools.ant.util.ReaderInputStream;

public class DefaultXMLHelper
implements XMLHelper {
    private static final Category log = Logger.getLogger(DefaultXMLHelper.class);
    private static final int XML_TEXT_MESSAGE = 1;
    private static final int XML_BYTES_MESSGAE = 2;
    private static final int XML_OBJECT_MESSAGE = 3;
    private static final int XML_MAP_MESSAGE = 4;
    private static final String BASE64_CODEC = "Base64";
    private final ThreadLocal base64EncoderTL = new ThreadLocal();
    private ObjectFactory factory = new ObjectFactory();

    public boolean isBase64EncodeTextMessages() {
        if (HermesBrowser.getBrowser() != null) {
            try {
                return HermesBrowser.getBrowser().getConfig().isBase64EncodeMessages();
            }
            catch (HermesException ex) {
                log.error((Object)ex.getMessage(), (Throwable)((Object)ex));
                return false;
            }
        }
        return Boolean.parseBoolean(System.getProperty("hermes.base64EncodeTextMessage", "false"));
    }

    public ObjectFactory getFactory() {
        return this.factory;
    }

    public Base64 getBase64() {
        if (this.base64EncoderTL.get() == null) {
            this.base64EncoderTL.set(new Base64());
        }
        return (Base64)this.base64EncoderTL.get();
    }

    public MessageSet readContent(InputStream istream) throws Exception {
        JAXBContext jc = JAXBContext.newInstance((String)"hermes.xml");
        Unmarshaller u = jc.createUnmarshaller();
        JAXBElement node = u.unmarshal((Source)new StreamSource(istream), MessageSet.class);
        return (MessageSet)node.getValue();
    }

    public MessageSet readContent(Reader reader) throws Exception {
        JAXBContext jc = JAXBContext.newInstance((String)"hermes.xml");
        Unmarshaller u = jc.createUnmarshaller();
        JAXBElement node = u.unmarshal((Source)new StreamSource((InputStream)new ReaderInputStream(reader)), MessageSet.class);
        return (MessageSet)node.getValue();
    }

    public void saveContent(MessageSet messages, OutputStream ostream) throws Exception {
        JAXBContext jc = JAXBContext.newInstance((String)"hermes.xml");
        Marshaller m = jc.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        m.marshal((Object)new JAXBElement(new QName("", "content"), MessageSet.class, (Object)messages), ostream);
        ostream.flush();
    }

    public void saveContent(MessageSet messages, Writer writer) throws Exception {
        JAXBContext jc = JAXBContext.newInstance((String)"hermes.xml");
        Marshaller m = jc.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        m.marshal((Object)new JAXBElement(new QName("", "content"), MessageSet.class, (Object)messages), writer);
        writer.flush();
    }

    public void toXML(Message message, OutputStream ostream) throws JMSException, IOException {
        HashSet<Message> c = new HashSet<Message>();
        c.add(message);
        this.toXML(c, ostream);
    }

    public String toXML(Message message) throws JMSException {
        HashSet<Message> c = new HashSet<Message>();
        c.add(message);
        return this.toXML(c);
    }

    public Collection fromXML(MessageFactory hermes, InputStream istream) throws JMSException {
        try {
            return this.fromMessageSet(hermes, this.readContent(istream));
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
            throw new HermesException(ex);
        }
    }

    public Collection fromXML(MessageFactory hermes, String document) throws JMSException {
        try {
            return this.fromMessageSet(hermes, this.readContent(new StringReader(document)));
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
            throw new HermesException(ex);
        }
    }

    public void toXML(Collection messages, OutputStream ostream) throws JMSException, IOException {
        try {
            MessageSet messageSet = this.toMessageSet(messages);
            this.saveContent(messageSet, ostream);
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
            throw new HermesException(ex);
        }
    }

    public String toXML(Collection messages) throws JMSException {
        try {
            StringWriter writer = new StringWriter();
            MessageSet messageSet = this.toMessageSet(messages);
            this.saveContent(messageSet, writer);
            return writer.getBuffer().toString();
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
            throw new HermesException(ex);
        }
    }

    public Collection fromMessageSet(MessageFactory hermes, MessageSet messageSet) throws JMSException, IOException, ClassNotFoundException, DecoderException {
        ArrayList<Message> rval = new ArrayList<Message>();
        for (Entry entry : messageSet.getEntry()) {
            Message jmsMessage = null;
            switch (entry.getType()) {
                case 1: {
                    jmsMessage = this.createMessage(hermes, entry.getTextMessage());
                    break;
                }
                case 4: {
                    jmsMessage = this.createMessage(hermes, entry.getMapMessage());
                    break;
                }
                case 2: {
                    jmsMessage = this.createMessage(hermes, entry.getBytesMessage());
                    break;
                }
                case 3: {
                    jmsMessage = this.createMessage(hermes, entry.getObjectMessage());
                }
            }
            if (jmsMessage == null) continue;
            rval.add(jmsMessage);
        }
        return rval;
    }

    public MessageSet toMessageSet(Collection messages) throws JMSException {
        try {
            MessageSet messageSet = this.factory.createMessageSet();
            for (Message jmsMessage : messages) {
                Entry entry = this.factory.createEntry();
                XMLMessage xmlMessage = this.createXMLMessage(this.factory, jmsMessage);
                if (xmlMessage instanceof XMLTextMessage) {
                    entry.setType(1);
                    entry.setTextMessage((XMLTextMessage)xmlMessage);
                } else if (xmlMessage instanceof XMLMapMessage) {
                    entry.setType(4);
                    entry.setMapMessage((XMLMapMessage)xmlMessage);
                } else if (xmlMessage instanceof XMLObjectMessage) {
                    entry.setType(3);
                    entry.setObjectMessage((XMLObjectMessage)xmlMessage);
                } else if (xmlMessage instanceof XMLBytesMessage) {
                    entry.setType(2);
                    entry.setBytesMessage((XMLBytesMessage)xmlMessage);
                }
                messageSet.getEntry().add(entry);
            }
            return messageSet;
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
            throw new HermesException(ex);
        }
    }

    public Message createMessage(MessageFactory hermes, XMLMessage message) throws JMSException, IOException, ClassNotFoundException, DecoderException {
        try {
            Message rval = hermes.createMessage();
            if (message instanceof XMLTextMessage) {
                rval = hermes.createTextMessage();
                XMLTextMessage textMessage = (XMLTextMessage)message;
                TextMessage textRval = (TextMessage)rval;
                if (BASE64_CODEC.equals(textMessage.getCodec())) {
                    byte[] bytes = this.getBase64().decode(textMessage.getText().getBytes());
                    textRval.setText(new String(bytes, "ASCII"));
                } else {
                    textRval.setText(textMessage.getText());
                }
            } else if (message instanceof XMLMapMessage) {
                rval = hermes.createMapMessage();
                XMLMapMessage mapMessage = (XMLMapMessage)message;
                MapMessage mapRval = (MapMessage)rval;
                for (Property property : mapMessage.getBodyProperty()) {
                    if (property.getValue() == null) {
                        mapRval.setObject(property.getName(), null);
                        continue;
                    }
                    if (property.getType().equals(String.class.getName())) {
                        mapRval.setString(property.getName(), property.getValue());
                        continue;
                    }
                    if (property.getType().equals(Long.class.getName())) {
                        mapRval.setLong(property.getName(), Long.parseLong(property.getValue()));
                        continue;
                    }
                    if (property.getType().equals(Double.class.getName())) {
                        mapRval.setDouble(property.getName(), Double.parseDouble(property.getValue()));
                        continue;
                    }
                    if (property.getType().equals(Boolean.class.getName())) {
                        mapRval.setBoolean(property.getName(), Boolean.getBoolean(property.getValue()));
                        continue;
                    }
                    if (property.getType().equals(Short.class.getName())) {
                        mapRval.setShort(property.getName(), Short.parseShort(property.getValue()));
                        continue;
                    }
                    if (!property.getType().equals(Integer.class.getName())) continue;
                    mapRval.setInt(property.getName(), Integer.parseInt(property.getValue()));
                }
            } else if (message instanceof XMLBytesMessage) {
                rval = hermes.createBytesMessage();
                XMLBytesMessage bytesMessage = (XMLBytesMessage)message;
                BytesMessage bytesRval = (BytesMessage)rval;
                bytesRval.writeBytes(this.getBase64().decode(bytesMessage.getBytes().getBytes()));
            } else if (message instanceof XMLObjectMessage) {
                rval = hermes.createObjectMessage();
                XMLObjectMessage objectMessage = (XMLObjectMessage)message;
                ObjectMessage objectRval = (ObjectMessage)rval;
                ByteArrayInputStream bistream = new ByteArrayInputStream(this.getBase64().decode(objectMessage.getObject().getBytes()));
                ObjectInputStream oistream = new ObjectInputStream(bistream);
                objectRval.setObject((Serializable)oistream.readObject());
            }
            try {
                rval.setJMSDeliveryMode(message.getJMSDeliveryMode().intValue());
            }
            catch (JMSException ex) {
                log.error((Object)("unable to set JMSDeliveryMode to " + message.getJMSDeliveryMode() + ": " + ex.getMessage()));
            }
            try {
                rval.setJMSMessageID(message.getJMSMessageID());
            }
            catch (JMSException ex) {
                log.error((Object)("unable to set JMSMessageID: " + ex.getMessage()), (Throwable)ex);
            }
            try {
                rval.setJMSExpiration(message.getJMSExpiration().longValue());
            }
            catch (JMSException ex) {
                log.error((Object)("unable to set JMSExpiration: " + ex.getMessage()), (Throwable)ex);
            }
            try {
                rval.setJMSPriority(message.getJMSPriority().intValue());
            }
            catch (JMSException ex) {
                log.error((Object)("unable to set JMSPriority: " + ex.getMessage()), (Throwable)ex);
            }
            try {
                rval.setJMSTimestamp(message.getJMSTimestamp().longValue());
            }
            catch (JMSException ex) {
                log.error((Object)("unable to set JMSTimestamp:" + ex.getMessage()), (Throwable)ex);
            }
            if (message.getJMSCorrelationID() != null) {
                rval.setJMSCorrelationID(message.getJMSCorrelationID());
            }
            if (message.getJMSReplyTo() != null && !message.getJMSReplyTo().equals("null")) {
                rval.setJMSReplyTo(hermes.getDestination(message.getJMSReplyTo(), Domain.getDomain(message.getJMSReplyToDomain())));
            }
            if (message.getJMSType() != null) {
                rval.setJMSType(message.getJMSType());
            }
            if (message.getJMSDestination() != null) {
                if (message.isFromQueue()) {
                    rval.setJMSDestination(hermes.getDestination(message.getJMSDestination(), Domain.QUEUE));
                } else {
                    rval.setJMSDestination(hermes.getDestination(message.getJMSDestination(), Domain.TOPIC));
                }
            }
            for (Property property : message.getHeaderProperty()) {
                if (property.getValue() == null) {
                    rval.setObjectProperty(property.getName(), null);
                    continue;
                }
                if (property.getType().equals(String.class.getName())) {
                    rval.setStringProperty(property.getName(), property.getValue());
                    continue;
                }
                if (property.getType().equals(Long.class.getName())) {
                    rval.setLongProperty(property.getName(), Long.parseLong(property.getValue()));
                    continue;
                }
                if (property.getType().equals(Double.class.getName())) {
                    rval.setDoubleProperty(property.getName(), Double.parseDouble(property.getValue()));
                    continue;
                }
                if (property.getType().equals(Boolean.class.getName())) {
                    rval.setBooleanProperty(property.getName(), Boolean.parseBoolean(property.getValue()));
                    continue;
                }
                if (property.getType().equals(Short.class.getName())) {
                    rval.setShortProperty(property.getName(), Short.parseShort(property.getValue()));
                    continue;
                }
                if (!property.getType().equals(Integer.class.getName())) continue;
                rval.setIntProperty(property.getName(), Integer.parseInt(property.getValue()));
            }
            return rval;
        }
        catch (NamingException e) {
            throw new HermesException(e);
        }
    }

    public XMLMessage createXMLMessage(ObjectFactory factory, Message message) throws JMSException, IOException, EncoderException {
        try {
            XMLMessage rval = factory.createXMLMessage();
            if (message instanceof TextMessage) {
                rval = factory.createXMLTextMessage();
                XMLTextMessage textRval = (XMLTextMessage)rval;
                TextMessage textMessage = (TextMessage)message;
                if (this.isBase64EncodeTextMessages()) {
                    byte[] bytes = this.getBase64().encode(textMessage.getText().getBytes());
                    textRval.setText(new String(bytes, "ASCII"));
                    textRval.setCodec(BASE64_CODEC);
                } else {
                    textRval.setText(textMessage.getText());
                }
            } else if (message instanceof MapMessage) {
                rval = factory.createXMLMapMessage();
                XMLMapMessage mapRval = (XMLMapMessage)rval;
                MapMessage mapMessage = (MapMessage)message;
                Enumeration iter = mapMessage.getMapNames();
                while (iter.hasMoreElements()) {
                    String propertyName = (String)iter.nextElement();
                    Object propertyValue = mapMessage.getObject(propertyName);
                    Property xmlProperty = factory.createProperty();
                    if (propertyValue != null) {
                        xmlProperty.setValue(propertyValue.toString());
                        xmlProperty.setType(propertyValue.getClass().getName());
                    }
                    xmlProperty.setName(propertyName);
                    mapRval.getBodyProperty().add(xmlProperty);
                }
            } else if (message instanceof BytesMessage) {
                rval = factory.createXMLBytesMessage();
                XMLBytesMessage bytesRval = (XMLBytesMessage)rval;
                BytesMessage bytesMessage = (BytesMessage)message;
                ByteArrayOutputStream bosream = new ByteArrayOutputStream();
                bytesMessage.reset();
                try {
                    while (true) {
                        bosream.write(bytesMessage.readByte());
                    }
                }
                catch (MessageEOFException ex) {
                    bytesRval.setBytes(new String(this.getBase64().encode(bosream.toByteArray())));
                }
            } else if (message instanceof ObjectMessage) {
                rval = factory.createXMLObjectMessage();
                XMLObjectMessage objectRval = (XMLObjectMessage)rval;
                ObjectMessage objectMessage = (ObjectMessage)message;
                ByteArrayOutputStream bostream = new ByteArrayOutputStream();
                ObjectOutputStream oostream = new ObjectOutputStream(bostream);
                oostream.writeObject(objectMessage.getObject());
                oostream.flush();
                byte[] b = this.getBase64().encode(bostream.toByteArray());
                String s = new String(b, "ASCII");
                objectRval.setObject(s);
            }
            if (message.getJMSReplyTo() != null) {
                rval.setJMSReplyTo(JMSUtils.getDestinationName(message.getJMSReplyTo()));
                rval.setJMSReplyToDomain(Domain.getDomain(message.getJMSReplyTo()).getId());
            }
            try {
                rval.setJMSDeliveryMode(message.getJMSDeliveryMode());
            }
            catch (JMSException ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
            try {
                rval.setJMSExpiration(message.getJMSExpiration());
            }
            catch (JMSException ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
            try {
                rval.setJMSMessageID(message.getJMSMessageID());
            }
            catch (JMSException ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
            try {
                rval.setJMSPriority(message.getJMSPriority());
            }
            catch (JMSException ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
            try {
                rval.setJMSRedelivered(message.getJMSRedelivered());
            }
            catch (JMSException ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
            catch (IllegalStateException ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
            try {
                rval.setJMSTimestamp(message.getJMSTimestamp());
            }
            catch (JMSException ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
            try {
                rval.setJMSType(message.getJMSType());
            }
            catch (JMSException ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
            try {
                rval.setJMSCorrelationID(message.getJMSCorrelationID());
            }
            catch (JMSException ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
            try {
                if (message.getJMSDestination() != null) {
                    rval.setJMSDestination(JMSUtils.getDestinationName(message.getJMSDestination()));
                    rval.setFromQueue(JMSUtils.isQueue(message.getJMSDestination()));
                }
            }
            catch (JMSException ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
            Enumeration iter = message.getPropertyNames();
            while (iter.hasMoreElements()) {
                String propertyName = (String)iter.nextElement();
                if (propertyName.startsWith("JMS")) continue;
                Object propertyValue = message.getObjectProperty(propertyName);
                Property property = factory.createProperty();
                property.setName(propertyName);
                if (propertyValue != null) {
                    property.setValue(propertyValue.toString());
                    property.setType(propertyValue.getClass().getName());
                }
                rval.getHeaderProperty().add(property);
            }
            return rval;
        }
        catch (Exception ex) {
            throw new HermesException(ex);
        }
    }
}

