/*
 * Decompiled with CFR 0.152.
 */
package hermes.fix.quickfix;

import hermes.HermesRuntimeException;
import hermes.fix.FIXMessage;
import hermes.fix.NoSuchFieldException;
import hermes.fix.quickfix.QuickFIXMessageCache;
import hermes.fix.quickfix.QuickFIXUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import quickfix.DataDictionary;
import quickfix.Field;
import quickfix.FieldNotFound;
import quickfix.InvalidMessage;
import quickfix.Message;
import quickfix.mina.message.FIXMessageDecoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractQuickFIXMessage
implements FIXMessage {
    private static Set<Integer> retainedFields = new HashSet<Integer>();
    private Lock lock = new ReentrantLock();
    private static final Logger log;
    private Map<Integer, Field> allFields;
    private Map<Integer, Field> cachedFields = new HashMap<Integer, Field>();
    private DataDictionary dictionary;
    private QuickFIXMessageCache cache;

    public AbstractQuickFIXMessage(QuickFIXMessageCache cache) {
        this.cache = cache;
    }

    public QuickFIXMessageCache getCache() {
        return this.cache;
    }

    private FIXMessageDecoder getDecoder() {
        return this.cache.getDecoder();
    }

    @Override
    public String getMsgType() {
        return this.getString(35);
    }

    @Override
    public synchronized Set<Integer> getFieldOrder() {
        return this.getAllFields().keySet();
    }

    @Override
    public boolean fieldExists(int tag) {
        if (this.cachedFields.containsKey(tag)) {
            return true;
        }
        return this.getAllFields().containsKey(tag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Integer, Field> getAllFields() {
        try {
            this.lock.lock();
            if (this.allFields == null) {
                this.allFields = new LinkedHashMap<Integer, Field>();
                Message message = this.getMessage();
                if (message == null) {
                    HashMap<Integer, Field> hashMap = new HashMap<Integer, Field>();
                    return hashMap;
                }
                for (Field field : message.getHeader()) {
                    this.allFields.put(field.getTag(), field);
                    if (!retainedFields.contains(field.getTag())) continue;
                    this.cachedFields.put(field.getTag(), field);
                }
                for (Field field : message) {
                    int tag = field.getTag();
                    if (this.allFields.containsKey(tag)) continue;
                    this.allFields.put(tag, field);
                    if (!retainedFields.contains(field.getTag())) continue;
                    this.cachedFields.put(field.getTag(), field);
                }
                for (Field field : message.getTrailer()) {
                    this.allFields.put(field.getTag(), field);
                    if (!retainedFields.contains(field.getTag())) continue;
                    this.cachedFields.put(field.getTag(), field);
                }
            }
            Map<Integer, Field> map = this.allFields;
            return map;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        this.lock.lock();
        try {
            this.allFields.clear();
            this.allFields = null;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Object getObject(Field field) {
        if (this.cachedFields.containsKey(field)) {
            return this.cachedFields.get(field).getObject();
        }
        Field cached = this.getAllFields().get(field.getTag());
        if (cached != null) {
            return cached.getObject();
        }
        return null;
    }

    @Override
    public Object getObject(int tag) throws NoSuchFieldException {
        if (this.cachedFields.containsKey(tag)) {
            return this.getObject(this.cachedFields.get(tag));
        }
        if (this.getAllFields().containsKey(tag)) {
            return this.getObject(this.getAllFields().get(tag));
        }
        throw new NoSuchFieldException(tag);
    }

    @Override
    public String getString(int field) {
        try {
            if (this.cachedFields.containsKey(field)) {
                return this.cachedFields.get(field).getObject().toString();
            }
            if (this.getAllFields().containsKey(field)) {
                return this.getAllFields().get(field).getObject().toString();
            }
            throw new FieldNotFound("No such field " + field);
        }
        catch (FieldNotFound e) {
            throw new HermesRuntimeException((Exception)((Object)e));
        }
    }

    @Override
    public DataDictionary getDictionary() {
        return this.dictionary;
    }

    protected void setDictionary(DataDictionary dictionary) {
        this.dictionary = dictionary;
    }

    public String toString() {
        return new String(this.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Message getMessage() {
        this.getCache().lock();
        try {
            if (!this.getCache().contains(this)) {
                try {
                    Message message = new Message(new String(this.getBytes()), this.dictionary, false);
                    this.getCache().put(this, message);
                    if (this.getDictionary() == null) {
                        this.setDictionary(QuickFIXUtils.getDictionary(message));
                    }
                    Message message2 = message;
                    return message2;
                }
                catch (InvalidMessage e) {
                    log.error((Object)("Ignoring invalid message: " + e.getMessage()), (Throwable)e);
                    Message message = null;
                    this.getCache().unlock();
                    return message;
                }
                catch (Exception e) {
                    throw new HermesRuntimeException(e);
                }
            }
            Message message = this.getCache().get(this);
            return message;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.getCache().unlock();
        }
    }

    static {
        retainedFields.add(49);
        retainedFields.add(56);
        retainedFields.add(52);
        retainedFields.add(34);
        retainedFields.add(35);
        retainedFields.add(115);
        retainedFields.add(116);
        log = Logger.getLogger(AbstractQuickFIXMessage.class);
    }

    class MyDecoderOutput
    implements ProtocolDecoderOutput {
        MyDecoderOutput() {
        }

        public void write(Object object) {
            try {
                AbstractQuickFIXMessage.this.getCache().put(AbstractQuickFIXMessage.this, new Message((String)object));
            }
            catch (Exception ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
                throw new HermesRuntimeException(ex);
            }
        }

        public void flush() {
        }
    }
}

