/*
 * Decompiled with CFR 0.152.
 */
package hermes.fix;

import hermes.fix.FIXException;
import hermes.fix.FIXMessage;
import hermes.fix.FIXMessageListener;
import hermes.fix.FIXMessageTable;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class ChainByClOrdID {
    private static final Logger log = Logger.getLogger(ChainByClOrdID.class);
    private FIXMessageTable messages;
    private Set<String> baseTypes = new HashSet<String>();
    private Set<String> followTypes = new HashSet<String>();
    private Set<String> orderIds = new HashSet<String>();

    public ChainByClOrdID(FIXMessageTable messages) {
        this.messages = messages;
        this.baseTypes.add("8");
        this.baseTypes.add("9");
        this.baseTypes.add("D");
        this.followTypes.add("F");
        this.followTypes.add("G");
    }

    public boolean canChain(FIXMessage message) throws FIXException {
        String s = message.getMsgType();
        return this.baseTypes.contains(s) || this.followTypes.contains(s);
    }

    private boolean matches(FIXMessage message) {
        try {
            if (this.baseTypes.contains(message.getMsgType())) {
                if (this.orderIds.contains(message.getString(11))) {
                    return true;
                }
            } else if (this.followTypes.contains(message.getMsgType())) {
                if (this.orderIds.contains(message.getString(41))) {
                    this.orderIds.add(message.getString(41));
                    return true;
                }
                if (this.orderIds.contains(message.getString(11))) {
                    this.orderIds.add(message.getString(41));
                    return true;
                }
            }
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return false;
    }

    public int filterByClOrdID(String clOrdID, FIXMessageListener listener, int startRow) {
        FIXMessage message2;
        int nmessages = 0;
        this.orderIds.add(clOrdID);
        Vector<FIXMessage> cached = new Vector<FIXMessage>();
        for (int row = startRow; row >= 0; --row) {
            message2 = this.messages.getMessageAt(row);
            if (!this.matches(message2)) continue;
            cached.add(0, message2);
        }
        for (FIXMessage message2 : cached) {
            listener.onMessage(message2);
            ++nmessages;
        }
        for (int row = startRow + 1; row < this.messages.getRowCount(); ++row) {
            message2 = this.messages.getMessageAt(row);
            if (!this.matches(message2)) continue;
            listener.onMessage(message2);
            ++nmessages;
        }
        return nmessages;
    }
}

