/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.tasks;

import hermes.Domain;
import hermes.Hermes;
import hermes.browser.HermesBrowser;
import hermes.browser.IconCache;
import hermes.browser.tasks.TaskSupport;
import hermes.config.DestinationConfig;
import hermes.swing.SwingRunner;
import java.awt.Component;
import java.util.Collection;
import javax.jms.JMSException;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class TruncateQueueTask
extends TaskSupport {
    private static final Logger log = Logger.getLogger(TruncateQueueTask.class);
    private DestinationConfig dConfig;
    private Hermes hermes;
    private Collection messageIds;
    private boolean showWarning = true;
    private ProgressMonitor monitor;

    public TruncateQueueTask(Hermes hermes, DestinationConfig dConfig, boolean showWarning) {
        super(IconCache.getIcon("hermes.messages.delete"));
        this.dConfig = dConfig;
        this.hermes = hermes;
        this.showWarning = showWarning;
    }

    public TruncateQueueTask(Hermes hermes, DestinationConfig dConfig, Collection messageIds, boolean showWarning) {
        super(IconCache.getIcon("hermes.messages.delete"));
        this.dConfig = dConfig;
        this.hermes = hermes;
        this.messageIds = messageIds;
        this.showWarning = showWarning;
    }

    public String getTitle() {
        return (this.messageIds == null ? "Truncate" : "Delete") + " from " + this.dConfig.getName();
    }

    public void invoke() throws Exception {
        if (this.messageIds == null) {
            this.doTruncate();
        } else {
            this.doDelete();
        }
        this.hermes.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTruncate() throws Exception {
        TruncateQueueTask truncateQueueTask = this;
        synchronized (truncateQueueTask) {
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    String message = null;
                    if (TruncateQueueTask.this.dConfig.getDomain().intValue() == Domain.QUEUE.getId()) {
                        message = "Are you sure you wish to truncate " + TruncateQueueTask.this.dConfig.getName() + " ?\nAll messages will be deleted from this queue.";
                    } else if (TruncateQueueTask.this.dConfig.isDurable()) {
                        message = "Are you sure you wish to truncate all messages pending for the durable subscription " + TruncateQueueTask.this.dConfig.getClientID() + " on " + TruncateQueueTask.this.dConfig.getName() + "?";
                    }
                    if (JOptionPane.showConfirmDialog((Component)((Object)HermesBrowser.getBrowser()), message, "Warning", 0) != 0) {
                        TruncateQueueTask.this.stop();
                        TruncateQueueTask.this.notifyStatus("Truncate cancelled");
                    }
                    TruncateQueueTask truncateQueueTask = TruncateQueueTask.this;
                    synchronized (truncateQueueTask) {
                        TruncateQueueTask.this.notify();
                    }
                }
            });
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.isRunning()) {
            int size = this.hermes.truncate(this.dConfig);
            if (size == 1) {
                Hermes.ui.getDefaultMessageSink().add("Message deleted from " + this.dConfig.getName() + (this.dConfig.isDurable() ? " durableName=" + this.dConfig.getClientID() : ""));
            } else {
                Hermes.ui.getDefaultMessageSink().add("Deleted " + size + " messages from " + this.dConfig.getName() + (this.dConfig.isDurable() ? " durableName=" + this.dConfig.getClientID() : ""));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDelete() throws Exception {
        TruncateQueueTask truncateQueueTask = this;
        synchronized (truncateQueueTask) {
            if (this.showWarning) {
                SwingRunner.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        if (TruncateQueueTask.this.messageIds.size() > 0) {
                            if (JOptionPane.showConfirmDialog((Component)((Object)HermesBrowser.getBrowser()), "Are you sure you wish to delete " + TruncateQueueTask.this.messageIds.size() + (TruncateQueueTask.this.messageIds.size() > 1 ? " messages" : " message") + " from " + TruncateQueueTask.this.dConfig.getName() + "?", "Warning", 0) != 0) {
                                TruncateQueueTask.this.stop();
                                TruncateQueueTask.this.notifyStatus("Delete from " + TruncateQueueTask.this.dConfig.getName() + " cancelled");
                            }
                            TruncateQueueTask truncateQueueTask = TruncateQueueTask.this;
                            synchronized (truncateQueueTask) {
                                TruncateQueueTask.this.notify();
                            }
                        } else {
                            JOptionPane.showMessageDialog((Component)((Object)HermesBrowser.getBrowser()), "No messages selected to delete.", "Cannot Delete", 0);
                        }
                    }
                });
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
        }
        if (this.isRunning()) {
            final StringBuffer message = new StringBuffer();
            this.monitor = new ProgressMonitor((Component)((Object)HermesBrowser.getBrowser()), "Deleting " + this.messageIds.size() + (this.messageIds.size() == 1 ? " message" : " messages") + " from " + this.dConfig.getName(), "Connecting...", 0, this.messageIds.size()){};
            this.monitor.setMillisToDecideToPopup(50);
            this.monitor.setMillisToPopup(100);
            try {
                this.hermes.delete(this.dConfig, this.messageIds, this.monitor);
                if (this.isRunning()) {
                    this.hermes.commit();
                    message.append("Messages deleted and committed");
                } else {
                    this.hermes.rollback();
                    message.append("Messages rolledback");
                }
                this.hermes.close();
                Hermes.ui.getDefaultMessageSink().add(message.toString());
            }
            catch (Exception ex) {
                message.append("During delete from ").append(this.dConfig.getName()).append(": ").append(ex.getMessage());
                log.error((Object)ex.getMessage(), (Throwable)ex);
                try {
                    this.hermes.rollback();
                }
                catch (JMSException ex2) {
                    message.append("\nRollback also failed, probably transport failure.");
                    log.error((Object)ex2);
                }
                SwingRunner.invokeLater(new Runnable(){

                    public void run() {
                        JOptionPane.showMessageDialog((Component)((Object)HermesBrowser.getBrowser()), message.toString(), "Copy Failed.", 0);
                    }
                });
            }
            finally {
                this.monitor.close();
            }
        }
    }
}

