/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.tasks;

import hermes.SingletonManager;
import hermes.browser.tasks.Task;
import hermes.browser.tasks.ThreadPoolActiveListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class ThreadPool
implements Runnable {
    private static final Logger log = Logger.getLogger(ThreadPool.class);
    private static final ThreadPool threadPool = new ThreadPool(1);
    private ArrayList<Runnable> tasks = new ArrayList();
    private List<Thread> threads = new ArrayList<Thread>();
    private int nthreads;
    private Set<Runnable> running = new HashSet<Runnable>();
    private List<ThreadPoolActiveListener> listeners = new ArrayList<ThreadPoolActiveListener>();

    public static ThreadPool get() {
        return (ThreadPool)SingletonManager.get(ThreadPool.class);
    }

    public ThreadPool(int nthreads) {
        this.nthreads = nthreads;
        for (int i = 0; i < nthreads; ++i) {
            Thread t = new Thread((Runnable)this, "Hermes ThreadPool-" + i);
            this.threads.add(t);
            t.setDaemon(true);
            t.start();
        }
    }

    public void setClassLoader(ClassLoader classLoader) {
        for (Thread t : this.threads) {
            log.debug((Object)("updating ContextClassLoader on " + t.getName()));
            t.setContextClassLoader(classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeLater(Runnable run) {
        ArrayList<Runnable> arrayList = this.tasks;
        synchronized (arrayList) {
            this.tasks.add(run);
            this.tasks.notify();
        }
    }

    public void addActiveListener(ThreadPoolActiveListener listener) {
        this.listeners.add(listener);
    }

    public void removeActiveListener(ThreadPoolActiveListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAll() {
        ArrayList<Runnable> arrayList = this.tasks;
        synchronized (arrayList) {
            Set<Runnable> set = this.running;
            synchronized (set) {
                for (Runnable r : this.running) {
                    if (!(r instanceof Task)) continue;
                    Task task = (Task)((Object)r);
                    task.stop();
                }
            }
            this.tasks.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Thread.currentThread().setPriority(1);
        boolean keepRunning = true;
        while (keepRunning) {
            Set<Runnable> i$;
            Runnable task = null;
            Collection<Runnable> collection = this.tasks;
            synchronized (collection) {
                while (this.tasks.size() == 0) {
                    try {
                        for (ThreadPoolActiveListener l : this.listeners) {
                            l.onInactive();
                        }
                        this.tasks.wait();
                    }
                    catch (InterruptedException ex) {
                        log.error((Object)ex.getMessage(), (Throwable)ex);
                    }
                }
                task = this.tasks.remove(0);
            }
            for (ThreadPoolActiveListener l : this.listeners) {
                l.onActive();
            }
            log.debug((Object)("task " + task + " starting"));
            try {
                i$ = this.running;
                synchronized (i$) {
                    this.running.add(task);
                }
                task.run();
            }
            catch (Throwable ex) {
                log.error((Object)("during run(): " + ex.getMessage()), ex);
            }
            finally {
                i$ = this.running;
                synchronized (i$) {
                    this.running.remove(task);
                }
            }
            log.debug((Object)("task " + task + "  stopped"));
            collection = this.threads;
            synchronized (collection) {
                if (this.threads.size() > this.nthreads) {
                    this.threads.remove(Thread.currentThread());
                    keepRunning = false;
                    log.debug((Object)("threadpool shrinking to " + this.threads.size()));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setThreads(int n) {
        if (n > this.nthreads) {
            log.debug((Object)("growing threadpool to " + n));
            for (int i = this.nthreads; i < n; ++i) {
                Thread t = new Thread((Runnable)this, "Hermes ThreadPool-" + i);
                List<Thread> list = this.threads;
                synchronized (list) {
                    this.threads.add(t);
                }
                t.setDaemon(true);
                t.start();
            }
        }
        this.nthreads = n;
    }

    public int getSize() {
        return this.nthreads;
    }

    static {
        SingletonManager.put(ThreadPool.class, new ThreadPool(1));
    }
}

