/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.tasks;

import hermes.browser.HermesBrowser;
import hermes.browser.IconCache;
import hermes.browser.tasks.MessageTaskListener;
import hermes.browser.tasks.Task;
import hermes.browser.tasks.TaskListener;
import java.util.HashSet;
import java.util.Set;
import javax.jms.Message;
import javax.swing.Icon;
import org.apache.log4j.Logger;

public abstract class TaskSupport
implements Task,
Runnable {
    private static final Logger log = Logger.getLogger(TaskSupport.class);
    private static final Set<TaskListener> globalListeners = new HashSet<TaskListener>();
    private Set<TaskListener> listeners = new HashSet<TaskListener>();
    private boolean isRunning = true;
    private Icon icon = IconCache.getIcon("jms.unknown");
    private Thread myThread;

    public static void addGlobalListener(TaskListener listener) {
        globalListeners.add(listener);
    }

    public static void removeGlobalListener(TaskListener listener) {
        globalListeners.remove(listener);
    }

    protected TaskSupport(Icon icon) {
        this.icon = icon;
        this.listeners.addAll(globalListeners);
    }

    public String getTitle() {
        return "";
    }

    public Icon getIcon() {
        return this.icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTaskListener(TaskListener taskListener) {
        Set<TaskListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(taskListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTaskListener(TaskListener taskListener) {
        Set<TaskListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(taskListener);
        }
    }

    protected void notifyThrowable(Throwable t) {
        for (TaskListener listener : this.listeners) {
            listener.onThrowable(this, t);
        }
    }

    protected void notifyMessage(Message message) {
        for (TaskListener listener : this.listeners) {
            if (!(listener instanceof MessageTaskListener)) continue;
            ((MessageTaskListener)listener).onMessage(this, message);
        }
    }

    protected void notifyStatus(String status) {
        for (TaskListener listener : this.listeners) {
            listener.onStatus(this, status);
        }
    }

    public synchronized void stop() {
        this.isRunning = false;
        if (this.myThread != null) {
            this.myThread.interrupt();
            this.myThread = null;
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public abstract void invoke() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.myThread = Thread.currentThread();
            try {
                for (TaskListener listener : this.listeners) {
                    listener.onStarted(this);
                }
                this.invoke();
            }
            catch (Throwable t) {
                for (TaskListener listener : this.listeners) {
                    listener.onThrowable(this, t);
                }
            }
        }
        finally {
            for (TaskListener listener : this.listeners) {
                listener.onStopped(this);
            }
            this.listeners.clear();
            this.isRunning = false;
            this.myThread = null;
        }
    }

    public void start() {
        HermesBrowser.getBrowser().getThreadPool().invokeLater(this);
    }
}

