/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.tasks;

import hermes.Hermes;
import hermes.browser.HermesBrowser;
import hermes.browser.IconCache;
import hermes.browser.tasks.TaskSupport;
import hermes.store.MessageStore;
import hermes.util.TextUtils;
import java.awt.Component;
import java.util.Collection;
import javax.jms.Message;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteMessagesFromStoreTask
extends TaskSupport {
    private MessageStore messageStore;
    private Collection<Message> messages;
    private boolean warning;

    public DeleteMessagesFromStoreTask(MessageStore messageStore, Collection<Message> messages, boolean warning) {
        super(IconCache.getIcon("hermes.messages.delete"));
        this.messageStore = messageStore;
        this.messages = messages;
        this.warning = warning;
    }

    @Override
    public String getTitle() {
        return "Deleting " + this.messages.size() + " message" + TextUtils.plural(this.messages.size()) + " from " + this.messageStore.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke() throws Exception {
        if (this.warning) {
            DeleteMessagesFromStoreTask deleteMessagesFromStoreTask = this;
            synchronized (deleteMessagesFromStoreTask) {
                SwingUtilities.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        if (JOptionPane.showConfirmDialog((Component)((Object)HermesBrowser.getBrowser()), "Are you sure you wish to delete " + DeleteMessagesFromStoreTask.this.messages.size() + " message" + TextUtils.plural(DeleteMessagesFromStoreTask.this.messages.size()) + " from " + DeleteMessagesFromStoreTask.this.messageStore.getId(), "Warning", 0) != 0) {
                            DeleteMessagesFromStoreTask.this.stop();
                            DeleteMessagesFromStoreTask.this.notifyStatus("Delete from " + DeleteMessagesFromStoreTask.this.messageStore.getId() + " cancelled");
                        }
                        DeleteMessagesFromStoreTask deleteMessagesFromStoreTask = DeleteMessagesFromStoreTask.this;
                        synchronized (deleteMessagesFromStoreTask) {
                            DeleteMessagesFromStoreTask.this.notify();
                        }
                    }
                });
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
        }
        if (this.isRunning()) {
            int numDeleted = 0;
            ProgressMonitor monitor = new ProgressMonitor((Component)((Object)HermesBrowser.getBrowser()), "Deleting " + this.messages.size() + (this.messages.size() == 1 ? " message" : " messages") + " from " + this.messageStore.getId(), "Connecting...", 0, this.messages.size() + 1);
            monitor.setMillisToDecideToPopup(50);
            monitor.setMillisToPopup(50);
            for (Message m : this.messages) {
                this.messageStore.delete(m);
                monitor.setNote(++numDeleted + " messages deleted.");
                monitor.setProgress(numDeleted);
                if (!monitor.isCanceled() && this.isRunning()) continue;
                Hermes.ui.getDefaultMessageSink().add("Delete from " + this.messageStore.getId() + " cancelled");
                break;
            }
            if (this.isRunning() && !monitor.isCanceled()) {
                monitor.setNote("Checkpointing...");
                monitor.setProgress(numDeleted + 1);
                this.messageStore.checkpoint();
                Hermes.ui.getDefaultMessageSink().add(this.messages.size() + " message" + TextUtils.plural(this.messages.size()) + " deleted from store " + this.messageStore.getId());
            } else {
                this.messageStore.rollback();
            }
        }
    }
}

