/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.model;

import hermes.config.DestinationConfig;
import hermes.ext.HermesAdminSupport;
import hermes.impl.DestinationConfigKeyWrapper;
import java.beans.PropertyChangeSupport;
import java.util.Map;
import javax.jms.JMSException;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class WatchInfo
extends PropertyChangeSupport {
    private static final Logger log = Logger.getLogger(WatchInfo.class);
    public static final String STATISTICS = "statistics";
    public static final String DEPTH = "depth";
    public static final String EXCEPTION = "exception";
    public static final String OLDEST = "oldest";
    private DestinationConfigKeyWrapper key;
    private String hermesId;
    private DestinationConfig dConfig;
    private int depth;
    private long oldest;
    private Throwable e;
    private int depthAlert;
    private long ageAlert;
    private boolean inAlert = false;
    private Map statistics = HermesAdminSupport.getDefaultStatistics();

    public WatchInfo(String hermesId, DestinationConfig dConfig) throws JMSException {
        super(new DestinationConfigKeyWrapper(dConfig));
        this.key = new DestinationConfigKeyWrapper(dConfig);
        this.hermesId = hermesId;
        this.dConfig = dConfig;
        dConfig.setMyHermes(hermesId);
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(final int newDepth) {
        if (this.depth != newDepth) {
            final int oldDepth = this.depth;
            this.depth = newDepth;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    WatchInfo.this.firePropertyChange(WatchInfo.DEPTH, oldDepth, newDepth);
                }
            });
        }
    }

    public Throwable getE() {
        return this.e;
    }

    public void setE(final Throwable newE) {
        this.e = newE;
        if (this.e != null && newE != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    WatchInfo.this.firePropertyChange(WatchInfo.EXCEPTION, WatchInfo.this.e, newE);
                }
            });
        }
    }

    public boolean isInAlert() {
        return this.inAlert;
    }

    public void setInAlert(boolean inAlert) {
        this.inAlert = inAlert;
    }

    public long getOldest() {
        return this.oldest;
    }

    public void setOldest(final long newOldest) {
        if (newOldest != this.oldest) {
            final long oldOldest = this.oldest;
            this.oldest = newOldest;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    WatchInfo.this.firePropertyChange(WatchInfo.OLDEST, new Long(oldOldest), new Long(newOldest));
                }
            });
        }
    }

    public Map getStatistics() {
        return this.statistics;
    }

    public void setStatistics(final Map newStatistics) {
        final Map oldStatistics = this.statistics;
        this.statistics = newStatistics;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                WatchInfo.this.firePropertyChange(WatchInfo.STATISTICS, oldStatistics, newStatistics);
            }
        });
    }

    public long getAgeAlert() {
        return this.ageAlert;
    }

    public void setAgeAlert(long ageAlert) {
        this.ageAlert = ageAlert;
    }

    public int getDepthAlert() {
        return this.depthAlert;
    }

    public void setDepthAlert(int depthAlert) {
        this.depthAlert = depthAlert;
    }

    public DestinationConfig getConfig() {
        return this.dConfig;
    }

    public String getHermesId() {
        return this.hermesId;
    }

    public void setHermesId(String hermesId) {
        this.hermesId = hermesId;
    }

    public DestinationConfigKeyWrapper getKey() {
        return this.key;
    }
}

