/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.model;

import hermes.Hermes;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.Vector;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;

public class DestinationStatisticsTableModel
extends AbstractTableModel {
    private Map stats = new TreeMap();
    private Hermes hermes;
    private Vector rows = new Vector();
    private TimerTask updateTask;
    private Timer timer;
    private boolean keepRunning = true;
    private static final String[] columns = new String[]{"Destination", "Total Read", "Max (per second)"};

    public DestinationStatisticsTableModel(Hermes hermes, Timer timer) {
        this.timer = timer;
        this.hermes = hermes;
    }

    public String getColumnName(int column) {
        return columns[column];
    }

    public int getRowCount() {
        return this.stats.size();
    }

    public int getColumnCount() {
        return 3;
    }

    public synchronized Object getValueAt(int arg0, int arg1) {
        Statistics row = (Statistics)this.rows.elementAt(arg0);
        if (row != null) {
            switch (arg1) {
                case 0: {
                    return row.destination;
                }
                case 1: {
                    return new Integer(row.messagesRead);
                }
                case 2: {
                    return new Integer(row.maxRate);
                }
            }
        }
        return null;
    }

    public synchronized void onMessage(Message m) {
        if (this.updateTask == null) {
            this.updateTask = new TimerTask(){

                public void run() {
                    DestinationStatisticsTableModel.this.run();
                }
            };
            this.timer.schedule(this.updateTask, 1000L, 1000L);
        }
        try {
            Statistics destinationStats = null;
            if (m.getJMSDestination() != null) {
                if (!this.stats.containsKey(m.getJMSDestination().toString())) {
                    destinationStats = new Statistics();
                    destinationStats.destination = this.hermes.getDestinationName(m.getJMSDestination());
                    this.stats.put(m.getJMSDestination().toString(), destinationStats);
                    this.rows.clear();
                    Iterator iter = this.stats.keySet().iterator();
                    while (iter.hasNext()) {
                        this.rows.add(this.stats.get(iter.next()));
                    }
                } else {
                    destinationStats = (Statistics)this.stats.get(m.getJMSDestination().toString());
                }
                ++destinationStats.messagesReadInPeriod;
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    public void run() {
        for (int i = 0; i < this.rows.size(); ++i) {
            Statistics row = (Statistics)this.rows.elementAt(i);
            if (row.messagesReadInPeriod <= 0) continue;
            if (row.messagesReadInPeriod > row.maxRate) {
                row.maxRate = row.messagesReadInPeriod;
            }
            row.messagesRead += row.messagesReadInPeriod;
            row.messagesReadInPeriod = 0;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DestinationStatisticsTableModel.this.fireTableDataChanged();
            }
        });
        if (!this.keepRunning) {
            this.updateTask.cancel();
        }
    }

    public void stop() {
        this.keepRunning = false;
    }

    private static class Statistics {
        public String destination;
        public int messagesRead;
        public int maxRate;
        public int messagesReadInPeriod;
        public long startTime = System.currentTimeMillis();

        private Statistics() {
        }
    }
}

