/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.model;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.log4j.Category;

public class BeanTableModel
extends DefaultTableModel {
    private static Set ignore = new HashSet();
    private static final Category cat = Category.getInstance(BeanTableModel.class);
    private Object bean;
    private Map filter;
    private Vector rows = new Vector();
    private String[] columns = new String[]{"Property", "Value"};
    private Map changes = new HashMap();

    public BeanTableModel(Object bean, Map filter) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Map properties = PropertyUtils.describe((Object)bean);
        Set iterSet = null;
        this.bean = bean;
        iterSet = filter == null ? properties.keySet() : filter.keySet();
        for (String propertyName : iterSet) {
            if (!properties.containsKey(propertyName) || ignore.contains(propertyName)) continue;
            Object propertyValue = properties.get(propertyName);
            if (propertyValue == null) {
                propertyValue = "null";
            }
            Vector<String> row = new Vector<String>();
            row.add(propertyName);
            row.add((String)propertyValue);
            this.rows.add(row);
        }
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public int getColumnCount() {
        return this.columns.length;
    }

    public Object getValueAt(int arg0, int arg1) {
        Vector row = (Vector)this.rows.elementAt(arg0);
        return row.elementAt(arg1);
    }

    public String getColumnName(int x) {
        return this.columns[x];
    }

    public boolean isCellEditable(int y, int x) {
        return x == 1;
    }

    public void setValueAt(Object value, int y, int x) {
        Vector row = (Vector)this.rows.elementAt(y);
        String propertyName = (String)row.elementAt(0);
        row.set(x, value);
        this.changes.put(propertyName, value);
    }

    public void updateBean() throws InvocationTargetException, IllegalAccessException, IllegalAccessException, NoSuchMethodException {
        for (String key : this.changes.keySet()) {
            Object value = this.changes.get(key);
            cat.debug((Object)("setting property=" + key + " value=" + value));
            PropertyUtils.setProperty((Object)this.bean, (String)key, value);
        }
        this.changes.clear();
    }

    static {
        ignore.add("class");
    }
}

