/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.dialog.message;

import hermes.HermesRuntimeException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditableMessageHeaderTableModel
implements TableModel {
    private static final Logger log = Logger.getLogger(EditableMessageHeaderTableModel.class);
    private static final String[] JMS_PROPERTIES = new String[]{"JMSMessageID", "JMSType", "JMSReplyTo", "JMSCorrelationID", "JMSExpiration", "JMSPriority"};
    private Message message;
    private Vector<String> properties = new Vector();
    private List<TableModelListener> listeners = new ArrayList<TableModelListener>();

    public EditableMessageHeaderTableModel(Message message) throws JMSException {
        this.message = message;
        for (String jmsProperty : JMS_PROPERTIES) {
            this.properties.add(jmsProperty);
        }
        Enumeration iter = message.getPropertyNames();
        while (iter.hasMoreElements()) {
            String propertyName = (String)iter.nextElement();
            this.properties.add(propertyName);
        }
    }

    @Override
    public int getRowCount() {
        return this.properties.size();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Name";
            }
            case 1: {
                return "Class";
            }
            case 2: {
                return "Value";
            }
        }
        return "Error";
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        try {
            switch (columnIndex) {
                case 0: {
                    return this.properties.get(rowIndex);
                }
                case 1: {
                    return BeanUtils.getProperty((Object)this.message, (String)this.properties.get(rowIndex));
                }
                case 2: {
                    String o = BeanUtils.getProperty((Object)this.message, (String)this.properties.get(rowIndex));
                    if (o != null) {
                        return o.getClass().getName();
                    }
                    return "Object.class";
                }
            }
            return "Error";
        }
        catch (Exception ex) {
            throw new HermesRuntimeException(ex);
        }
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
    }
}

