/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.dialog;

import hermes.browser.HermesBrowser;
import hermes.browser.dialog.PreferencesDialog;
import hermes.config.SessionConfig;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.apache.log4j.Category;

public class SessionConfigPanel
extends JPanel {
    private static final Category cat = Category.getInstance(SessionConfigPanel.class);
    public static final String NEWSESSION = "<new>";
    private PreferencesDialog dialog;
    private SessionConfig sessionConfig;
    private JCheckBox transactedCB = new JCheckBox();
    private JCheckBox auditCB = new JCheckBox();
    private JCheckBox useConsumerForQueueBrowseCB = new JCheckBox();
    private JComboBox sessionCombo = new JComboBox();
    private Map sessionConfigs = new HashMap();
    private DefaultComboBoxModel sessionComboModel = new DefaultComboBoxModel();

    public SessionConfigPanel(PreferencesDialog dialog) {
        this.dialog = dialog;
        this.init();
    }

    public void init() {
        Border border = BorderFactory.createBevelBorder(0);
        this.setLayout(new GridLayout(2, 4));
        this.setBorder(BorderFactory.createTitledBorder(border, "Session"));
        this.sessionCombo.setModel(this.sessionComboModel);
        JLabel l1 = new JLabel("Session: ");
        l1.setHorizontalAlignment(4);
        this.add(l1);
        this.add(this.sessionCombo);
        JLabel l2 = new JLabel("Use Consumer: ");
        l2.setHorizontalAlignment(4);
        this.add(l2);
        l2.setToolTipText("Check this if you wish to use a MessageConsumer instead of a QueueBrowser");
        this.add(this.useConsumerForQueueBrowseCB);
        JLabel l3 = new JLabel("Audit: ");
        l3.setHorizontalAlignment(4);
        this.add(l3);
        this.add(this.auditCB);
        JLabel l4 = new JLabel("Transacted: ");
        l4.setHorizontalAlignment(4);
        this.add(l4);
        this.add(this.transactedCB);
        this.sessionCombo.setEditable(true);
        this.auditCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                SessionConfigPanel.this.sessionConfig.setAudit(SessionConfigPanel.this.auditCB.isSelected());
                SessionConfigPanel.this.dialog.setDirty();
            }
        });
        this.transactedCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                SessionConfigPanel.this.sessionConfig.setTransacted(SessionConfigPanel.this.transactedCB.isSelected());
                SessionConfigPanel.this.dialog.setDirty();
            }
        });
    }

    public void addListeners() {
        this.sessionComboModel.addListDataListener(new ListDataListener(){

            public void contentsChanged(ListDataEvent arg0) {
                String sessionId = (String)SessionConfigPanel.this.sessionComboModel.getSelectedItem();
                if (SessionConfigPanel.this.sessionComboModel.getSize() != 0 && SessionConfigPanel.this.dialog.getFactoryConfigBySessionId(sessionId) == null) {
                    if (SessionConfigPanel.this.sessionConfig.getId().equals(SessionConfigPanel.NEWSESSION) || SessionConfigPanel.this.isSessionRename()) {
                        SessionConfigPanel.this.sessionConfig.setId(sessionId);
                    } else {
                        SessionConfigPanel.this.dialog.refocus(sessionId);
                    }
                } else {
                    SessionConfigPanel.this.dialog.refocus(sessionId);
                }
            }

            public void intervalAdded(ListDataEvent arg0) {
            }

            public void intervalRemoved(ListDataEvent arg0) {
            }
        });
    }

    public boolean isSessionRename() {
        Object[] options = new Object[]{"New", "Rename"};
        int n = JOptionPane.showOptionDialog((Component)((Object)HermesBrowser.getBrowser()), "Rename this session or create a new one?", "Please select...", 0, 3, null, options, options[1]);
        return n != 0;
    }

    public void addSessionConfig(SessionConfig sessionConfig) {
        if (sessionConfig.getId() != null && !sessionConfig.getId().equals("")) {
            this.sessionConfig = sessionConfig;
            if (!this.sessionConfigs.containsKey(sessionConfig.getId())) {
                this.sessionConfigs.put(sessionConfig.getId(), sessionConfig);
                this.sessionComboModel.addElement(sessionConfig.getId());
            }
        }
    }

    public void setSessionConfig(SessionConfig sessionConfig) {
        if (sessionConfig.getId() != null && !sessionConfig.getId().equals("")) {
            this.sessionConfig = sessionConfig;
            if (!this.sessionConfigs.containsKey(sessionConfig.getId())) {
                this.sessionConfigs.put(sessionConfig.getId(), sessionConfig);
                this.sessionComboModel.addElement(sessionConfig.getId());
            }
            this.sessionCombo.setSelectedItem(sessionConfig.getId());
            this.useConsumerForQueueBrowseCB.setSelected(sessionConfig.isUseConsumerForQueueBrowse());
            if (sessionConfig.getReconnects() == null) {
                sessionConfig.setReconnects(new BigInteger("0"));
            }
            this.transactedCB.setSelected(sessionConfig.isTransacted());
            this.auditCB.setSelected(sessionConfig.isAudit());
        }
    }

    public SessionConfig getSessionConfig() {
        return this.sessionConfig;
    }

    public void updateModel() {
        if (this.sessionConfig != null) {
            this.sessionConfig.setId((String)this.sessionCombo.getSelectedItem());
            this.sessionConfig.setAudit(this.sessionConfig.isAudit());
            this.sessionConfig.setUseConsumerForQueueBrowse(this.useConsumerForQueueBrowseCB.isSelected());
        }
    }
}

