/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.dialog;

import com.jidesoft.grid.PropertyPane;
import com.jidesoft.grid.PropertyTable;
import com.jidesoft.grid.PropertyTableModel;
import hermes.browser.dialog.JidePropertyImpl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;

public class MapPropertyPanel
extends JPanel {
    private static final long serialVersionUID = 2789449525269251165L;
    private static final Logger log = Logger.getLogger(MapPropertyPanel.class);
    private List onOK = new ArrayList();
    private Map map;
    private Map changes = new HashMap();
    private boolean editable = false;
    private String title;

    public MapPropertyPanel(String title, Map map, boolean editable) {
        this(map, editable);
        this.title = title;
    }

    public MapPropertyPanel(Map map, boolean editable) {
        this.map = map;
        this.editable = editable;
    }

    public MapPropertyPanel(Map map) {
        this(map, false);
    }

    protected void doOnOK(Runnable r) {
        this.onOK.add(r);
    }

    protected void onSetProperty(String propertyName, Object propertyValue) {
        log.debug((Object)("setting " + propertyName + " = " + propertyValue));
        this.map.put(propertyName, propertyValue);
        this.changes.put(propertyName, propertyValue);
    }

    protected JComponent createNorthComponent() {
        if (this.title == null) {
            return new JLabel();
        }
        JLabel classNameLabel = new JLabel(this.title);
        classNameLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return classNameLabel;
    }

    protected JComponent createCenterComponent() {
        ArrayList<1> model = new ArrayList<1>();
        try {
            for (final String propertyName : this.map.keySet()) {
                if (propertyName.equals("class")) continue;
                Object propertyValue = this.map.get(propertyName);
                if (propertyValue == null) {
                    propertyValue = "";
                }
                final JidePropertyImpl pConfig = new JidePropertyImpl(propertyName, propertyName + " [" + this.getPropertyType(propertyName).getName() + "]", this.getPropertyType(propertyName), propertyValue){

                    public void setValue(final Object newValue) {
                        super.setValue(newValue);
                        log.debug((Object)("setValue propertyName=" + propertyName + ", newValue=" + newValue));
                        MapPropertyPanel.this.doOnOK(new Runnable(){

                            public void run() {
                                MapPropertyPanel.this.onSetProperty(propertyName, newValue);
                            }
                        });
                    }
                };
                pConfig.setEditable(this.editable);
                if (this.editable) {
                    this.onOK.add(new Runnable(){

                        public void run() {
                            MapPropertyPanel.this.map.put(propertyName, pConfig.getValue());
                        }
                    });
                }
                model.add(pConfig);
            }
        }
        catch (IllegalAccessException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        PropertyTableModel propertyTableModel = new PropertyTableModel(model);
        PropertyTable propertyTable = new PropertyTable((TableModel)propertyTableModel);
        propertyTable.expandAll();
        PropertyPane propertyPane = new PropertyPane(propertyTable);
        return propertyPane;
    }

    public void init() {
        this.setBorder(BorderFactory.createBevelBorder(0));
        this.setLayout(new BorderLayout());
        this.add((Component)this.createNorthComponent(), "North");
        this.add((Component)this.createCenterComponent(), "Center");
    }

    public Map getChanges() {
        return this.changes;
    }

    public Map getMap() {
        return this.map;
    }

    public void doOK() {
        for (Runnable r : this.onOK) {
            r.run();
        }
    }

    public void doCancel() {
    }

    private Class getPropertyType(String propertyName) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (this.map.get(propertyName) == null) {
            return String.class;
        }
        return this.map.get(propertyName).getClass();
    }

    public void addOKAction(Runnable r) {
        this.onOK.add(r);
    }

    public boolean isEditable() {
        return this.editable;
    }
}

