/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.components;

import com.jidesoft.swing.JideScrollPane;
import com.jidesoft.swing.JideTabbedPane;
import hermes.Hermes;
import hermes.browser.HermesBrowser;
import hermes.browser.MessageRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.jms.Message;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.apache.log4j.Logger;

public class MessagePayloadPanel
extends JPanel {
    private static final Logger log = Logger.getLogger(MessagePayloadPanel.class);
    private final JTabbedPane tabbedPane = new JideTabbedPane();
    private String destinationName;

    public MessagePayloadPanel(String destinationName) {
        this.destinationName = destinationName;
        this.init();
    }

    public MessagePayloadPanel(Hermes hermes, String destinationName, Message message) {
        this.destinationName = destinationName;
        this.init();
        this.setMessage(hermes, message);
    }

    private void init() {
        this.tabbedPane.setTabPlacement(3);
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPane, "Center");
    }

    public void setMessage(Hermes hermes, Message m) {
        String selectedTitle = null;
        int selectedIndex = 0;
        if (this.tabbedPane.getSelectedIndex() > -1) {
            selectedTitle = this.tabbedPane.getTitleAt(this.tabbedPane.getSelectedIndex());
        }
        this.tabbedPane.removeAll();
        for (MessageRenderer renderer : HermesBrowser.getRendererManager().getRenderers()) {
            if (!renderer.isActive() || !renderer.canRender(m)) continue;
            JideScrollPane component = new JideScrollPane((Component)renderer.render(m));
            this.tabbedPane.add(renderer.getDisplayName(), (Component)component);
            if (!renderer.getDisplayName().equals(selectedTitle)) continue;
            selectedIndex = this.tabbedPane.getTabCount() - 1;
            this.tabbedPane.setSelectedIndex(selectedIndex);
        }
        this.tabbedPane.setSelectedIndex(selectedIndex);
    }
}

