/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.components;

import hermes.browser.actions.BrowserAction;
import hermes.browser.components.MessageHeaderTable;
import hermes.browser.transferable.MessageHeaderTransferHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.apache.log4j.Logger;

class MessageHeaderTableSupport {
    private static final Logger log = Logger.getLogger(MessageHeaderTableSupport.class);

    MessageHeaderTableSupport() {
    }

    static void init(final BrowserAction action, final MessageHeaderTable table, DataFlavor[] myFlavours) {
        table.setDragEnabled(true);
        table.setTransferHandler(new MessageHeaderTransferHandler(action));
        MouseAdapter ml = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isMiddleMouseButton(e)) {
                    table.clearSelection();
                } else if (SwingUtilities.isLeftMouseButton(e)) {
                    if (e.getClickCount() == 2) {
                        table.onDoubleClick();
                    } else {
                        JComponent c = (JComponent)e.getSource();
                        TransferHandler th = c.getTransferHandler();
                        th.exportAsDrag(c, e, 1);
                    }
                } else if (SwingUtilities.isRightMouseButton(e)) {
                    action.doPopup(e);
                }
            }
        };
        table.addMouseListener(ml);
        DefaultTableCellRenderer dateRenderer = new DefaultTableCellRenderer(){

            protected void setValue(Object value) {
                super.setText(value == null ? "" : value.toString());
            }
        };
        table.setDefaultRenderer(Date.class, dateRenderer);
    }

    static Component prepareRenderer(Component c, JTable table, TableCellRenderer renderer, int row, int column) {
        if (!table.isCellSelected(row, column)) {
            if (row % 2 == 1) {
                c.setBackground(Color.LIGHT_GRAY);
            } else {
                c.setBackground(table.getBackground());
            }
        }
        return c;
    }
}

