/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.actions;

import hermes.Domain;
import hermes.Hermes;
import hermes.browser.HermesBrowser;
import hermes.browser.IconCache;
import hermes.browser.actions.QueueBrowseAction;
import hermes.browser.tasks.BrowseMessageStoreTask;
import hermes.browser.tasks.Task;
import hermes.store.MessageStore;
import hermes.util.JMSUtils;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.swing.Icon;
import org.apache.log4j.Logger;

public class MessageStoreBrowserAction
extends QueueBrowseAction {
    private static final Logger log = Logger.getLogger(MessageStoreBrowserAction.class);
    private MessageStore messageStore;
    private Destination destination;
    private String selector;

    public MessageStoreBrowserAction(Hermes hermes, MessageStore messageStore, Destination destination) throws JMSException {
        super(hermes, HermesBrowser.getConfigDAO().createDestinationConfig(messageStore.getId() + destination, Domain.QUEUE), -1, null);
        this.messageStore = messageStore;
        this.destination = destination;
    }

    public MessageStoreBrowserAction(Hermes hermes, MessageStore messageStore, Destination destination, String selector) throws JMSException {
        super(hermes, HermesBrowser.getConfigDAO().createDestinationConfig(messageStore.getId() + destination, Domain.QUEUE), -1, null);
        this.messageStore = messageStore;
        this.destination = destination;
        this.selector = selector;
    }

    public boolean isRefreshable() {
        return false;
    }

    public String getTitle() {
        String rval = this.destination == null ? this.messageStore.getId() : this.messageStore.getId() + ": " + JMSUtils.getDestinationName(this.destination);
        if (this.selector != null) {
            rval = rval + " " + this.selector;
        }
        return rval;
    }

    public String getDestination() {
        if (this.destination != null) {
            return JMSUtils.getDestinationName(this.destination);
        }
        return this.messageStore.getId();
    }

    protected Task createTask() throws Exception {
        return new BrowseMessageStoreTask(this.getHermes(), this.messageStore, this.destination, this.selector);
    }

    public Icon getIcon() {
        if (this.destination == null) {
            return IconCache.getIcon("hermes.store");
        }
        return Domain.getDomain(this.destination).getIcon();
    }

    public MessageStore getMessageStore() {
        return this.messageStore;
    }

    public void delete() {
        try {
            HermesBrowser.getBrowser().getActionFactory().createDeleteFromMessageStoreAction(this.getMessageStore(), this.getSelectedMessages(), true);
        }
        catch (JMSException ex) {
            HermesBrowser.getBrowser().showErrorDialog(ex);
        }
    }
}

