/*
 * Decompiled with CFR 0.152.
 */
package hermes;

import hermes.Domain;
import hermes.Hermes;
import hermes.HermesConfigurationListener;
import hermes.HermesException;
import hermes.HermesLoader;
import hermes.JNDIConnectionFactory;
import hermes.NoConfigurationException;
import hermes.SingletonManager;
import hermes.browser.HermesBrowser;
import hermes.browser.dialog.SelectorImpl;
import hermes.config.ClasspathGroupConfig;
import hermes.config.ConnectionConfig;
import hermes.config.DestinationConfig;
import hermes.config.FactoryConfig;
import hermes.config.HermesConfig;
import hermes.config.NamingConfig;
import hermes.config.QuickFIXConfig;
import hermes.config.SessionConfig;
import hermes.config.WatchConfig;
import hermes.fix.quickfix.QuickFIXMessageCache;
import hermes.impl.ClassLoaderManager;
import hermes.impl.ConnectionFactoryManagerImpl;
import hermes.impl.ConnectionManager;
import hermes.impl.ConnectionManagerFactory;
import hermes.impl.DefaultHermesImpl;
import hermes.impl.JNDIDestinationManager;
import hermes.impl.NullClassLoaderManager;
import hermes.impl.SimpleClassLoaderManager;
import hermes.impl.jms.SimpleDestinationManager;
import hermes.impl.jms.ThreadLocalSessionManager;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnectionFactory;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBHermesLoader
implements HermesLoader {
    private static final Logger log = Logger.getLogger(JAXBHermesLoader.class);
    private static final String FILE_NAME = "hermes-config.xml";
    private static final String DEFAULT_EXTENSION_LOADER = "hermes.ext.ExtensionFinderImpl";
    private URL url;
    private File file;
    private HermesConfig config;
    private JAXBElement<HermesConfig> element;
    private ClassLoaderManager classLoaderManager;
    private Hashtable properties;
    private final Set listeners = new HashSet();
    private final Map<String, FactoryConfig> factoryConfigById = new HashMap<String, FactoryConfig>();
    private boolean ignoreClasspathGroups;
    private Context context;
    private String extensionLoaderClass = "hermes.ext.ExtensionFinderImpl";

    @Override
    public void setContext(Context context) {
        this.context = context;
    }

    @Override
    public void backup() throws HermesException {
        try {
            if (this.file != null) {
                JAXBHermesLoader.copyFile(this.file.getAbsolutePath(), this.file.getAbsolutePath() + ".backup");
            }
        }
        catch (IOException e) {
            throw new HermesException(e);
        }
    }

    @Override
    public void restore() throws HermesException {
        try {
            if (this.file != null) {
                JAXBHermesLoader.copyFile(this.file.getAbsolutePath() + ".backup", this.file.getAbsolutePath());
            }
        }
        catch (IOException e) {
            throw new HermesException(e);
        }
    }

    @Override
    public void save() throws HermesException {
        try {
            if (this.file == null) {
                throw new HermesException("No file to save configuration to (did you load from a URL?)");
            }
            FileOutputStream ostream = new FileOutputStream(this.file);
            JAXBContext jc = JAXBContext.newInstance((String)"hermes.config");
            Marshaller m = jc.createMarshaller();
            this.config.setLastEditedByHermesVersion("v1.14 SoapUI");
            this.config.setLastEditedByUser(System.getProperty("user.name"));
            this.config.setLookAndFeel(UIManager.getLookAndFeel().getClass().getName());
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            this.element.setValue((Object)this.config);
            m.marshal(this.element, (OutputStream)ostream);
            ((OutputStream)ostream).close();
        }
        catch (FileNotFoundException e) {
            throw new HermesException(e);
        }
        catch (PropertyException e) {
            throw new HermesException((Exception)((Object)e));
        }
        catch (JAXBException e) {
            throw new HermesException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw new HermesException(e);
        }
    }

    @Override
    public void addDestinationConfig(Hermes hermes, DestinationConfig config) throws JMSException {
        if (!this.factoryConfigById.containsKey(hermes.getId())) {
            throw new HermesException("No such session " + hermes.getId());
        }
        FactoryConfig fConfig = this.factoryConfigById.get(hermes.getId());
        fConfig.getDestination().add(config);
        hermes.addDestinationConfig(config);
        this.notifyDestinationAdded(hermes, config);
    }

    @Override
    public void replaceDestinationConfigs(Hermes hermes, Collection dConfigs) throws JMSException {
        boolean keepDurableSubscriptions = true;
        boolean keepDurableSubscriptionsDialogShown = false;
        if (this.factoryConfigById.containsKey(hermes.getId())) {
            FactoryConfig fConfig = this.factoryConfigById.get(hermes.getId());
            Iterator<DestinationConfig> iter = fConfig.getDestination().iterator();
            while (iter.hasNext()) {
                DestinationConfig dConfig = iter.next();
                if (dConfig.getDomain().intValue() == Domain.TOPIC.getId() && dConfig.isDurable()) {
                    if (!keepDurableSubscriptionsDialogShown) {
                        if (HermesBrowser.getBrowser() != null && JOptionPane.showConfirmDialog((Component)((Object)HermesBrowser.getBrowser()), "Do you want to keep configured durable subscriptions?", "Durable Subscriptions", 0) == 1) {
                            keepDurableSubscriptions = false;
                        }
                        keepDurableSubscriptionsDialogShown = true;
                    }
                    if (keepDurableSubscriptions) continue;
                    iter.remove();
                    this.notifyDestinationRemoved(hermes, dConfig);
                    continue;
                }
                iter.remove();
                this.notifyDestinationRemoved(hermes, dConfig);
            }
            for (DestinationConfig dConfig : dConfigs) {
                fConfig.getDestination().add(dConfig);
                hermes.addDestinationConfig(dConfig);
                this.notifyDestinationAdded(hermes, dConfig);
            }
        } else {
            throw new HermesException("No such session " + hermes.getId());
        }
    }

    @Override
    public List<Hermes> load() throws HermesException {
        ArrayList<Hermes> rval = null;
        InputStream istream = null;
        this.factoryConfigById.clear();
        if (this.properties == null) {
            throw new HermesException("No properties available");
        }
        try {
            if (this.file == null) {
                String from = !this.properties.containsKey("java.naming.provider.url") ? FILE_NAME : (String)this.properties.get("java.naming.provider.url");
                log.debug((Object)("attempting to load from URL: " + from));
                try {
                    istream = new URL(from).openStream();
                }
                catch (IOException ex) {
                    log.info((Object)("failed to load configuration from " + from + ", attempting to load as a file..."));
                }
                if (istream == null) {
                    this.file = new File(from);
                    log.debug((Object)("trying to load from file: " + this.file.getName()));
                    if (!this.file.exists()) {
                        throw new NoConfigurationException();
                    }
                    istream = new FileInputStream(this.file);
                }
            } else {
                istream = new FileInputStream(this.file);
            }
            rval = new ArrayList<Hermes>();
            JAXBContext jc = JAXBContext.newInstance((String)"hermes.config");
            Unmarshaller u = jc.createUnmarshaller();
            this.element = u.unmarshal((Source)new StreamSource(istream), HermesConfig.class);
            this.config = (HermesConfig)this.element.getValue();
            Hermes.ui.setConfig(this.config);
            if (this.config.getLastEditedByHermesVersion() == null) {
                this.config.setLastEditedByHermesVersion("v1.14 SoapUI");
                this.config.setDisplayFactoryAdmin(true);
            }
            if (this.config.getQuickFIX() == null) {
                QuickFIXConfig quickFIXConfig = new QuickFIXConfig();
                quickFIXConfig.setCacheSize(1024);
                this.config.setQuickFIX(quickFIXConfig);
            }
            this.config.setSelectorImpl(SelectorImpl.JAMSEL.getClazz().getName());
            if (this.config.getAutoBrowseRefreshRate() == 0) {
                this.config.setAutoBrowseRefreshRate(10);
            }
            if (this.config.getMaxColumnsInStatisticsTable() == 0) {
                this.config.setMaxColumnsInStatisticsTable(10);
            }
            if (this.config.getLoader() != null && this.config.getLoader().size() > 0) {
                ClasspathGroupConfig gConfig = new ClasspathGroupConfig();
                gConfig.setId("Default");
                gConfig.getLibrary().addAll(this.config.getLoader());
                this.config.getClasspathGroup().clear();
                this.config.getClasspathGroup().add(gConfig);
                this.config.getLoader().clear();
            }
            this.classLoaderManager = !this.ignoreClasspathGroups ? new SimpleClassLoaderManager(this.config.getClasspathGroup()) : new NullClassLoaderManager();
            SingletonManager.put(ClassLoaderManager.class, this.classLoaderManager);
            QuickFIXMessageCache cache = (QuickFIXMessageCache)SingletonManager.get(QuickFIXMessageCache.class);
            cache.setSize(this.config.getQuickFIX().getCacheSize());
            HermesBrowser.getRendererManager().setConfig(this.classLoaderManager.getDefaultClassLoader(), this.config);
            Hermes.ui.getThreadPool().setThreads(this.config.getMaxThreadPoolSize());
            if (this.config.getWatch() == null) {
                WatchConfig wConfig = new WatchConfig();
                wConfig.setShowAge(true);
                this.config.getWatch().add(wConfig);
            }
            Iterator<FactoryConfig> iter = this.config.getFactory().iterator();
            while (iter.hasNext()) {
                FactoryConfig factoryConfig = iter.next();
                if (factoryConfig.getConnection().size() == 0) {
                    log.debug((Object)"cleaning up FactoryConfig with no connections");
                    iter.remove();
                    continue;
                }
                ConnectionConfig firstConnection = factoryConfig.getConnection().get(0);
                if (firstConnection.getSession().size() == 0) {
                    log.debug((Object)"cleaning up FactoryConfig with no sessions");
                    iter.remove();
                    continue;
                }
                SessionConfig firstSession = firstConnection.getSession().get(0);
                if (firstSession.getId() == null) {
                    log.debug((Object)"cleaning up FactoryConfig with a null session");
                    iter.remove();
                    continue;
                }
                try {
                    Hermes hermes = this.createHermes(factoryConfig);
                    rval.add(hermes);
                    this.notifyHermesAdded(hermes);
                    Iterator diter = hermes.getDestinations();
                    while (diter.hasNext()) {
                        DestinationConfig destinationConfig = (DestinationConfig)diter.next();
                        boolean isQueue = hermes.getConnectionFactory() instanceof QueueConnectionFactory;
                        boolean isTopic = hermes.getConnectionFactory() instanceof TopicConnectionFactory;
                        if (destinationConfig.getDomain() == 0 && HermesBrowser.getBrowser() != null) {
                            if (isQueue && isTopic) {
                                Object[] options = new Object[]{"Queue", "Topic"};
                                int n = JOptionPane.showOptionDialog((Component)((Object)HermesBrowser.getBrowser()), "This XML is from an older version of Hermes and it is unclear which domain the destination\n" + destinationConfig.getName() + " for session " + hermes.getId() + " is in. Please choose whether queue or topic domain", "Select domain", 0, 3, null, options, options[1]);
                                if (n == 0) {
                                    isQueue = true;
                                    isTopic = false;
                                    log.info((Object)(destinationConfig.getName() + " is now in the queue domain"));
                                } else {
                                    isQueue = false;
                                    isTopic = true;
                                    log.info((Object)(destinationConfig.getName() + " is now in the topic domain"));
                                }
                            }
                            if (isQueue) {
                                destinationConfig.setDomain(Domain.QUEUE.getId());
                            } else if (isTopic) {
                                destinationConfig.setDomain(Domain.TOPIC.getId());
                            }
                        }
                        this.notifyDestinationAdded(hermes, destinationConfig);
                    }
                }
                catch (Throwable t) {
                    log.error((Object)("unable to create Hermes instance " + firstSession.getId() + ": " + t.getMessage()), t);
                }
            }
            return rval;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new HermesException(e);
        }
    }

    @Override
    public Hermes createHermes(FactoryConfig factoryConfig) throws JAXBException, IOException, JMSException, NamingException, InstantiationException, ClassNotFoundException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        DefaultHermesImpl hermes = null;
        boolean isJNDI = false;
        ConnectionFactoryManagerImpl connectionFactoryManager = null;
        ConnectionFactory connectionFactory = null;
        if (factoryConfig.getExtension() == null) {
            factoryConfig.setExtension(HermesBrowser.getConfigDAO().createDefaultProviderExtConfig(factoryConfig.getProvider().getClassName()));
        }
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (factoryConfig.getClasspathId() == null) {
            factoryConfig.setClasspathId("Default");
        }
        classLoader = this.classLoaderManager.createClassLoader(factoryConfig.getClasspathId(), factoryConfig.getExtension());
        Thread.currentThread().setContextClassLoader(classLoader);
        connectionFactoryManager = new ConnectionFactoryManagerImpl(this.classLoaderManager, factoryConfig);
        connectionFactory = connectionFactoryManager.getConnectionFactory();
        if (connectionFactory instanceof JNDIConnectionFactory) {
            isJNDI = true;
            JNDIConnectionFactory jndiFactory = (JNDIConnectionFactory)connectionFactory;
            jndiFactory._setDelegateClassLoader(classLoader);
        }
        Iterator<DestinationConfig> iter2 = factoryConfig.getDestination().iterator();
        while (iter2.hasNext()) {
            DestinationConfig destinationConfig = iter2.next();
            if (destinationConfig.isDurable() && destinationConfig.getClientID() == null) {
                log.warn((Object)("removing durable subscription to " + destinationConfig.getName() + "with a null clientID"));
                iter2.remove();
                continue;
            }
            connectionFactoryManager.addDestinationConfig(destinationConfig);
        }
        if (factoryConfig.getConnection().size() > 0) {
            ConnectionConfig connectionConfig = factoryConfig.getConnection().get(0);
            ConnectionManager connectionManager = null;
            connectionManager = connectionConfig.isConnectionPerThread() ? ConnectionManagerFactory.create(ConnectionManager.Policy.CONNECTION_PER_THREAD) : ConnectionManagerFactory.create(ConnectionManager.Policy.SHARED_CONNECTION);
            connectionManager.setClientID(connectionConfig.getClientID());
            connectionManager.setUsername(connectionConfig.getUsername());
            connectionManager.setPassword(connectionConfig.getPassword());
            if (connectionConfig.getSession().size() > 0) {
                ThreadLocalSessionManager sessionManager;
                SessionConfig sessionConfig = connectionConfig.getSession().get(0);
                if (isJNDI) {
                    JNDIConnectionFactory jndiCF = (JNDIConnectionFactory)connectionFactory;
                    jndiCF._setDelegateClassLoader(classLoader);
                    JNDIDestinationManager destinationManager = new JNDIDestinationManager(jndiCF._getProperties(), true);
                    sessionManager = new ThreadLocalSessionManager(sessionConfig, destinationManager);
                } else {
                    SimpleDestinationManager destinationManager = new SimpleDestinationManager();
                    sessionManager = new ThreadLocalSessionManager(sessionConfig, destinationManager);
                }
                log.debug((Object)("SESSION IS " + sessionConfig.getId()));
                if (sessionConfig.getReconnects() != null) {
                    sessionManager.setReconnects(sessionConfig.getReconnects().intValue());
                }
                this.classLoaderManager.putClassLoaderByHermes(sessionConfig.getId(), classLoader);
                this.factoryConfigById.put(sessionConfig.getId(), factoryConfig);
                sessionManager.setTransacted(sessionConfig.isTransacted());
                sessionManager.setId(sessionConfig.getId());
                sessionManager.setFactoryConfig(factoryConfig);
                sessionManager.setAudit(sessionConfig.isAudit());
                sessionManager.setParent(connectionManager);
                connectionManager.setParent(connectionFactoryManager);
                if (this.config.getAuditDirectory() != null) {
                    sessionManager.setAuditDirectory(this.config.getAuditDirectory());
                } else if (sessionConfig.getAuditDirectory() != null) {
                    sessionManager.setAuditDirectory(sessionConfig.getAuditDirectory());
                }
                connectionManager.addChild(sessionManager);
                hermes = new DefaultHermesImpl(factoryConfig.getExtension(), sessionManager, classLoader);
                connectionFactoryManager.addChild(connectionManager);
                connectionManager.setHermes(hermes);
            }
        }
        return hermes;
    }

    @Override
    public HermesConfig getConfig() throws HermesException {
        return this.config;
    }

    private static void copyFile(String src, String dest) throws IOException {
        File destFile = new File(dest);
        if (destFile.exists()) {
            destFile.delete();
        }
        FileChannel srcChannel = new FileInputStream(src).getChannel();
        FileChannel dstChannel = new FileOutputStream(dest).getChannel();
        dstChannel.transferFrom(srcChannel, 0L, srcChannel.size());
        srcChannel.close();
        dstChannel.close();
    }

    @Override
    public void setProperties(Hashtable map) {
        this.properties = map;
    }

    @Override
    public Iterator getConfigurationListeners() {
        return this.listeners.iterator();
    }

    @Override
    public void addConfigurationListener(HermesConfigurationListener listener) {
        this.listeners.add(listener);
        try {
            NamingEnumeration<Binding> e = this.context.listBindings("");
            while (e.hasMore()) {
                Binding binding = e.next();
                try {
                    if (!(this.context.lookup(binding.getName()) instanceof Hermes)) continue;
                    Hermes hermes = (Hermes)this.context.lookup(binding.getName());
                    listener.onHermesAdded(hermes);
                    Iterator diter = hermes.getDestinations();
                    while (diter.hasNext()) {
                        DestinationConfig destinationConfig = (DestinationConfig)diter.next();
                        listener.onDestinationAdded(hermes, destinationConfig);
                    }
                }
                catch (NamingException ex) {
                }
            }
            for (NamingConfig namingConfig : this.config.getNaming()) {
                listener.onNamingAdded(namingConfig);
            }
        }
        catch (NamingException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void removeConfigurationListener(HermesConfigurationListener listener) {
        this.listeners.remove(listener);
    }

    public void notifyNamingAdded(NamingConfig namingConfig) {
        for (HermesConfigurationListener listener : this.listeners) {
            listener.onNamingAdded(namingConfig);
        }
    }

    @Override
    public void notifyNamingRemoved(NamingConfig namingConfig) {
        for (HermesConfigurationListener listener : this.listeners) {
            listener.onNamingRemoved(namingConfig);
        }
    }

    public void notifyHermesAdded(Hermes hermes) {
        for (HermesConfigurationListener listener : this.listeners) {
            listener.onHermesAdded(hermes);
        }
    }

    @Override
    public void notifyHermesRemoved(Hermes hermes) {
        for (HermesConfigurationListener listener : this.listeners) {
            listener.onHermesRemoved(hermes);
        }
    }

    public void notifyDestinationAdded(Hermes hermes, DestinationConfig destinationConfig) {
        for (HermesConfigurationListener listener : this.listeners) {
            listener.onDestinationAdded(hermes, destinationConfig);
        }
    }

    public void notifyDestinationRemoved(Hermes hermes, DestinationConfig destinationConfig) {
        for (HermesConfigurationListener listener : this.listeners) {
            listener.onDestinationRemoved(hermes, destinationConfig);
        }
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public void setExtensionLoaderClass(String extensionLoader) {
        this.extensionLoaderClass = extensionLoader;
    }

    @Override
    public ClassLoaderManager getClassLoaderManager() {
        return this.classLoaderManager;
    }

    public boolean isIgnoreClasspathGroups() {
        return this.ignoreClasspathGroups;
    }

    @Override
    public void setIgnoreClasspathGroups(boolean ignoreClasspathGroups) {
        this.ignoreClasspathGroups = ignoreClasspathGroups;
    }
}

