/*
 * Decompiled with CFR 0.152.
 */
package hermes;

import hermes.HermesContext;
import hermes.HermesLoader;
import hermes.JAXBHermesLoader;
import hermes.SingletonManager;
import hermes.browser.tasks.ThreadPool;
import hermes.impl.SimpleClassLoaderManager;
import hermes.util.JVMUtils;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HermesInitialContextFactory
implements InitialContextFactory {
    private static final Logger log = Logger.getLogger(HermesInitialContextFactory.class);
    private static final String LOADER = "hermes.loader";
    private static final String EXTENSION_LOADER = "hermes.extensionLoader";
    private static final String IGNORE_CLASSPATHGROUPS = "hermes.ignoreClasspathGroups";

    public HermesInitialContextFactory() {
        JVMUtils.forceInit(SingletonManager.class);
        JVMUtils.forceInit(ThreadPool.class);
        JVMUtils.forceInit(SimpleClassLoaderManager.class);
    }

    @Override
    public Context getInitialContext(Hashtable<?, ?> map) throws NamingException {
        String className = (String)map.get(LOADER);
        if (className == null) {
            className = JAXBHermesLoader.class.getName();
        }
        log.debug((Object)("loader=" + className));
        try {
            HermesLoader loader = (HermesLoader)Class.forName(className).newInstance();
            if (map.containsKey(EXTENSION_LOADER)) {
                loader.setExtensionLoaderClass((String)map.get(EXTENSION_LOADER));
            }
            if (map.containsKey(IGNORE_CLASSPATHGROUPS)) {
                loader.setIgnoreClasspathGroups(true);
            }
            HermesContext context = new HermesContext(map, loader);
            loader.setProperties(map);
            loader.setContext(context);
            context.load();
            return context;
        }
        catch (InstantiationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new NamingException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new NamingException(e.getMessage());
        }
        catch (ClassNotFoundException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new NamingException(e.getMessage());
        }
    }
}

