/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.util;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import edu.emory.mathcs.backport.java.util.concurrent.locks.ReadWriteLock;
import edu.emory.mathcs.backport.java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.mina.util.ExpirationListener;

public class ExpiringMap
implements Map {
    public static final int DEFAULT_TIME_TO_LIVE = 60;
    public static final int DEFAULT_EXPIRATION_INTERVAL = 1;
    private static volatile int expirerCount = 1;
    private final ConcurrentHashMap delegate;
    private final CopyOnWriteArrayList expirationListeners;
    private final Expirer expirer;

    public ExpiringMap() {
        this(60, 1);
    }

    public ExpiringMap(int timeToLive) {
        this(timeToLive, 1);
    }

    public ExpiringMap(int timeToLive, int expirationInterval) {
        this(new ConcurrentHashMap(), new CopyOnWriteArrayList(), timeToLive, expirationInterval);
    }

    private ExpiringMap(ConcurrentHashMap delegate, CopyOnWriteArrayList expirationListeners, int timeToLive, int expirationInterval) {
        this.delegate = delegate;
        this.expirationListeners = expirationListeners;
        this.expirer = new Expirer();
        this.expirer.setTimeToLive(timeToLive);
        this.expirer.setExpirationInterval(expirationInterval);
    }

    public Object put(Object key, Object value) {
        return this.delegate.put(key, (Object)new ExpiringObject(key, value, System.currentTimeMillis()));
    }

    public Object get(Object key) {
        Object object = this.delegate.get(key);
        if (object != null) {
            ExpiringObject expObject = (ExpiringObject)object;
            expObject.setLastAccessTime(System.currentTimeMillis());
            return expObject.getValue();
        }
        return object;
    }

    public Object remove(Object key) {
        return this.delegate.remove(key);
    }

    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public void clear() {
        this.delegate.clear();
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public Set keySet() {
        return this.delegate.keySet();
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(Map inMap) {
        Map map = inMap;
        synchronized (map) {
            Iterator inMapKeysIt = inMap.keySet().iterator();
            while (inMapKeysIt.hasNext()) {
                Object key = inMapKeysIt.next();
                Object value = inMap.get(key);
                if (!(value instanceof ExpiringObject)) continue;
                this.delegate.put(key, value);
            }
        }
    }

    public Collection values() {
        return this.delegate.values();
    }

    public Set entrySet() {
        return this.delegate.entrySet();
    }

    public void addExpirationListener(ExpirationListener listener) {
        this.expirationListeners.add((Object)listener);
    }

    public void removeExpirationListener(ExpirationListener listener) {
        this.expirationListeners.remove((Object)listener);
    }

    public Expirer getExpirer() {
        return this.expirer;
    }

    public int getExpirationInterval() {
        return this.expirer.getExpirationInterval();
    }

    public int getTimeToLive() {
        return this.expirer.getTimeToLive();
    }

    public void setExpirationInterval(int expirationInterval) {
        this.expirer.setExpirationInterval(expirationInterval);
    }

    public void setTimeToLive(int timeToLive) {
        this.expirer.setTimeToLive(timeToLive);
    }

    static /* synthetic */ int access$008() {
        return expirerCount++;
    }

    public class Expirer
    implements Runnable {
        private ReadWriteLock stateLock = new ReentrantReadWriteLock();
        private long timeToLiveMillis;
        private long expirationIntervalMillis;
        private boolean running = false;
        private final Thread expirerThread = new Thread((Runnable)this, "ExpiringMapExpirer-" + ExpiringMap.access$008());

        public Expirer() {
            this.expirerThread.setDaemon(true);
        }

        public void run() {
            while (this.running) {
                this.processExpires();
                try {
                    Thread.sleep(this.expirationIntervalMillis);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        private void processExpires() {
            long timeNow = System.currentTimeMillis();
            Iterator expiringObjectsIterator = ExpiringMap.this.delegate.values().iterator();
            while (expiringObjectsIterator.hasNext()) {
                long timeIdle;
                ExpiringObject expObject = (ExpiringObject)expiringObjectsIterator.next();
                if (this.timeToLiveMillis <= 0L || (timeIdle = timeNow - expObject.getLastAccessTime()) < this.timeToLiveMillis) continue;
                ExpiringMap.this.delegate.remove(expObject.getKey());
                Iterator listenerIterator = ExpiringMap.this.expirationListeners.iterator();
                while (listenerIterator.hasNext()) {
                    ExpirationListener listener = (ExpirationListener)listenerIterator.next();
                    listener.expired(expObject.getValue());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void startExpiring() {
            this.stateLock.writeLock().lock();
            try {
                if (!this.running) {
                    this.running = true;
                    this.expirerThread.start();
                }
            }
            finally {
                this.stateLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void startExpiringIfNotStarted() {
            this.stateLock.readLock().lock();
            if (this.running) {
                this.stateLock.readLock().unlock();
                return;
            }
            this.stateLock.writeLock().lock();
            try {
                if (!this.running) {
                    this.running = true;
                    this.expirerThread.start();
                }
            }
            finally {
                this.stateLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopExpiring() {
            this.stateLock.writeLock().lock();
            try {
                if (this.running) {
                    this.running = false;
                    this.expirerThread.interrupt();
                }
            }
            finally {
                this.stateLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isRunning() {
            this.stateLock.readLock().lock();
            try {
                boolean bl = this.running;
                return bl;
            }
            finally {
                this.stateLock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getTimeToLive() {
            this.stateLock.readLock().lock();
            try {
                int n = (int)this.timeToLiveMillis / 1000;
                return n;
            }
            finally {
                this.stateLock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setTimeToLive(long timeToLive) {
            this.stateLock.writeLock().lock();
            try {
                this.timeToLiveMillis = timeToLive * 1000L;
            }
            finally {
                this.stateLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getExpirationInterval() {
            this.stateLock.readLock().lock();
            try {
                int n = (int)this.expirationIntervalMillis / 1000;
                return n;
            }
            finally {
                this.stateLock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setExpirationInterval(long expirationInterval) {
            this.stateLock.writeLock().lock();
            try {
                this.expirationIntervalMillis = expirationInterval * 1000L;
            }
            finally {
                this.stateLock.writeLock().unlock();
            }
        }
    }

    private class ExpiringObject {
        private Object key;
        private Object value;
        private long lastAccessTime;
        private ReadWriteLock lastAccessTimeLock = new ReentrantReadWriteLock();

        public ExpiringObject(Object key, Object value, long lastAccessTime) {
            if (value == null) {
                throw new IllegalArgumentException("An expiring object cannot be null.");
            }
            this.key = key;
            this.value = value;
            this.lastAccessTime = lastAccessTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getLastAccessTime() {
            this.lastAccessTimeLock.readLock().lock();
            try {
                long l = this.lastAccessTime;
                return l;
            }
            finally {
                this.lastAccessTimeLock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setLastAccessTime(long lastAccessTime) {
            this.lastAccessTimeLock.writeLock().lock();
            try {
                this.lastAccessTime = lastAccessTime;
            }
            finally {
                this.lastAccessTimeLock.writeLock().unlock();
            }
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean equals(Object obj) {
            return this.value.equals(obj);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

