/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.vmpipe;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoSessionConfig;
import org.apache.mina.common.support.BaseIoAcceptor;
import org.apache.mina.common.support.BaseIoAcceptorConfig;
import org.apache.mina.common.support.BaseIoSessionConfig;
import org.apache.mina.transport.vmpipe.VmPipeAddress;
import org.apache.mina.transport.vmpipe.support.VmPipe;

public class VmPipeAcceptor
extends BaseIoAcceptor {
    static final Map boundHandlers = new HashMap();
    private static final IoSessionConfig CONFIG = new BaseIoSessionConfig(){};
    private final IoServiceConfig defaultConfig = new BaseIoAcceptorConfig(){

        public IoSessionConfig getSessionConfig() {
            return CONFIG;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(SocketAddress address, IoHandler handler, IoServiceConfig config) throws IOException {
        if (address == null) {
            throw new NullPointerException("address");
        }
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        if (!(address instanceof VmPipeAddress)) {
            throw new IllegalArgumentException("address must be VmPipeAddress.");
        }
        if (config == null) {
            config = this.getDefaultConfig();
        }
        Map map = boundHandlers;
        synchronized (map) {
            if (boundHandlers.containsKey(address)) {
                throw new IOException("Address already bound: " + address);
            }
            boundHandlers.put(address, new VmPipe(this, (VmPipeAddress)address, handler, config, this.getListeners()));
        }
        this.getListeners().fireServiceActivated(this, address, handler, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(SocketAddress address) {
        if (address == null) {
            throw new NullPointerException("address");
        }
        VmPipe pipe = null;
        Map map = boundHandlers;
        synchronized (map) {
            if (!boundHandlers.containsKey(address)) {
                throw new IllegalArgumentException("Address not bound: " + address);
            }
            pipe = (VmPipe)boundHandlers.remove(address);
        }
        this.getListeners().fireServiceDeactivated(this, pipe.getAddress(), pipe.getHandler(), pipe.getConfig());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindAll() {
        Map map = boundHandlers;
        synchronized (map) {
            ArrayList addresses = new ArrayList(boundHandlers.keySet());
            Iterator i = addresses.iterator();
            while (i.hasNext()) {
                this.unbind((SocketAddress)i.next());
            }
        }
    }

    public IoServiceConfig getDefaultConfig() {
        return this.defaultConfig;
    }
}

