/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane;

import java.io.CharArrayReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import javax.swing.text.Segment;
import javax.swing.undo.UndoManager;
import jsyntaxpane.CompoundUndoManager;
import jsyntaxpane.Lexer;
import jsyntaxpane.Token;
import jsyntaxpane.TokenType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyntaxDocument
extends PlainDocument {
    Lexer lexer;
    List<Token> tokens;
    UndoManager undo = new CompoundUndoManager();
    private static Logger log = Logger.getLogger(SyntaxDocument.class.getName());

    public SyntaxDocument(Lexer lexer) {
        this.putProperty("tabSize", 4);
        this.lexer = lexer;
        this.addUndoableEditListener(new UndoableEditListener(){

            public void undoableEditHappened(UndoableEditEvent evt) {
                if (evt.getEdit().isSignificant()) {
                    SyntaxDocument.this.undo.addEdit(evt.getEdit());
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void parse() {
        ArrayList<Token> toks;
        block9: {
            if (this.lexer == null) {
                this.tokens = null;
                return;
            }
            toks = new ArrayList<Token>(this.getLength() / 10);
            long ts = System.nanoTime();
            int len = this.getLength();
            try {
                Token token;
                Segment seg = new Segment();
                this.getText(0, this.getLength(), seg);
                CharArrayReader reader = new CharArrayReader(seg.array, seg.offset, seg.count);
                this.lexer.yyreset(reader);
                while ((token = this.lexer.yylex()) != null) {
                    toks.add(token);
                }
                if (!log.isLoggable(Level.FINEST)) break block9;
            }
            catch (BadLocationException ex) {
                block10: {
                    log.log(Level.SEVERE, null, ex);
                    if (!log.isLoggable(Level.FINEST)) break block10;
                    log.finest(String.format("Parsed %d in %d ms, giving %d tokens\n", len, (System.nanoTime() - ts) / 1000000L, toks.size()));
                }
                this.tokens = toks;
            }
            catch (IOException ex2) {
                block11: {
                    log.log(Level.SEVERE, null, ex2);
                    if (!log.isLoggable(Level.FINEST)) break block11;
                    {
                        catch (Throwable throwable) {
                            if (log.isLoggable(Level.FINEST)) {
                                log.finest(String.format("Parsed %d in %d ms, giving %d tokens\n", len, (System.nanoTime() - ts) / 1000000L, toks.size()));
                            }
                            this.tokens = toks;
                            throw throwable;
                        }
                    }
                    log.finest(String.format("Parsed %d in %d ms, giving %d tokens\n", len, (System.nanoTime() - ts) / 1000000L, toks.size()));
                }
                this.tokens = toks;
            }
            log.finest(String.format("Parsed %d in %d ms, giving %d tokens\n", len, (System.nanoTime() - ts) / 1000000L, toks.size()));
        }
        this.tokens = toks;
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        super.insertString(offs, str, a);
        this.parse();
    }

    @Override
    public void remove(int offs, int len) throws BadLocationException {
        super.remove(offs, len);
        this.parse();
    }

    @Override
    public void replace(int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
        super.replace(offset, length, text, attrs);
        this.parse();
    }

    protected Iterator<Token> getTokens(int start, int end) {
        return new TokenIterator(start, end);
    }

    public Token getTokenAt(int pos) {
        if (this.tokens == null || this.tokens.isEmpty() || pos > this.getLength()) {
            return null;
        }
        Token tok = null;
        Token tKey = new Token(TokenType.DEFAULT, pos, 1);
        int ndx = Collections.binarySearch(this.tokens, tKey);
        if (ndx < 0) {
            ndx = -ndx - 1 - 1 < 0 ? 0 : -ndx - 1 - 1;
            Token t = this.tokens.get(ndx);
            if (t.start <= pos && pos <= t.start + t.length) {
                tok = t;
            }
        } else {
            tok = this.tokens.get(ndx);
        }
        return tok;
    }

    public void doUndo() {
        if (this.undo.canUndo()) {
            this.undo.undo();
            this.parse();
        }
    }

    public void doRedo() {
        if (this.undo.canRedo()) {
            this.undo.redo();
            this.parse();
        }
    }

    public void clearUndos() {
        this.undo.discardAllEdits();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TokenIterator
    implements Iterator<Token> {
        int start;
        int end;
        int ndx = 0;

        private TokenIterator(int start, int end) {
            this.start = start;
            this.end = end;
            if (SyntaxDocument.this.tokens != null && !SyntaxDocument.this.tokens.isEmpty()) {
                Token token = new Token(TokenType.COMMENT, start, end - start);
                this.ndx = Collections.binarySearch(SyntaxDocument.this.tokens, token);
                if (this.ndx < 0) {
                    this.ndx = -this.ndx - 1 - 1 < 0 ? 0 : -this.ndx - 1 - 1;
                    Token t = SyntaxDocument.this.tokens.get(this.ndx);
                    if (t.start + t.length <= start) {
                        ++this.ndx;
                    }
                }
            }
        }

        @Override
        public boolean hasNext() {
            if (SyntaxDocument.this.tokens == null) {
                return false;
            }
            if (this.ndx >= SyntaxDocument.this.tokens.size()) {
                return false;
            }
            Token t = SyntaxDocument.this.tokens.get(this.ndx);
            return t.start < this.end;
        }

        @Override
        public Token next() {
            return SyntaxDocument.this.tokens.get(this.ndx++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

